functor ReviseFUN (structure Graph : GRAPH) : REVISE =
struct
 structure Graph = Graph

  (* Primarily consists of the revise function used by search to
     reverse the start goal node,s dependent on the desired
     direction of search. Although paths found in an abstract level
     for DAG's are not guaranteed to be refinable in the classic sense,
     tree abstractions are refinable except for the start node. This function
     looks for that condition and revises the start node to be all the
     adjacent classes of nodes reachable by the start node for the next
     the next inferior graph. The same correction is applied to the
     goal node if the graph is searched in the reverse direction *) 

local open Graph in

    val down =  (fn Node{succs,...} => !succs)
    val up = (fn Node{preds,...} => !preds)

    fun refineNode for back flag' (n as (Node{class=ref(SOME
		(c as  Node{flag,...})),...})) set =
       (inc edgeCount ; 
         if (flag =  flag') then (if (length (back n) = 1) 
				then refine for back (for n) flag'  set else set)
         else case flag of (ref Stop) => set  
			    | flag''  => (flag'' := Stop; (c :: set)))

    and refine for back  [] flag set = set
      | refine for back (node::nodes) flag set = 
            refine for back nodes flag (refineNode for back flag node set)

    fun startInTree (sn as (Node {preds,...}))
		    (n as(Node {absType = ref ForeTree,flag,...})) =
        if ((length (!preds)) = 1) 
 	 then ([n],(refineNode down up flag sn []))
	 else ([],[n])
      |  startInTree _ n =  ([],[n])

    fun goalInTree (sn as (Node {succs,...}))
		   (n as(Node {absType = ref BackTree,flag,...})) =
        if ((length (!succs)) = 1) 
         then  ([n],(refineNode up down flag sn  []))
	 else ([],[n])
      |  goalInTree _ n =  ([],[n])

    fun revise fore subFrom from subTo to  = 
        (if fore then (fn x => x) else rev) [([],from),([],to)]
      (*  ( if sameNode subFrom (hd from) then [([],from),([],to)]
            else  [(startInTree subFrom (hd from)),(goalInTree subTo (hd to))]) *)

end
end
