functor PuzzleGraphFUN (GenericPuzzle: GENERIC_PUZZLE) : GENERIC_GRAPH =

struct
local open GenericPuzzle in

 structure Graph = GraphFUN(type state = internal_state)

 type graph = Graph.graph
 type puzzle_parameter = puzzle_parameter
 type internal_state   = internal_state
 type external_state   = external_state
 type peektype = Graph.groundState -> (Graph.node) option

 structure HashState =
 struct
  type state = internal_state
  val  sameState = sameState
  val  hashState = hashState
 end

 structure AbsFunctions = 
   AbsFunctionsFUN (structure Graph = Graph)

 structure AbstractionGenerator =
   AbsAbstractionGeneratorFUN (structure Graph = Graph
				     and AbsFunctions = AbsFunctions)

 structure GraphGenerator =
  AbsGraphGeneratorFUN
     (structure Graph                = Graph
            and HashState            = HashState
            and AbstractionGenerator = AbstractionGenerator)

 type abstraction_parameter = GraphGenerator.abstraction_parameter 

 fun mkSearchSpace puzzle_parameter =
 let val {randomStatePair,encode,decode,successor,initialStates,...} =
                                                mkInstance puzzle_parameter
 in
   { graph  = (GraphGenerator.graphGenerator successor initialStates),
     encode = encode,
     decode = decode,
     randomStatePair = randomStatePair
   }

 end
end
end
