structure Priority_Queue : PRIORITY_QUEUE =
struct
local open Array in

 val optCount = ref 0
 val nfCount = ref 0
 val lastQueue = ref 0

 datatype 'a queue = Queue of
  { size    : int ref,
    current : int ref,
    entries : 'a list array }

 fun mkEmpty n = (lastQueue := 0 ; 
   Queue{size=ref 0,current=ref 0,entries=array(2*n,[])})

 fun isEmpty (Queue{size=ref 0,...}) = true
   | isEmpty _ = false

 fun enqueue (x,n,q as Queue{size,current,entries}) =
 let val k = 2*n+1
 in
    size := 1 + !size;
    if n < 0 then update(entries,0,x::sub(entries,0))
	     else update(entries,k,x::sub(entries,k));
    if n > !current then  current := n	else ();
    q
 end

 fun dequeue (q as Queue{size,current,entries}) =
 let val i = 2*(!current)
     val _ = (if ((!current) > (!lastQueue) + 1) 
		then (inc optCount) else ();
		lastQueue:= (!current))
 in case sub(entries,i) of
      [] => let val j = i + 1
            in case sub(entries,j) of
                 [] => (current := firstNonEmpty (i-2) entries;
                        dequeue q)
                | _ => let val x::rest = rev (sub(entries,j))
                       in update(entries,j,[]);
                          update(entries,i,rest);
                          size := !size - 1;
                          x end
            end
    | x::rest => (update(entries,i,rest); size := !size - 1; x)
 end

 and firstNonEmpty n entries =
     (case sub(entries,n) of
        [] => (case sub(entries,n+1) of
                 [] => firstNonEmpty (n-2) entries
               | _ => n div 2)
      | _ => n div 2)

end
end
