functor NoAbsFUN (structure Graph : GRAPH):  BFS=  
struct
 structure Graph = Graph
local open Graph Queue in

     fun init _ _ _ = ()

    fun bfs neighbours absPathLength start =
       let fun searchFrom start = 
		doQueue (revfold (fn (node,queue) => enqueue((1,node),queue)) 
		  start empty)
           and  doQueue queue =
              	if isEmpty(queue) then NONE else
       		let val ((_,node),queue)  = dequeue(queue)
           	in doSuccs (neighbours node) (Back (1,node)) queue  end

    	 and doSuccs [] _ queue  = doQueue queue 
            | doSuccs ((node as Node{flag,...})::nodes) back queue =
	 	(inc edgeCount ;
         	(case !flag of
            	  Stop   => (flag:=back; SOME node)
           	| Other  => (flag:=back; allNodes := node :: (!allNodes);
				doSuccs nodes back (enqueue((1,node),queue)))
          	| _      => doSuccs nodes back queue))
         in searchFrom start end
end
end
