functor AbsSearchFUN (Search : SEARCH) : ABS_SEARCH =
struct
 structure Search = Search
local open WorkingMemory Search Search.Graph in

 (* Function used to count the edges traversed at each level of
     abstraction, for testing purposes *)
 fun edges path = (edgeCountList := (!edgeCount):: (!edgeCountList);
		   markCostList := (!markCost):: (!markCostList);
		   (case path of (NONE,_) => 
  		   pathLengthList := 0 :: (!pathLengthList)
		                | ((SOME p),_) =>
  		   pathLengthList := (length p):: (!pathLengthList));
       	       	   edgeCount := 0; markCost := 0; path)

 (* Climbs up the abstraction heirarchy until it reaches the top
    then descends finding the shortest path at each level. The path 
    found by the search function is passed to the search function at
    the lower level and is used to guide the search at this level *)

 fun findPath (start,goal,graph) = 
 let     
  val WM {searchType,...} = Wm
  fun getPath (subStart,subGoal,
	       from  as Node {class=class1,...},
               to    as Node {class=class2,...},
               graph as Graph{super,height,...}) =
   if class1=class2 then ((SOME [from]), height) else
   if !super=NONE orelse !class1=NONE orelse !class2=NONE
		  orelse (!searchType) = NAB
     then edges ((shortestPath (subStart,subGoal,[from],[to],graph,[])),height) else
   let val SOME absFrom  = !class1
       val SOME absTo    = !class2
       val SOME absGraph = !super
       fun refinePath (NONE,h) = (NONE,h)
         | refinePath ((SOME path),h) =
         ((shortestPath(subStart,subGoal,[from],[to],graph,path)),h)
   in edges (refinePath (getPath (from,to,absFrom,absTo,absGraph))) end
  in getPath (start,goal,start,goal,graph) end

end
end
