
   
(* New version, R. Holte, September 3, 1993.
   "pairs" extended to arbitrary successor-chains of a length specified
   by the global variable "chainlength".

   This would be better done using a parameter to the "Pairs" option
   in Chris's language, akin to the diameter parameter for Stars.

*)

val chainlength = ref 2 ;   (* the default is to generate pairs, as before  *)

functor AbsGeneratorPairsFUN (structure Graph : GRAPH) : ABSGEN  =

 (* CHAINS ... a generalization of PAIRS *)
 (* Make classes that are chains of successors.
    The first node in the given list serves as the starting point
    of the chain.  Choose a random successor and add it to the chain.
    Repeat this until either (1) the chain is the specified length,
    or (2) there is no available successor of the end node of the chain;
    a successor is only "available" if it is not already part of some class.
    
    As with the other abstraction methods, returns a triple of:
            the set of nodes to be combined,
            the list without the first node of this set and
            the abstract type is returned.
 *)
 
struct

structure Graph = Graph

local open Graph Random in

type CONDITIONparameter = unit
type ACTIONparameter    = unit

  fun nth_nonStop _ answer [] = answer
   | nth_nonStop count sofar (Node{flag= ref Stop,...}::tail) =
                       nth_nonStop (count-1) sofar tail
   | nth_nonStop count  _  (n::tail) = 
           if (count <= 1)
           then  (SOME n)
           else nth_nonStop (count-1) (SOME n) tail


 fun make_a_chain 0 answer = answer
  |  make_a_chain n (chain as ((Node{succs,...})::tail)) =
     let  val randomNeighbour = nth_nonStop (newrandom (length (!succs)))
                                            NONE (!succs)
      in case randomNeighbour of 
              SOME (rn as Node{flag,...}) =>
                        (flag := Stop; make_a_chain (n-1) (rn::chain))
           |  NONE  => chain
      end


 fun ACTION _ ((thisNode as (Node{flag,...}))::ns) = 
 let val new_chain = (flag := Stop ;
                      make_a_chain ((!chainlength)-1) [thisNode] )
     val chaintype = if (length new_chain) = 1
                     then  Another
                     else  Pair
 in  (new_chain,ns,chaintype)
 end

 fun CONDITION _ _ = true    (* Always apply this generator
                                if it is in the function list *)

end
end
