functor AbsGeneratorCompressFUN (structure Graph : GRAPH) : ABSGEN  =


  (* PAIRS  COMPRESS ARCS *)

  (* Combines pairs of nodes, with the aim of minimising the number of edges in the
     next abstract level. At present the heuristic used is to find two connected
     nodes that have a common neighbour, either successor or predecessor. If no such
     pair exists then the last node is paired with any succesor that is not marked
     with a stop flag. Only if no such neighbour exists is a single node returned. As
     with the other abstraction methods a triple of the set of nodes to be combined,
     the list without the first node of this set and the abstract type is returned. *)

struct

structure Graph = Graph

local open Graph in

type CONDITIONparameter = unit
type ACTIONparameter    = unit


 fun ACTION _ nodes = 
    let fun sameNeighbour nbs1 nbs2 = fold (fn (x,y) => (exists (sameNode x) nbs1) orelse y) nbs2  false

	fun markStop (Node {flag,...}) = flag := Stop

	fun getFirst newList bestNode [] = (((hd newList)::bestNode), (tl newList))
	  | getFirst newList bestNode (Node{flag= ref Stop,...}::ns) = getFirst newList bestNode ns 
	  | getFirst newList bestNode ((node as 
			(Node{succs,class=ref(SOME(Node{preds,succs=succs',...})),...}))::ns) =
                case (loop (!preds) (!succs') [] (!succs)) of
        	        (false,best) => getFirst (node::newList) best ns
                       | (_, [best]) => ([node,best],(newList @ ns))

        and loop _ _ bestNode  [] = (false,bestNode)
   	  | loop p s bestNode (Node{flag= ref Stop,...}::ns) = loop p s bestNode ns
   	  | loop p s bestNode ((n as (Node{class=ref(SOME(Node{preds,succs,...})),...}))::ns) = 
                    if (sameNeighbour p (!preds)) orelse (sameNeighbour s (!succs))
			then (true,[n])  else loop p s [n] ns

      in case (getFirst [] [] nodes) of 
	      ([n],l) =>([n],l,Another)
	    | ([n1,n2],l)  => (markStop n1; markStop n2; ([n1,n2],l,Pair)) end
 

   (* Always apply this generator if it is in the function list *)
 fun CONDITION _ _  = true 

end
end
