functor AbsFunctionsFUN (structure Graph : GRAPH) : ABS_FUNCTIONS =


struct
 structure Graph = Graph

 (* Define the structures for each type of abstraction method *)
 (* these should all have signature ABSGEN *)

 structure AbsGeneratorTrees  = 
   AbsGeneratorTreesFUN (structure Graph = Graph)

 structure AbsGeneratorStars  = 
   AbsGeneratorStarsFUN (structure Graph = Graph)
 
 structure AbsGeneratorBiasStars  = 
   AbsGeneratorBiasStarsFUN (structure Graph = Graph) 
 
 structure AbsGeneratorPairs  = 
   AbsGeneratorPairsFUN (structure Graph = Graph)

  structure AbsGeneratorCompress  = 
   AbsGeneratorCompressFUN (structure Graph = Graph)

  structure AbsGeneratorOrphans  = 
   AbsGeneratorOrphansFUN (structure Graph = Graph) 

  structure AbsGeneratorBypass  = 
   AbsGeneratorBypassFUN (structure Graph = Graph) 

  structure AbsGeneratorAlts  = 
   AbsGeneratorAltsFUN (structure Graph = Graph) 

local open Graph Random WorkingMemory in

 (* This functor creates lists of function couples as described below.
    Each couple is associated with one abstraction method. The list
    created decribes a sequence of these methods which are selectively
    applied to a graph to produce the next level in the abstraction
    hierarchy. At present there are various types of Star, Tree and
    pair abstractions. These are discussed more fully in the associated
    files *)

datatype absSelect  =  SsM of int | SpM of int | SpsM of int
                     | SsR of int | SpR of int | SpsR of int |  SDd of int
                     | T |  P | Pc | N | NA | A | BS | SPd | By of int | Alts
		     | \\ of (absSelect * absSelect)

infixr  \\

 (* The following defines function couples of the form 
    testForGen graph :  graph -> bool
			measure a property of the graph to determine if the
			following abstraction generating function should be
			applied. 
    nextGroup nodes  : node list -> (node list * node list)
			select a node from the list and 
			return the list of nodes that should be combined with
			the node to form an abstract class plus the rest of 
			the list 	
    One couple is produced for each abstraction method *)
 
 
 (* Sets the graph type which will determine search
    direction dependent on the preferred search direction *)

 fun setGraph test (graph as Graph{graphType,...}) = 
  let val truth = test graph
      val WM {searchDirection,...} = Wm
  in (if (!searchDirection) then graphType := SearchForward
			    else graphType := SearchBackward; truth) end

 fun mkFnRecord test group = 
	{testForGen = (setGraph test), nextGroup = group} 

   (* Extracts the individual abstraction methods moving from
      left to right across the method descriptor forming the 
      function couple list *)


 fun setBestDirection (graph as Graph{nodes,...}) = 
  let val compFactor  = 
	fold (fn (Node{preds,succs,...},total) => 
                       let val s = (length (!succs)) + 1
                           val p = (length (!preds)) + 1
			in if s > p then  ((total - 1.0) + (real s)/( real p)) 
				    else  ((total + 1.0) - (real p)/(real s)) end ) nodes 0.0
      val WM {forward,searchDirection,...} = Wm
  in (if (compFactor < 0.0) 
	then (searchDirection := true;  forward := true) 
	else (searchDirection := false; forward := false); false) end


 exception bad_abstraction_method

 fun defAbs (A\\y)  = (fn WM {alternating,forward,searchDirection,...} => 
		 	(alternating :=true; searchDirection := !forward;
			 forward := not (!forward);(buildMethod y))) Wm
   | defAbs (NA\\y) = (fn WM {alternating,...} => (alternating :=false;
                      ((mkFnRecord setBestDirection (fn _ => ([],[],Another)))
				 :: (buildMethod y)))) Wm
   | defAbs  _      = raise bad_abstraction_method
  
  
 and  buildMethod T       = [(mkFnRecord
                                 (AbsGeneratorTrees.CONDITION (true,Wm))
                                 (AbsGeneratorTrees.ACTION     true)),
			     (mkFnRecord
                                 (AbsGeneratorTrees.CONDITION (false,Wm))
                                 (AbsGeneratorTrees.ACTION     false))]
   | buildMethod P        = [(mkFnRecord
                                 (AbsGeneratorPairs.CONDITION  () )
                                 (AbsGeneratorPairs.ACTION     () ))]
   | buildMethod Pc       = [(mkFnRecord 
                                 (AbsGeneratorBiasStars.CONDITION  () )
                                 (AbsGeneratorBiasStars.ACTION     () ))]
   | buildMethod Alts     = [(mkFnRecord 
                                 (AbsGeneratorAlts.CONDITION  () )
                                 (AbsGeneratorAlts.ACTION     () ))]
   | buildMethod (By d)   = [(mkFnRecord
                                 (AbsGeneratorBypass.CONDITION  () )
                                 (AbsGeneratorBypass.ACTION     d  ))]
   | buildMethod BS       = [(mkFnRecord
                                 (AbsGeneratorCompress.CONDITION  () )
                                 (AbsGeneratorCompress.ACTION     () ))]
   | buildMethod (SsM n)  = [(mkFnRecord
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("s","max",n)))]
   | buildMethod (SpM n)  = [(mkFnRecord 
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("p","max",n)))]
   | buildMethod (SpsM n) = [(mkFnRecord 
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("ps","max",n)))]
   | buildMethod (SsR n)  = [(mkFnRecord 
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("s","random",n)))]
   | buildMethod (SpR n)  = [(mkFnRecord 
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("p","random",n)))]
   | buildMethod (SpsR n) = [(mkFnRecord 
                                 (AbsGeneratorStars.CONDITION (NONE,false))
                                 (AbsGeneratorStars.ACTION ("ps","random",n)))]
   | buildMethod (SDd n)  = [(mkFnRecord
                                 (AbsGeneratorStars.CONDITION (SOME Wm,true))
                                 (AbsGeneratorStars.ACTION ("p","max",n))),
			     (mkFnRecord
                                 (AbsGeneratorStars.CONDITION (SOME Wm,false))
                                 (AbsGeneratorStars.ACTION ("s","max",n)))]
   | buildMethod (SPd)  = progressive ((fn WM {absDiameter,...} => 
					let val diam = !absDiameter
					in inc absDiameter; diam end ) Wm)
   | buildMethod N        = [(mkFnRecord 
                                 (AbsGeneratorOrphans.CONDITION  () )
                                 (AbsGeneratorOrphans.ACTION     () ))]
   | buildMethod (x \\ y)  = (buildMethod x) @  (buildMethod y)
   | buildMethod _        = raise bad_abstraction_method


and  progressive 0       = [(mkFnRecord 
                                 (AbsGeneratorCompress.CONDITION  () )
                                 (AbsGeneratorCompress.ACTION     () ))]
   | progressive n       = [(mkFnRecord 
                               (AbsGeneratorStars.CONDITION (NONE,false))
                               (AbsGeneratorStars.ACTION ("ps","max",(n -1))))]



 val absFunctions = defAbs

end
end


