signature GENERIC_GRAPH =
sig
 type puzzle_parameter
 type abstraction_parameter 
 type graph
 type peektype
 type internal_state
 type external_state
 val mkSearchSpace : 
           (puzzle_parameter ->
             { graph  : (graph * peektype * (abstraction_parameter -> unit)),
               decode : (internal_state -> external_state),
               encode : (external_state -> internal_state),
               randomStatePair : (unit -> (external_state * external_state))
              } )

 structure Graph : GRAPH
 structure AbstractionGenerator : ABSTRACTION_GENERATOR
 structure HashState: HASH_STATE
 structure AbsFunctions :  ABS_FUNCTIONS
end ;



