

(* envisionment of Qualitative Model from Jeff Rickel *)

datatype qsim_external_state =  (* a list of the state names *)
 s0 | s10 | s24188 | s24189 | s24741 | s27578 | s27579 | s27580 | s27581
          | s27582 | s27583 | s27915 | s27918 | s28092 | s28094 | s28095
          | s28097 | s28098 | s28099 | s30893 | s30926 | s30928 | s30988
          | s30990 | s36830 | s36832 | s36834 | s36976 | s36978 | s36980

fun  convert_qsim_state s0     = "s0"
  |  convert_qsim_state s10    = "s10"
  |  convert_qsim_state s24188 = "s24188"
  |  convert_qsim_state s24189 = "s24189"
  |  convert_qsim_state s24741 = "s24741"
  |  convert_qsim_state s27578 = "s27578"
  |  convert_qsim_state s27579 = "s27579"
  |  convert_qsim_state s27580 = "s27580"
  |  convert_qsim_state s27581 = "s27581"
  |  convert_qsim_state s27582 = "s27582"
  |  convert_qsim_state s27583 = "s27583"
  |  convert_qsim_state s27915 = "s27915"
  |  convert_qsim_state s27918 = "s27918"
  |  convert_qsim_state s28092 = "s28092"
  |  convert_qsim_state s28094 = "s28094"
  |  convert_qsim_state s28095 = "s28095"
  |  convert_qsim_state s28097 = "s28097"
  |  convert_qsim_state s28098 = "s28098"
  |  convert_qsim_state s28099 = "s28099"
  |  convert_qsim_state s30893 = "s30893"
  |  convert_qsim_state s30926 = "s30926"
  |  convert_qsim_state s30928 = "s30928"
  |  convert_qsim_state s30988 = "s30988"
  |  convert_qsim_state s30990 = "s30990"
  |  convert_qsim_state s36830 = "s36830"
  |  convert_qsim_state s36832 = "s36832"
  |  convert_qsim_state s36834 = "s36834"
  |  convert_qsim_state s36976 = "s36976"
  |  convert_qsim_state s36978 = "s36978"
  |  convert_qsim_state s36980 = "s36980"



structure Qsim : GENERIC_PUZZLE =
struct
local open Random
in

(*  A state is represented by an atom, "s" followed by the number
   generated by Qsim.

   The legal moves for each state are represented by a list of successors.
*)

 type external_state =  qsim_external_state
 type internal_state = external_state
 type puzzle_parameter =   unit

 fun sameState (x,y) = (x = y)

 fun hashState s0     =  1
  |  hashState s10    =  2
  |  hashState s24188 =  3
  |  hashState s24189 =  4
  |  hashState s24741 =  5
  |  hashState s27578 =  6
  |  hashState s27579 =  7
  |  hashState s27580 =  8
  |  hashState s27581 =  9
  |  hashState s27582 = 10
  |  hashState s27583 = 11
  |  hashState s27915 = 12
  |  hashState s27918 = 13
  |  hashState s28092 = 14
  |  hashState s28094 = 15
  |  hashState s28095 = 16
  |  hashState s28097 = 17
  |  hashState s28098 = 18
  |  hashState s28099 = 19
  |  hashState s30893 = 20
  |  hashState s30926 = 21
  |  hashState s30928 = 22
  |  hashState s30988 = 23
  |  hashState s30990 = 24
  |  hashState s36830 = 25
  |  hashState s36832 = 26
  |  hashState s36834 = 27
  |  hashState s36976 = 28
  |  hashState s36978 = 29
  |  hashState s36980 = 30

 fun successors s0       = [ s10 ]
  |  successors s10      = [ s24188 ]
  |  successors s24188   = [ s24189 ]
  |  successors s24189   = [ s24741 ]
  |  successors s24741   = [ s27578 ]
  |  successors s27578   = [ s27579,s27580,s27581,s27582,s27583 ]
  |  successors s27579   = []
  |  successors s27580   = [ s27915 ]
  |  successors s27581   = [ s27918,s28092,s27578 ]
  |  successors s27582   = [ s28092 ]
  |  successors s27583   = [ s30893 ]
  |  successors s27915   = [ s27579,s27583 ]
  |  successors s27918   = [ s27579 ]
  |  successors s28092   = [ s27579,s28094,s28095,s27581,s28097,s28098,s28099 ]
  |  successors s28094   = [ s30893 ]
  |  successors s28095   = [ s30926 ]
  |  successors s28097   = [ s27578 ]
  |  successors s28098   = [ s27578 ]
  |  successors s28099   = [ s36830 ]
  |  successors s30893   = [ s27579,s28095 ]
  |  successors s30926   = [ s27579,s30928 ]
  |  successors s30928   = [ s30988 ]
  |  successors s30988   = [ s27579,s30990 ]
  |  successors s30990   = [ s27915 ]
  |  successors s36830   = [ s27579,s36832,s28097,s36834,s30928 ]
  |  successors s36832   = [ s30926 ]
  |  successors s36834   = [ s36976 ]
  |  successors s36976   = [ s27579,s36978,s30990,s36980 ]
  |  successors s36978   = [ s30988 ]
  |  successors s36980   = [ s27578 ]

fun random_element L =
    let val pos = (newrandom (length L))-1
    in  (nth (L,pos))
    end


(* the following takes a state and returns a random successor of that state,
   successors with low outdegree have higher probability of being chosen
   than those with a high outdegree.  The chosen state will be at most
   distance D from the initial state.
   (D is really only needed to rpevent infinite loops in cyclic spaces.
    I have set it large enough here that it will never cause termination)
*)

 fun randState 0 state = state
  |  randState D state =
     let val s = random_element (state::(successors state))
     in  if (s = state)
         then state
         else randState (D-1) s
     end

fun identity x = x

 fun mkInstance _  =
     { decode   = identity ,
       encode   = identity ,
       successor= successors,
       initialStates = [s0] ,
       randomStatePair = (fn () => ( s0, randState 33 s0) )
      }

end
end

