
structure Hanoi : GENERIC_PUZZLE =
struct
local open Random Bits   (* NJML needs this  *)
in

(* in the external state, the disks are numbered from 0 (smallest) to
   nDisks-1
*)

 type external_state = (int list) * (int list) * (int list)
 type internal_state = int
 type puzzle_parameter = int

 val  sameState = (op =):(internal_state*internal_state)->bool
 fun  hashState n = n

fun clear (state,0) = 4*(state div 4)
 |  clear (state,d) = let val dbits = state mod 4
                      in 4*(clear (state div 4,d-1))+dbits end ;

 fun set   (state,disk,to) = orb(state,lshift(to,2*disk))
 fun move  (state,disk,to) = set(clear(state,disk),disk,to)
 fun get   (state,disk)    = andb(3,rshift(state,2*disk))

 fun top (state,n,peg) =
 let fun loop disk =
       if disk=n then NONE else
       if get(state,disk) = peg then SOME disk
       else loop (1+disk)
 in loop 0 end

 fun generator n (from,to) state =
 (case top(state,n,from) of
    NONE         => NONE
  | SOME fromTop =>
    (case top(state,n,to) of
       NONE => SOME(move(state,fromTop,to))
     | SOME toTop => if fromTop<toTop
                       then SOME(move(state,fromTop,to))
                       else NONE))

 fun mkGenerator nDisks state =
 let fun cleanup (NONE  ::l) =      cleanup l
       | cleanup (SOME s::l) = s :: cleanup l
       | cleanup []          = []
     fun gen tup = generator nDisks tup state
 in cleanup (map gen [(0,1),(0,2),(1,0),(1,2),(2,0),(2,1)]) end

 fun decode nDisks state =
 let fun loop disk peg1 peg2 peg3 =
       if disk<0 then (peg1,peg2,peg3)
       else case get(state,disk) of
              0 => loop (disk-1) (disk::peg1) peg2 peg3
            | 1 => loop (disk-1) peg1 (disk::peg2) peg3
            | 2 => loop (disk-1) peg1 peg2 (disk::peg3)
 in loop (nDisks-1) [] [] [] end

 fun encode (peg1,peg2,peg3) =
 let fun loop [] peg state = state
       | loop (disk::disks) peg state =
           loop disks peg (set(state,disk,peg))
     val state1 = loop peg1 0 0
     val state2 = loop peg2 1 state1
     val state3 = loop peg3 2 state2
 in state3 end

fun place_on_peg d 1 (p1,p2,p3) = (d::p1,   p2,   p3)
 |  place_on_peg d 2 (p1,p2,p3) = (   p1,d::p2,   p3)
 |  place_on_peg d 3 (p1,p2,p3) = (   p1,   p2,d::p3)

 fun randPair n ndisks () =
 if n >= ndisks
 then ( ([],[],[]), ([],[],[]) )
 else let val (start,goal) = randPair (n+1) ndisks ()
          val where_to_start  = newrandom 3
          val where_to_finish = newrandom 3
      in  ( place_on_peg n where_to_start start,
            place_on_peg n where_to_finish goal )
      end

 fun mkInstance nDisks =
     { decode   = (decode nDisks),
       encode   = encode,
       successor= mkGenerator nDisks,
       initialStates = [0],
       randomStatePair = randPair 0 nDisks
      }
end
end
