(in-package 'spa)

;;; Topological Sort   
;;; Returns correct order: first step at head
;;; Input: max is an integer
;;;    Ordering is a list of pairs (f l) where step number f must be before l
;;;    f, l <= max
;;; See Aho, Hopcoft, Ullman p70 for faster way
;;; (defun TOP-SORT (ordering max)
;;;  (let ((ret nil)
;;;         (ts (top-sort1 (copy-tree ordering))))
;;;     (dotimes (i max)
;;;       (unless (member (+ i 1) ts)
;;;         (push (+ i 1) ret)))
;;;     (nconc ts ret)))
;;; 
;;;   
;;; ;;; Topological Sort util  -   This code is DESTRUCTIVE!  Pass it a copy!
;;; (defun TOP-SORT1 (ordering)
;;;   (when ordering
;;;     (let ((as (mapcar #'ordering-succ ordering)))
;;;       (do ((p ordering (cdr p)))
;;;           ((not (member (ordering-pred (car p)) as))
;;;                                       ; (pred (car p)) not *after* anything!
;;;            (cons (ordering-pred (car p))
;;;                  (top-sort1 (delete-if 
;;;                              #'(lambda (x) 
;;;                                  (eql (ordering-pred x) 
;;;                                       (ordering-pred (car p))))
;;;                              ordering))))))))
;;; 

(defun top-sort (ordering-list max)
  (add-unmentioned-steps 
   (real-top-sort (mapcar #'(lambda (o) (cons (ordering-pred o)  
                                              (ordering-succ o)))
                          ordering-list))
   max))

(defun real-top-sort (order-pairs)
  (cond
    ((null order-pairs) '())
    (t (let ((next-pair (find-if #'(lambda (pair) 
                                     (pair-isnt-succ pair order-pairs))
                                 order-pairs)))
         (cond
           ((null next-pair)
            (error "Ordering ~a is inconsistent!" order-pairs))
           (t (let ((next-num (car next-pair)))
                (cons next-num
                      (real-top-sort 
                       (delete-if #'(lambda (pair) (eql (car pair) next-num))
                                  order-pairs))))))))))

(defun pair-isnt-succ (input-pair pair-list)
  (let ((input-num (car input-pair)))
    (every #'(lambda (pair) 
               (or (eq pair input-pair)
                   (not (eql input-num (cdr pair)))))
           pair-list)))

;;;

(defun add-unmentioned-steps (step-list max)
  (let ((ret '()))
    (dotimes (i max)
      (unless (member (+ i 1) step-list)
        (push (+ i 1) ret)))
    (nconc step-list ret)))
