(in-package 'spa)
  
;;;;;;;;;;;;;;;;;;;;;;;;
;;; Print function for Templates

(defvar *templates*)

(defun PRINT-TEMPLATES (&optional (templates *templates*)
				  (s3 *standard-output*))
  (format s3 "~&~%Templates:")
  (dolist (templ-n templates)
    (let ((action (step-action (car templ-n)))
	  (pre-cond (step-precond (car templ-n)))
	  (post-cond (step-postcond (car templ-n)))
	  (bind (cadr templ-n)))
      (format s3 "~&~a~%  Pre  : ~a~%  Post : ~a~%  Bind : ~a~%"
	      action pre-cond post-cond bind)))
  (values))
    

;;;;;;;;;;;;;;;;
;;; This version does a toplogical sort and then prints out the steps
;;; in the order in which they should be executed
;;;(defun DISPLAY-PLAN (plan &optional (stream *standard-output*) ignore)
;;;  (declare (ignore ignore))
;;;  (let ((real-plan (cond ((snlp-plan-p plan) plan)
;;;			 ((integerp plan) 
;;;			  (symbol-value (intern (format nil "IP~d" plan))))
;;;			 (t (error "Can't make a plan out of ~a" plan)))))
;;;    (format stream "~%IPLAN ~a" real-plan)
;;;    (let ((steps (make-array (+ 1 (snlp-plan-high-step real-plan))))
;;;          (order (only-real-steps real-plan
;;;                                  (top-sort (snlp-plan-ordering real-plan) 
;;;                                            (snlp-plan-high-step real-plan))))
;;;          (goal nil)
;;;	  (cs (snlp-plan-bindings real-plan)))
;;;      (flet ((step-no (d which-end)
;;;	       (let* ((l (get-link (decision-link
;;;				    (get-decision d real-plan)) real-plan))
;;;		      (x (funcall which-end l)))
;;;		 (case x (0 'Init)(:Goal 'Goal)(t (+ 1 (position x order)))))))
;;;	(dolist (step-n (SNLP-plan-steps real-plan))
;;;	  (cond 
;;;	   ((init-step? step-n)
;;;	    (format stream "~%Initial: ~a" (step-postcond step-n)))
;;;	   ((goal-step? step-n)
;;;	    (setf goal (step-precond step-n)))
;;;	   (t  (setf (aref steps  (step-id step-n)) step-n))))
;;;
;;;	(format stream "~%                         consumes from      produces for       threatened")
;;;	(dotimes (i (length order))
;;;	  (let* ((sn (nth i order))
;;;		 (step (aref steps sn)))
;;;	    (format stream "~%   [~3a]~3a : ~15a ~18a ~18a ~a"
;;;		    (+ 1 i)  (step-id step)
;;;		    (instantiate-form (step-action step) cs)
;;;		    (mapcar #'(lambda (d) (step-no d #'link-producer))
;;;			    (step-consuming-decisions step))
;;;		    (mapcar #'(lambda (d) (step-no d #'link-consumer))
;;;			    (step-producing-decisions step))
;;;		    (mapcar #'(lambda (d)
;;;				(list (step-no d #'link-producer)
;;;				      (step-no d #'link-consumer)))
;;;			    (step-avoiding-decisions step)))))
;;;
;;;	(format stream "~%~%Goal   : ~a" goal)
;;;	(if (or (SNLP-plan-unsafe real-plan)
;;;		(SNLP-plan-open real-plan))
;;;	    (format stream
;;;		    "~%Order  : ~a~%Unsafe : ~a ~%Open   : ~a ~%Links  : ~a"
;;;		    order
;;;		    (instantiate (SNLP-plan-unsafe real-plan) cs)
;;;		    (instantiate (SNLP-plan-open real-plan) cs)
;;;		    (instantiate (SNLP-plan-links real-plan) cs))
;;;          (format stream "~%Complete!")))))
;;;  (values))

(defun DISPLAY-PLAN (plan &optional (stream *standard-output*) ignore)
  (declare (ignore ignore))
  (let ((real-plan (cond ((snlp-plan-p plan) plan)
                         ((integerp plan) 
                          (symbol-value (intern (format nil "IP~d" plan))))
                         (t nil))))
    (when (not (snlp-plan-p real-plan))
      (error "Can't make a plan out of ~a" plan))
    (let ((cs (snlp-plan-bindings real-plan)))
      (format stream "~%IPLAN ~a" real-plan)
      (print-steps real-plan stream)
      (print-condition-list (snlp-plan-open real-plan) "Open" cs stream)
      (print-condition-list (snlp-plan-unsafe real-plan) "Unsafe" cs stream)
      (print-condition-list (snlp-plan-links real-plan) "Links" cs stream)
      (format stream "Ordering: ~a~%" (snlp-plan-ordering real-plan)))))

(defun print-steps (real-plan stream)
  (let ((steps (make-array (+ 1 (snlp-plan-high-step real-plan))))
        (order (only-real-steps real-plan
                                (top-sort (snlp-plan-ordering real-plan) 
                                          (snlp-plan-high-step real-plan))))
        (goal nil)
        (cs (snlp-plan-bindings real-plan)))
	(dolist (step-n (SNLP-plan-steps real-plan))
	  (cond 
	   ((init-step? step-n)
	    (format stream "~%Initial: ~a~%" (step-postcond step-n)))
	   ((goal-step? step-n)
	    (setf goal (step-precond step-n)))
	   (t  (setf (aref steps  (step-id step-n)) step-n))))
    (format stream "Order   Id     Action~%")
	(dotimes (i (length order))
	  (let* ((sn (nth i order))
             (step (aref steps sn)))
	    (format stream "~6a [~2d]      ~a~%" 
                (+ 1 i)  
                (step-id step)
                (instantiate-form (step-action step) cs))))
    (format stream "Goal: ~%   ~a~%" goal)))

(defun print-condition-list (list label cs stream)
  (cond
   (list 
    (format stream "~a:~%" label)
    (dolist (list-elt list)
      (format stream "  ~a~%" (instantiate list-elt cs))))
   (t (format stream "No ~a.~%" label))))

(defun dp (thing) (display-plan thing))

;;;****************************************************************
  
(defun ONLY-REAL-STEPS (ip order)
  (delete-if-not #'(lambda (o) 
                     (and (not (eql o 0))
                          (member-if #'(lambda (s) (eql o (step-id s)))
                                     (snlp-plan-steps ip))))
                 order))

  
  
;;;*************************************************************************
;;; Print a plan in grotesque detail.    

(defun DISPLAY-PLAN-VERBOSELY (p &optional (stream *standard-output*))
  (format stream "Plan ~d, high step ~d, rank ~d~%" 
          (snlp-plan-id p) (snlp-plan-high-step p) (snlp-plan-rank p))
  (dolist (step (snlp-plan-steps p))
    (display-step step stream 3))
  (display-list "Open:" (snlp-plan-open p) stream 3)
  (display-list "Unsafe:" (snlp-plan-unsafe p) stream 3) ; bug fixed -DSW
  (display-list "Links:"  (snlp-plan-links p) stream 3)
  (display-list "Orderings:" (snlp-plan-ordering p) stream 3)
  (display-cs (snlp-plan-bindings p) stream 3)
  (values))

(defun display-step (step stream indent)
  (indent-stream stream indent) 
  (format stream "Step ~d -- ~a:~%" (step-id step) (step-action step))
  (display-list "Precond: " (step-precond step) stream (+ indent 2))
  (display-list "Postcond:" (step-postcond step) stream (+ indent 2))
  (values))

(defun display-list (intro-string list stream indent)
  (when (> (length intro-string) 0)
    (indent-stream stream indent)
    (format stream "~a~%" intro-string))
  (dolist (elt list)
    (indent-stream stream (+ indent 2))
    (format stream "~a~%" elt stream))
  (values))

;;; There's gotta be a better way!
(defun indent-stream (stream num)
  (format stream (make-string num :initial-element #\Space)))

;;;;;;;;;;;;;;;;

(defun DISPLAY-Q (q &optional (s *standard-output*) ignore)
  (declare (ignore ignore))
  (format s "~%Entries seen: ~a, Max-length: ~a, Current-length ~a"
          (q-iplans-enqueued q) (q-max-length q) (length (q-entries q)))
  (when (q-entries q)
    (let ((goal nil))
      (dolist (step-n (SNLP-plan-steps (qentry-iplan (car (q-entries q)))))
        (cond ((init-step? step-n)
               (format s "~%Initial  : ~a" (step-postcond step-n)))
              ((goal-step? step-n)
               (setf goal (step-precond step-n)))))
      (format s "~%Goal     : ~a" goal)))
  (dolist (e (q-entries q))   
    (print-qentry e s))
  (values))

;;;;;;;;;;;;;;;;
;;; This version does a toplogical sort and then prints out the steps
;;; in the order in which they should be executed
(defun DISPLAY-QENTRY (e &optional (stream *standard-output*) ignore)
  (declare (ignore ignore))
  (let* ((plan (qentry-iplan e))
	 (steps (make-array (+ 1 (snlp-plan-high-step plan))))
	 (order (only-real-steps plan (top-sort (snlp-plan-ordering plan) 
						(snlp-plan-high-step plan))))
	 (cs (snlp-plan-bindings plan)))
    (if (eql (qentry-dir e) :extend)
	(format stream "~%   Extendable,  rank ~a" (qentry-rank e))
	(format stream "~%   Retractable, rank ~a ~a" (qentry-rank e)
		(if (qentry-stops e) 
		    (format nil "w/ stops ~a" (qentry-stops e)) "")))
    (dolist (step-n (SNLP-plan-steps plan))
      (when (and (not (eql (step-id step-n) '0))
		 (not (eql (step-id step-n) :Goal)))
	(setf (aref steps  (step-id step-n)) step-n)))
    (dotimes (i (length order))
      (let* ((sn (nth i order))
	     (step (aref steps sn)))
	(format stream "~%   Step ~3a : ~15a  Created ~2a" 
		(+ 1 i)
		(instantiate-form (step-action step) cs)
		sn)))
    (if (or (SNLP-plan-unsafe plan)
	    (SNLP-plan-open plan))
	(format stream "~%   Unsafe   : ~a ~%   Open     : ~a"
		(instantiate (SNLP-plan-unsafe plan) cs)
		(instantiate (SNLP-plan-open plan) cs))
	(format stream "~%Complete!")))
  (values))
