(in-package 'spa)

;;;***********************************************************************
;;; The plan library is a list of LIB-ENTRY structures.  Each 
;;; represents a library plan, and contains 
;;;    1.  a name for the plan, 
;;;    2.  a domain name in which the plan was built, 
;;;    3.  a function that returns the library plan itself, 
;;;    4.  the (cached) library plan itself, and 
;;;    4.  a checker function.
;;; The plan name and domain name are symbols.
;;; The generator function takes no arguments and always returns a plan.
;;;
;;; The checker function takes initial and goal conditions, 
;;; determines whether the plan is applicable, and if so returns a 
;;; COPY of the plan with the variables appropriately instantiated and 
;;; all initial and goal conditions fixed to match the inputs.  In other
;;; words, the checker function is responsible for the ENTIRE refitting
;;; process.   If the plan isn't appropriate for the inputs, the checker 
;;; returns NIL.

;;;****************************************************************************
;;;  Loading this file will cause the library files below to be loaded too.
;;;  They will be responsible for putting things on the *plan-library* list,
;;;  via calls to ADD-PLANLIB-ENTRY.

;;;(defvar *lib-files-to-load*   '("rao-experiments" "reg-swap"))
(defvar *lib-files-to-load*   '("rao-experiments"))
(defvar  *plan-library*  '())          ; set below

;;; *spa-library-directory* is defined in the loader file---either
;;; spa.system or loader.lisp

(defun initialize-plan-library ()
  (mapcar #'(lambda (filename) 
              (load (make-pathname :directory user::*spa-library-directory* 
                                   :name filename)))
          *lib-files-to-load*))

;;;*************************************

(defstruct (lib-entry (:print-function print-lib-entry))
  problem-name domain-name initial goal stored-plan plan-fun checker-fun)

(defun print-lib-entry (entry stream depth)
  (declare (ignore depth))
  (format stream "#<PLANLIB ~a>" (lib-entry-problem-name entry)))

(defun add-planlib-entry (problem-name domain-name 
                          initial      goal 
                          plan-fun checker-fun)
  (push (make-lib-entry :problem-name problem-name
                        :domain-name domain-name
                        :initial (mapcar #'as-condx initial)
                        :goal (mapcar #'as-condx goal)
                        :stored-plan NIL
                        :plan-fun plan-fun
                        :checker-fun checker-fun)
        *plan-library*))

(defun find-lib-entry (problem-name)
  (find-if #'(lambda (entry) (eq (lib-entry-problem-name entry) problem-name))
           *plan-library*))

(defun lib-entry-plan (entry)
  (cond
   ((lib-entry-stored-plan entry)
    (copy-plan-completely (lib-entry-stored-plan entry)))
   (t (let ((new-plan (funcall (lib-entry-plan-fun entry))))
        (setf (lib-entry-stored-plan entry) new-plan)
        (copy-plan-completely new-plan)))))

(defun find-plan (problem-name)
  (let ((the-entry (find-lib-entry problem-name)))
    (if (null the-entry)
        NIL
      (lib-entry-plan the-entry))))


