(in-package 'spa)

;;;********************************************************************
;;; Various versions of copy for plans

;;; Makes a new plan that has eq slots but a new id

(defun copy-plan-quick (ip)
  (make-snlp-plan
   :steps     (snlp-plan-steps ip)  
   :links     (snlp-plan-links ip)  
   :unsafe    (snlp-plan-unsafe ip)  
   :open      (snlp-plan-open ip)  
   :ordering  (snlp-plan-ordering ip)  
   :bindings  (snlp-plan-bindings ip)  
   :decisions (snlp-plan-decisions ip)
   :high-step (snlp-plan-high-step ip)
   :high-id   (snlp-plan-high-id ip)
   ))

;;; Makes a new plan with copied steps and links list
;;; and optionally copied bindings

(defun copy-plan-for-extend (ip &key (cs nil))
  (let ((new-plan (copy-plan-quick ip)))
    (setf (snlp-plan-steps new-plan)
          (copy-list (snlp-plan-steps new-plan)))
    (setf (snlp-plan-links new-plan)
          (copy-list (snlp-plan-links new-plan)))
    (when cs
      (setf (snlp-plan-bindings new-plan)
	    (copy-cs (snlp-plan-bindings new-plan))))
    (values new-plan)))

;;; Completely copy every part of plan, recursively

(defun copy-plan-completely (p)
  (operate-on-plan p 
                   #'(lambda (form destructive?)
                     (declare (ignore destructive?))
                     (copy-tree form))
                   ':copy
                   nil))

;;;********************************************************************
;;; Other applications of operate-on-plan: VARIABILIZE

(defvar *vps-generation* 0)

(defun variabilize-plan-selectively (p including excluding 
                                           &optional (destructive? NIL))
  (incf *vps-generation*)
  (operate-on-plan
     p 
     #'(lambda (form destructive?) 
         (variabilize-form-selectively form including excluding destructive?))
     ':variabilize
     destructive?))

(defun variabilize-plan (p &optional (destructive? nil))
  (variabilize-plan-selectively p 'all '() destructive?))

(defun variabilize-plan-selectively! (p including excluding)
  (variabilize-plan-selectively p including excluding t))


(defun variabilize-form-selectively (form including excluding destructive?)
  (iterate-on-form form 
                   #'(lambda (item) (item-var-form item including excluding))
                   destructive?))

(defun item-var-form (item including excluding)
  (cond
    ((and (constant? item)
          (or (eq including 'all) (member item including :test #'eq))
          (not (member item excluding :test #'eq)))
     (make-o-variable item "-" *vps-generation*))
    (t item)))

;;;********************************************************************
;;; Other applications of operate-on-plan: INSTANTIATE

(defun instantiate-plan (p &optional (cs nil) (destructive? nil))
  (let ((real-cs (or cs (snlp-plan-bindings p))))
    (operate-on-plan p 
                     #'(lambda (form destructive?) 
                         (instantiate-form form real-cs destructive?))
                     ':instantiate
                     destructive?)))

(defun instantiate-form (form cs &optional (destructive? nil))
  (iterate-on-form form
                   #'(lambda (item)
		       (if (variable? item) (var-value item cs) item))
                   destructive?))
  
(defun instantiate (thing bindings &optional (destructive? nil))
  (operate-on thing
	      #'(lambda (f d)
		  (declare (ignore d))
		  (instantiate-form f bindings nil))
	      destructive?
	      :op-key ':instantiate))
