#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Robert L. Joseph

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


;
;    pg-mac.lisp: Window specific functions for the macintosh to be
;        used with prodigy
;
; (C) Robert L. Joseph 88
;

(eval-when (eval compile load)
  (require 'records)
  (require 'traps)
  (require 'quickdraw))

(in-package "PG" :use '("CCL" "LISP" "USER"))

(export '(pg-refresh-window  pg-create-window   pg-kill-window
          pg-clear-window    pg-show-window     pg-hide-window
          pg-window-height   pg-window-width    pg-draw-line
          pg-write-text      pg-text-width      pg-text-height
          pg-erase-rect      pg-frame-rect      pg-invert-rect
          pg-with-window     pg-init-graphics   current-host))

(defmacro pg-with-window (w &rest body)
  `(ask ,w (progn ,@body)))

(defmacro current-host ())

(defun no-op-for-pg (&rest x)
   (declare (ignore x)))

(defobject *prodigy-window* *window*)

(ask *prodigy-window* (have '*redraw-function* "hello"))

(defobfun (exist *prodigy-window*) (init-list)
       (usual-exist init-list)
       (have '*REDRAW-FUNCTION* (getf init-list :exposure-function nil))
       (have '*CONFIG-FUNCTION* (getf init-list :config-function))
)

(defobfun (window-draw-contents *prodigy-window*) ()
;   (declare (special *REDRAW-FUNCTION*))    
    (ask (self) (funcall *REDRAW-FUNCTION*))
)
; The &allow-other-keys keyword gives us easy x11 compatiblity, although
; the is no functionality associated with the extra keys.

(defun pg-create-window (x y w h &key (exposure-function #'no-op-for-pg)
                                      button-press
                                      (name "NoName")
				      (config-function #'no-op-for-pg)
					&allow-other-keys)
  (declare (ignore x y button-press))  ;;some are temp.
  (let ((wn (oneof *prodigy-window*
                   :window-title name
                   :field-size #@(800 800)
                   :window-size (make-point w h)
                   :window-show nil
                   :exposure-function exposure-function
)))
    (apply config-function '(wn 0 0 800 800))
;    (ask wn (user::set-pen-mode :patCopy))
    (ask wn (user::set-window-font '("New York" 9 :plain :srcCopy)))
    (ask wn (window-show))
    wn))

(defun pg-refresh-window (win)
 ; dkahn-- I think that here is need a call to window-draw-contents
  (declare (ignore win))
)



(defun pg-init-graphics (x y)
   (declare (ignore x y)))

(defun pg-kill-window (w)
  (pg-with-window w (window-close)))

(defun pg-refresh-window (win)
  (pg-with-window win))

(defun pg-clear-window (win)
  (pg-with-window win
;    (window-select)
    (user::erase-rect (make-point 0 0) (window-size))))

(defun pg-show-window (w)
  (pg-with-window w
    (window-select)))

(defun pg-hide-window (w)
  (pg-with-window w
;    (format t "I am in the pg-hide-window function~%")
))

(defun pg-draw-line (w x1 y1 x2 y2)
  (pg-with-window w
    (user::move-to x1 y1)
    (user::line-to x2 y2)))

(defun pg-write-text (w x y str)
  (pg-with-window w
    (user::move-to x y)
    (format w str)))

(defun pg-text-width (w str)
  (pg-with-window w
    (string-width str)))

(defun pg-text-height (w &optional str)
  (pg-with-window w
    (string-height)))

(defun pg-font-height (font)
    "Returns the maximun height of a character in the font."
    (multiple-value-bind (ascent decent)
		(font-info font)
		(+ ascent decent)))

   

(defun string-height ()
  (multiple-value-bind (asc des wid lead) (font-info)
    (+ asc des)))

(defun pg-window-height (w)
  (pg-with-window w
    (point-v (window-size))))

(defun pg-window-width (w)
  (pg-with-window w
    (point-h (window-size))))

; -----------------------

(defun pg-erase-rect (win left top right bottom)
  (rlet ((r :rect :left left :top top :right right :bottom bottom))
	(ask win (erase-rect r))))

(defun pg-frame-rect (win left top right bottom)
  (rlet ((r :rect :left left :top top :right right :bottom bottom))
	(ask win (frame-rect r))))

(defun pg-invert-rect (win left top right bottom)
  (rlet ((r :rect :left left :top top :right right :bottom bottom))
	(ask win (invert-rect r))))

#|
;; I put in a bunch of compatiblity to pg-x11 changes
(defun pg-erase-rect (win left top right bottom)
  (ask win
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::erase-rect r))))

(defun pg-frame-rect (win left top right bottom)
 (ask win
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::frame-rect r))))

(defun pg-invert-rect (win left top right bottom)
 (ask win
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::invert-rect r))))
|#
#|
(defun pg-erase-rect (left top right bottom)
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::erase-rect r)))

(defun pg-frame-rect (left top right bottom)
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::frame-rect r)))

(defun pg-invert-rect (left top right bottom)
  (user::with-rectangle-arg 
    (r left top right bottom)
    (user::invert-rect r)))
|#
;(defun xunmapwindow (&rest x);;; why is this function here--dkahn
;   (declare (ignore x))
;  )

(pushnew :pg-system lisp::*features*)
(provide 'pg-system)


;(defun xchangewindow (r w h));;; why is this function here--dkahn
