#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *EVALUABLE-SIGS* *CACHABLE-SIGS* *INFERENCE-RULES*
		*OPERATORS* *SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES*  
		*SCR-OP-SELECT-RULES* *SCR-BINDINGS-SELECT-RULES*
		*SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES* 
		*SCR-OP-REJECT-RULES* *SCR-BINDINGS-REJECT-RULES*
		*SCR-NODE-PREFERENCE-RULES* *SCR-GOAL-PREFERENCE-RULES* 
		*SCR-OP-PREFERENCE-RULES* *SCR-BINDINGS-PREFERENCE-RULES*
		*STATIC-PREDS* *CLOSED-PREDS* *EVALUABLE-META-FNS*))

(eval-when (compile) 
	   (load-path *PLANNER-PATH* "g-loop")
	   (load-path *PLANNER-PATH* "g-map")
	   (load-path *PLANNER-PATH* "data-types")
	   (load-path *EBL-PATH*     "ebl-data-types"))



(setq *CACHABLE-SIGS*  '((fails nil)
			 (goal-fails nil)
			 (op-fails nil)
			 (op-interacts nil)
			 (interacts nil)
			 (op-succeeds nil nil nil)))


;  check whether I need *FINISH* in is-op

;  t is where things have to be defined
(setq *EVALUABLE-SIGS* '(
			 (in-set nil t)
			 (is-interact-literal nil)
			 (get-reset-alt nil t nil)
			 (get-deleted-goal1 nil nil t)
			 (set-of-goal-formulii nil)
			 (get-deleted-goal2 nil nil t)
			 (get-necessary-bvars nil t t t)
			 (new-legal-operator nil)
			 (old-legal-operator nil)
			 (get-used-add nil t)
		     		;  above were all "compiled-e-schemas"
			 (ps-get-op-bindings t nil)
			 (ps-get-add-for-op t nil)
			 (ps-make-dvars nil t t)
			 (ps-get-vars-lst nil t t)
			 (ps-get-gen-exp nil t)
			 (ps-get-exp nil t)
			 (is-op nil)
			 (in-add-list nil t)
			 (is-null t)
		     ;(is-equal t t) use ps-is-equal when should be evaluated
			 (ps-is-equal t t)
			 (ps-not-equal t t)
			 (is-open-world-exp t)
			 (is-car nil t)
			 (is-cadr nil t)
			 (is-cdr nil t)
			 (ps-list nil t t)
			 (ps-negate nil t)
			 (is-negated t)
			 (is-predicate t)
			 (is-var t) ;  watch it!!
			 (too-soon)
			 (ps-subst-bindings nil t t)
			 (add-new-bindings nil t t nil)
			 (get-binding nil t nil)
			 (ps-make-pair nil t t)
			 (member-add-list nil t)
			 (get-preconds nil t)
			 (get-lpreconds nil t)
			 (ps-consistent-bindings nil t t)
			 (ps-is-constant t) ;  watch it!
			 (atomic-match nil t t)
			 (relevent-bindings nil t t t)))

; also see functions built into reordering stuff

(setq *EVALUABLE-META-FNS*
   '((known t t)
     (not-top-level-node t)
     (current-goal t nil)
     (primary-candidate-goal t nil)
     (is-top-level-goal t nil)
     (adjunct-goal t nil)	
     (in-goal-exp t nil)
     (current-op t nil)
     (alt-on-deck t t t)
     (has-bound-vars t t t nil)
     (protected-goal t nil)
     (previous-state-diff t t)
     (is-equal t nil) 
     (is-equal nil t) 
     (not-equal t t)
     (candidate-bindings t nil)    
     (candidate-goal t nil)    
     (on-goal-stack t nil)
     (high-on-goal-stack t nil)
     (list-of-candidate-goals t nil)
     (direct-supergoal-of t t nil)
     (is-first-goal nil t)
     (achievable t t)
     (provable t t)))


(defun too-soon (h) 
   (format t "~%Problem with Domain encoding. Reached pt not implmented")
   (format t "~%Please check manual-for-ebl for domain restrictions")
   (warning-stop))

(defun set-of-goal-formulii (h goal-set)
  (cond ((not (is-variable goal-set)) (break))
	((not-top-level-node (getn h)) (break)) ; shouldn't even be called
	((get h 'generalized-goal-formulii)
	 (binding-lists1 goal-set (get h 'generalized-goal-formulii)))
	(t
	 (let ((goal-formulii
		(g-map (g in (alt-unmatched-conds
			      (node-generating-alt (getn h))))
		       (save (cons (car g)
				   (make-n-proof-vars (length (cdr g))))))))
	   (setf (get h 'generalized-goal-formulii) goal-formulii)
	   (binding-lists1 goal-set goal-formulii)))))




(defun get-used-add (h add op)
  (if (is-variable add)
      (binding-lists1 add  (if (node-reset-alt (getn h))
			       (alt-post-cond (node-reset-alt (getn h)))))
  (break)))



(defun get-reset-alt (h n op bvars)
  (if (is-variable bvars)
      (let ((r-bvars
	     (g-map (v in (get op 'vars))
					; this catches all vars bound to
					; constants...enough?
		    (val in (if (node-reset-alt (getn h))
				(alt-vars (node-reset-alt (getn h)))))
		    (save (and (not (is-variable val))
			       (not (member v (get op 'wildcard-vars)))
			       (not (member v
					    (if (node-reset-alt (getn h))
						(alt-post-cond
						 (node-reset-alt (getn h))))))
			       v)))))
	(list (list (list bvars r-bvars))))
    (break)))



;  a hack for succeeds

(defun new-legal-operator (h op)
  (if (is-variable op)
      (binding-lists1 op (get h 'new-h-applic-op))
    t))

(defun old-legal-operator (h op)
  (if (is-variable op)
      (binding-lists1 op (get h 'h-op))
    t))

(defun is-interact-literal (h pgoal)
  (let ((real-pgoal (or (get h 'protection-violation)
			(get h 'prerequisite-violation))))
    (if (is-variable pgoal)
	(binding-lists1 pgoal 
			(cons (car real-pgoal) (make-n-proof-vars
						(length (cdr real-pgoal)))))
      (break))))

(defun get-necessary-bvars (h bvars op g1 g2)
  (list (list (list bvars
		    (g-map (x in (get op 'vars))
			   (save (cond ((member x (get op 'wildcard-vars)) nil)
				       ((or (member x g1)(member x g2)) x)
				       (t nil))))))))


(defun ps-get-add-for-op (h op add)
  (if (is-variable add)
      (binding-lists1 add (get h 'h-add))
    (break)))

(defun ps-get-op-bindings (h op b)
  (if (is-variable b)
      (binding-lists1 b (get op 'params))
    (break)))

(defun get-deleted-goal1 (h g n op)
  (let ((goal1 (subgoal-to-precond (car (node-bro-deletion-node (getn h))) 
				   op (get op 'vars)
				   (if (get h 'reset-alt)
				       (alt-vars (get h 'reset-alt))))))
    (list (list (list g goal1)))))

(defun get-deleted-goal2 (h g n op)
  (let ((goal2 (subgoal-to-precond (cadr (node-bro-deletion-node (getn h))) 
				   op (get op 'vars)
				   (if (get h 'reset-alt)
				       (alt-vars (get h 'reset-alt))))))
    (list (list (list g goal2)))))

;  converts an instantiated subgoal to the precondition
;  which generated it

(defun subgoal-to-precond (igoal op vars vals)
  (g-loop (init cands (get-forms-from-exp (car igoal) (get op 'preconds)))
	  (while cands)
	  (do (and (equal igoal (subpair vars vals (car cands)))
		   (return (car cands))))
	  (next cands (cdr cands))
	  (result (error "couldn't find precondition"))))


(defun get-preconds (h pre op)
  (cond ((is-variable op) (break))
	((is-variable pre) 
	 (binding-lists1 pre (get op 'preconds)))
	(t (break))))

(defun get-lpreconds (h pre op)
  (cond ((is-variable op) (break))
	((is-variable pre) 
	 (binding-lists1 pre (get op 'lpreconds)))
	(t (break))))

(defun member-add-list (h add op)
  (cond ((is-variable op) (break))
	((is-variable add) 
	 (binding-lists1 add (get h 'h-addition)))
	(t (break))))


; take out bound vars (unquantify)
; should check to see which vars in bindings are actually bound!

(defun ps-get-vars-lst (h vars bindings exp)
  (binding-lists1 vars (ldiffq (get-vars-lst exp)
			       (mapcar #'car bindings))))

(defun ps-get-gen-exp (h gen exp)
  (binding-lists1 gen (get-gen-exp exp)))


(defun ps-get-exp (h sub exp)
  (binding-lists1 sub (get-exp exp)))


(defun ps-make-dvars (h new vals dvars)
  (if (not (eq dvars t))
      (g-loop (init v nil)
              (while (setq v (pop vals)))
              (do (if (and (is-variable v)
			   (not (member v dvars)))
		      (setq dvars (cons v dvars))))))
  (binding-lists1 new dvars))


(defun add-new-bindings (h newb bindings s o)
  (if (is-variable newb)
      (binding-lists1 newb (cons (list s o) bindings))
    (break)))

; returns val where bindings includes (arg val), or forms new bindings

; either val or arg can be unbound
(defun get-binding (h val arg bindings)
  (cond ((is-variable val)
	 (if (is-variable bindings) (error "cant both be unbound"))
	 (binding-lists1 val (cadr (assoc arg bindings))))
	((is-variable bindings)
	 (binding-lists1 bindings (list arg val)))
	(t (break))))

(defun ps-consistent-bindings (h b pair sub-b)
  (if (is-proof-var b)
      (if (assoc (car pair) sub-b)
	  (if (equal (cadr (assoc (car pair) sub-b)) (cadr pair))
	      (list '((nil nil))))
	(binding-lists1 b (cons pair sub-b)))
    (break)))


(defun ps-make-pair (h p a b)
  (if (is-proof-var p)
      (binding-lists1 p (list a b))
    (break)))


(defun ps-subst-bindings (h l1 l2 b)
  (if (and (is-proof-var l1)
	   (not (is-proof-var l2))
	   (not (is-proof-var b)))
      (binding-lists1 l1 (subst-bindings l2 b))
    (break)))


(defun in-set (h e s)
  (if (and (is-variable e)
	   (not (is-variable s)))
      (binding-lists e s)
    (break)))

; includes inference-RULES*

(defun is-op (h o)
  (if (is-variable o)
      (binding-lists o 
		     (nconc (mapcar #'car *INFERENCE-RULES*)
			    (mapcar #'car *OPERATORS*)))
    (break)))

(defun in-add-list (h add op)
  (if (and (is-variable add)
	   (not (is-variable op)))
      (binding-lists add (get op 'add-list))
    (break)))


(defun is-negated (h exp)
  (eq (car exp) '~))

(defun is-open-world-exp (h exp)
  (not (closed-predicate exp)))

(defun is-predicate (h exp) 
  (not (member exp '(forall exists ~ let and or))))

(defun ps-not-equal (y a b)
  (not (equal a b)))

;  used when is-equal should be evaluated!

(defun ps-is-equal (h a b)
  (cond ((is-proof-var a)
	 (binding-lists1 a b))
	((is-proof-var b)
	 (binding-lists1 b a))
	(t (equal a b))))

(defun is-null (h a)
  (if (is-proof-var a)
      (binding-lists1 a nil)
    (null a)))

(defun is-car (h arg l)
  (cond ((is-variable l) (break))
	((is-variable arg)
	 (binding-lists1 arg  (car l)))
	(t (equal arg (car l)))))

(defun is-cadr (h arg l)
  (cond ((is-variable l) (break))
	((is-variable arg)
	 (binding-lists1 arg  (cadr l)))
	(t (equal arg (cadr l)))))

(defun is-cdr (h arg l)
  (cond ((is-variable l) (break))
	((is-variable arg)
	 (binding-lists1 arg (cdr l)))
	(t (equal arg (cdr l)))))

(defun ps-list (h result e l)
  (binding-lists1 result (list e l)))

(defun ps-is-constant (h arg)
  (not (is-variable arg)))

(defun is-var (h arg)
  (is-variable arg))


; -------- History mechanisms --------------

(defun is-constant (arg)
  (not (is-variable arg)))

(defun didnt-match (spec-atom obj-atom bindings)
  (if (not (is-variable spec-atom))
      (not (equal spec-atom obj-atom))
    (if (assoc spec-atom bindings)
	(not (equal (cadr (assoc spec-atom bindings)) obj-atom)))))

(defun did-match (a b c) (not (didnt-match a b c)))

; exp was a subgoal - didn't match state
; h=node,op, add 


(defun did-fail (h exp op add n)
  (if (member exp (cdr (assoc (list op add (or (get h 'h-goal) 
					       (error "did-fail: no goal")))
			      (node-match-failure-history n)
			      :test #'equal))
	      :test #'equal)
      t))



(defun was-subgoal-subnode (h exp op add)
  (g-map (c in (node-children (getn h)))
	 (when (let ((gen-alt (node-generating-alt c)))
		 (and (if (node-gr-cond c)
			  (equal exp (node-gr-cond c))
			(equal exp (alt-failed-cond gen-alt)))
		      (eq op (alt-op gen-alt))
		      (equal add (alt-post-cond gen-alt))
		      (equal (get h 'h-goal) (alt-goal gen-alt))
		      (or (not (member (car (get h 'te)) '(bindings-fail bindings-interact)))
			  (equal (alt-vars gen-alt) (get h 'h-bindings))))))
	 (save c)))


; out
(defun was-applicable (h op add node)
  (g-loop (init children (node-children node) child nil 
		goal (get h 'h-goal))
	  (while (setq child (pop children)))
	  (do (if (and (node-applied-node child)
		       (eq op (alt-op (node-generating-alt child)))
		       (equal goal 
			      (subpair (get op 'vars) 
				       (alt-vars (node-generating-alt child))
				       add)))
		  (return t)))))

(defun wasnt-applicable (h op add node)
  (not (was-applicable h op add node)))



; out

(defun was-relevent (h add n)
  (if (lit-match add (or (get h 'h-goal)(error "no-h-goal"))) t))


; out
(defun was-not-relevent (h add n)
  (not (lit-match add (or (get h 'h-goal)(error "no-h-goal")))))


(defun was-relevent-del (h del n)
  (and (negated-p (or (get h 'h-goal)(error "WAS-RELEVENT-DEL")))
       (lit-match del (cadr (or (get h 'h-goal)(error "no-h-goal"))))
       t))
; return (node bindings) in a bindings list

(defun get-iop-history (newh add op node)
  (binding-lists1 newh 
		  (list node op add)))


(defun child-node-was (child add op parent)
  (g-loop (init ret-vals nil children (node-children parent)
		gen-alt nil)
 	  (do (setq gen-alt (node-generating-alt (car children)))
	      (if (and (eq op (alt-op gen-alt))
		       (equal (alt-goal gen-alt)
			      (subpair (get op 'vars)
				       (alt-vars gen-alt) add)))
		  (push (car children) ret-vals)))
	  (next children (cdr children))
	  (result (if ret-vals
		      (binding-lists child ret-vals)
		    (break)))))


(defun ps-find-generators (new-exp exp vars)
  (binding-lists1 new-exp (get-generators exp vars nil)))


;  vars only includes vars on right hand
; side of operator (existentially quantified).
;  We keep static formulas to get as much as possible of the
;  original formula, at least the static part (generators are
;  essentially static...

(defun get-generators (exp vars outside-dvars)
  (cond ((eq (car exp) 'exists)
	 (let ((new-dvars (ldiffq (intersectq (get-vars-lst exp) vars)
				  outside-dvars)))
	   (cond (new-dvars ; using new-pl language, but don't have to
		  (list 'and (get-gen-exp exp)
			(get-generators (get-exp exp) 
					vars (nconc new-dvars outside-dvars))))
		 ((get-generators (get-exp exp) vars
				  outside-dvars)))))
	((eq (car exp) 'forall) t)
	((eq (car exp) 'and)
	 (g-loop (init subs (cdr exp) ret-val nil sub-result nil)
		 (while subs)
		 (do (setq sub-result 
			   (get-generators (pop subs) vars outside-dvars))
		     (setq outside-dvars
			   (nconc (ldiffq (find-all-vars sub-result)
					  outside-dvars)
				  outside-dvars))
		     (push sub-result ret-val))
		 (result (cons 'and (nreverse ret-val)))))	  
	((eq (car exp) 'or)
	 (cons 'or (g-map (sub in (cdr exp))
			  (save (get-generators sub vars outside-dvars)))))
	((atomic-formula-p exp)
	 (cond ((static-p exp) exp)
	       ((ldiffq (intersectq (cdr exp) vars) outside-dvars)
		exp)
	       (t t)))))





; returns the a value for the nth element of sig-for-ebs
; that can be used in a subst-bindings to see
; what it matched against

(defun get-nth-from-sig-for-ebs (n rule)
  (let ((val (elt (get rule 'sig-for-ebs) (- n 1)))
	(real-lhs (get rule 'lhs))
	(lhs-for-ebs (get rule 'lhs-for-ebs)))
    (cond ((not (is-variable val)) val)
	  ((r-memq val real-lhs) val)
	  ((eq 'and (car lhs-for-ebs))
	   (pop lhs-for-ebs)
	   (g-loop (while lhs-for-ebs)
		   (do (cond ((eq t (car lhs-for-ebs)))
			     ((not (eql (caar lhs-for-ebs)
					'is-equal)))
			     ((eq val (cadar  lhs-for-ebs))
			      (return (caddar lhs-for-ebs)))
			     ((eq val (caddar lhs-for-ebs))
			      (return (cadar lhs-for-ebs)))))
		   (next lhs-for-ebs (cdr lhs-for-ebs))
		   (result (error "no find"))))
	  (t (error "bad lhs-for-ebs?")))))





;  random stuff

; out
(defun did-goal-stack-loop (n)
  (eq (car (node-failure-reason n)) 'goal-repeat))

; out
(defun did-state-loop (n)
  (eq (car (node-failure-reason n)) 'repeat-world))


(defun did-loop (node)
  (let ((failure-reason (node-failure-reason node)))
    (and failure-reason
	 (or (eq (car failure-reason) 'repeat-world)
	     (eq (car failure-reason) 'goal-repeat)))))


(defun binding-lists1 (var val)
  (list (list (list var val))))


(defun binding-lists (var val-list)
  (g-map (val in val-list)
	 (save (list (list var val)))))

(defun ps-get-operator-params (params bindings op)
  (binding-lists1 params 
		  (ldifference (remove-duplicates
				(find-all-vars (get op 'effects)))
			       (mapcar #'car bindings))))

(defun ps-unquantify (result exp bindings)
  (cond ((and (is-proof-var result)
	      (not (is-variable exp))
	      (not (is-variable bindings)))
	 (binding-lists1 result 
			 (r-unquantify exp (mapcar #'car bindings))))
	(t (break))))

(defun r-unquantify (exp vars)
  (cond ((member (car exp) '(exists forall))
	 (cond ((get-exp exp)
		(list (car exp)
		      (cond ((eq (car exp) 'forall)(get-vars-lst exp))
			    ((if-del-member-list vars (get-vars-lst exp))))
		      (get-gen-exp exp)
		      (r-unquantify (get-exp exp) vars)))
	       (t ; no exp
		(list (car exp)
		      (cond ((eq (car exp) 'forall)(get-vars-lst exp))
			    ((if-del-member-list vars (get-vars-lst exp))))
		      (get-gen-exp exp)))))
	((member (car exp) '(and or))
	 (cons (car exp) (g-map (subexp in (cdr exp))
				(save (r-unquantify subexp vars)))))
	((negated-p exp)
	 (list '~ (r-unquantify (cadr exp) vars)))
	(t exp)))



(defun ps-negate (h lit1 lit2)
  (if (or (is-variable lit2)
	  (not (is-variable lit1)))
      (break)
    (binding-lists1 lit1 (negate lit2))))

