#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *ALL-NODES* *TRIM-FACTOR* *RULE-LST-NMS* *EBL-FLAG*
	     *INCR-LEARNING* *OPERATORS* *INFERENCE-RULES* 
	     *PROB-NM* *OBS-HIST* *TARGET-CONCEPTS*
	     *LAST-TRIMMED-RULES* *TESTER* *MATCHER-TRACING* *MACRO-LEARNING* 
	     *START-STATE* *NULL-F-RESULTS* *NULL-GI-RESULTS* *NULL-S-RESULTS*
	     *PROVED* *SUB-PROOFS* *LEARNED-RULES* *NUM-RULE-UNIQUE-COUNT*
	     *EBL-PRINTING* *RULE-STACK*
	     *OPTIMIZE-MODE* *NUM-NODES-ADDED* *HALT-PROBLEM-SOLVER*
	     *NEW-LEARNED-RULES* *LEARNED-RULES-IN-SYS* *PROCESSED-NODES* 
	     *NUM-RUNS* *LAST-NUM-RULES-ADDED*))



(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


(defun tc-process-single-node (node)
    (format t "~%-------------------------~%")
    (format t "EBS Processing Single Node: ~a~%" node)
    (cond ((not (node-match-failure-history node))
	   (augment-node-trace node)))
    (tc-process-node node))


(defun tc-process-nodes (top-node)
    (g-loop (init nodes (rm-processed-nodes (postorder top-node))
		node nil)
	  (while (setq node (pop nodes)))
	  (do  (if *EBL-PRINTING*
		   (progn (format t "~%-------------------------~%")
			  (format t "EBS Processing Node: ~a~%" node)))
	       (if (not (node-match-failure-history node))
	           (augment-node-trace node))
	       (tc-process-node node))))


(defun rm-processed-nodes (nodes)
  (g-loop (while (and nodes (member (car nodes) *PROCESSED-NODES*)))
	  (do (setq nodes (cdr nodes)))
	  (result nodes)))

(defun tc-process-node (node)
  (g-loop (init tcs *TARGET-CONCEPTS* tc nil uniqued-result nil)
	  (before-starting (cond ((not (node-pre-check node))
				  (or (member node *PROCESSED-NODES*)
				      (push node *PROCESSED-NODES*))
				  (return))))
	  (while (setq tc (pop tcs)))
	  (do (g-loop (init hists (apply (get tc 'selection-heuristic) 
					 (list node))
			    sig (get tc 'signature) te nil)
		      (while hists)
		      (do (setq te (hist-to-te (car hists) sig))
			  (setf (get (car hists) 'te) te)
			  (format t "~2%TRAINING EXAMPLE: ~a     HIST: ~a~%"
				  te (car hists))
			  (cond ((not (tc-pre-check (car hists) te)))
				((setq uniqued-result
				       (get-result sig (car hists)))
				 (mark-as-proved te te)
				 (setq sig (get (car hists) 'unique-sig))
				 (add-to-sub-proofs sig (car hists)
						    uniqued-result)
				 (extend-node-result-upwards
				  node (car hists) sig uniqued-result))))
		      (next hists (cdr hists))))
	  (result (push node *PROCESSED-NODES*))))



(defun extend-node-result-upwards (n h sig desc)
  (if (member (car sig) '(fails interacts))
      (g-loop (init parent (node-parent n)
		    match-result nil child n)
	      (while (not (eql 'n1 (node-name parent))))
	      (do (cond ((setq match-result
			       (exp-pl-track desc 
					     (list (list (cadr sig) parent))
					     (node-state parent))))
			((not (node-goal-stack parent))
			 (format t "~%WARNING, extending to special node")
			 (setq match-result
			       (exp-pl-track desc 
					     (list (list (cadr sig) child))
					     (node-state child)))))
		  (cond (match-result
			 (format t "~%Extending ~a to ~a " (get h 'te)
				 (node-name parent))
			 (if (cdr match-result)
			     (format t "  -- mult bindings")))))
	      (until (not match-result))
	      (do (mark-as-proved (list (car sig) parent)
				  (get h 'te))
		  ;; use the parent node as a property for  dependencies
		  (setf (get h (node-name parent))
			(ebl-tracked-lits *SUCC-RECORD*)))
	      (next child parent
		    parent (node-parent parent))
	      (before-returning (extend-result-sideways child h sig desc))
	      (result (cond ((node-eql child n) nil)
			    ((eq (car sig) 'fails)
			     (extend-sav-est (get h 'learned-rule-nm) child))
			    ((eq (car sig) 'interacts)
			     (check-for-new-interacts child parent)))))))

; *SUB-PROOFS* is ((tc h te sig result)....)

(defun add-to-sub-proofs (sig h result)
  (push (list (car sig) h (get h 'te) sig result)
	*SUB-PROOFS*))

(defun extend-sav-est (rule-nm highn)
  (cond (rule-nm
	 (setf (get rule-nm 'est-savings)
	       (sum-savings (list highn)))
	 (setf (get rule-nm 'cum-savings)
	       (get rule-nm 'est-savings))
	 (setf (get rule-nm 'savings-extension-node) 'highn))))


; moving results up can allow us to prove interactions
; even if adding nodes had to terminate early

(defun check-for-new-interacts (c parent)
  (cond ((and (not (node-alternatives parent))
	      (eq 'maybe (node-gi-label c)))
	 (setf (node-gi-label c) 'yes))) ;changing gi-label!
  (cond ((and (not (node-alternatives parent))
	      (eq 'maybe (node-gi-label parent))
              (every #'(lambda (c) (and (not (eq (node-gi-label c) 'yes))
					(not (eq (node-gi-label c) 
						 'supporting-failure))))
		     (node-children parent)))
	 (setf (node-gi-label parent) 'yes)))) ; changing gi-label !


(defun extend-result-sideways (n h sig desc)
  (if (not (node-eql n (eval 'N1)))
      (g-loop (init brothers (g-map (c in (node-children (node-parent n)))
				    (when (not (node-eql n c)))
				    (save c))
		    bro nil)
	      (while (setq bro (pop brothers)))
	      (do (cond ((and (not (previously-proved (list (car sig) bro)))
			      (exp-pl-track desc 
					    (list (list (cadr sig) bro))
					    (node-state bro)))
			 (format t "~%Extending sideways ~a to ~a "
				 (get h 'te) (node-name bro))
			 (and (eq (car sig) 'interacts)
			      (eq (node-gi-label bro) 'maybe)
			      (setf (node-gi-label bro) 'yes))
			 (setf (get h (node-name bro))
			       (ebl-tracked-lits *SUCC-RECORD*)) ;dependencies
			 (mark-as-proved (list (car sig) bro)
					 (get h 'te))))))))



(defun mark-as-proved (te proved-te)
  (push (list te proved-te) *PROVED*)
  (if (member (car te) '(op-succeeds fails interacts))
      (unmark-bad-result te (cadr te)))) 

		
(defun previously-proved (te)
   (assoc te *PROVED* :test #'equal))

(defun get-proved-te (new-te)
    (cadr (assoc new-te *PROVED* :test #'equal)))

(defun was-proved-elsewhere (te)
    (let ((where-proved (assoc te *PROVED* :test #'equal)))
	 (and where-proved
	      (not (equal te (cadr where-proved))))))

; asumes node is always second in te, 

(defun was-proved-later-in-path (te)
    (let ((where-proved (cadr (cadr (assoc te *PROVED* :test #'equal))))
	  (node (cadr te)))
	 (and where-proved
	      (not (eq te where-proved))
	      (is-ancestor node where-proved))))


; modified for cl
(defun is-ancestor (dad n)
  (g-loop (next n (node-parent n))
	  (while n)
	  (do (if (node-eql n dad)
		  (return t)))))



(defun check-for-null-results (te)
  (let ((lst-nm (cond ((member (car te)
			       '(fails goal-fails op-fails bindings-fail
				       sole-op sole-goal))
		       '*NULL-F-RESULTS*)
		      ((member (car te) '(interacts goal-interacts 
					       op-interacts bindings-interact))
		       '*NULL-GI-RESULTS*)
		      ((member (car te) '(op-succeeds goal-succeeds
						      bindings-succeed)) 
		       '*NULL-S-RESULTS*))))
    (member (cadr te) (eval lst-nm))))



(defun upper-node-interaction-proved-so-ignore-lower-interaction (node)
  (g-loop (while node)
	  (do (if (some #'(lambda (entry) (and (node-eql (cadar entry) node)
					       (eq (caar entry) 'interacts)))
			*PROVED*)
		  (return node)))
	  (next node (node-parent node))
	  (result nil)))

; converted to use node-structures

(defun upper-node-failed (node)
  (g-loop (while node)
	  (do (if (some #'(lambda (entry) (and (node-eql (cadar entry) node)
				  	       (eq (caar entry) 'fails)))
			*PROVED*)
		  (return node)))
	  (next node (node-parent node))
	  (result nil)))


(defun tc-pre-check (h te)
    (cond ((previously-proved te)
	   (format t "~%Training Example Previously Proved: ~a" te)
	   nil)
	  ((and (eq (car te) 'fails) ;  only case where this should happen
		(node-optimize-mode-failure (getn h)))
	   (format t "~%optimize mode failure, don't bother with fails~%")
	   nil)
	  ((and (eq (car te) 'interacts)
		(upper-node-interaction-proved-so-ignore-lower-interaction (cadr te)))
	   (format t "~%Interaction already explained above.")
	   nil)
	  ((check-for-null-results te)
	   (format t "~%Warning: couldnt get subresult, not bothering")
	   nil)
	  (t t)))

    
(defun node-pre-check (node)
    (cond ((not (node-state node)) ;  set on all prodigy nodes
	   (format t "~%Node :  is not a PRODIGY node.  ~a" node) 
	   nil)
	  ((member node *PROCESSED-NODES*) 
	   (format t "~%Already processed node ~a" node)
	   nil)
	  ((and (node-added-after-restart node)
		(eq 'yes (node-gi-label (eval 'N1)))
		(not (node-succeeded node)))
	   (format t "~%opt mode failure, no-gi-learning on anyway~%")
	   nil)
	  (t t)))

; redo THESE

(defun te-to-hist (te)
  (g-loop (init proved-te (get-proved-te te)
		subs *SUB-PROOFS* entry nil 
		sig (get (car proved-te) 'signature))
	  (while (setq entry (pop subs)))
	  (do (if (equal proved-te (cached-te entry))
		  (return (cadr entry))))
	  (result nil)))

(defun hist-to-te (h sig)
  (cons (car sig)
	(g-map (attr in (cdr (get (car sig)
				  'sig-hist-map)))
	       (save (get h attr)))))

	      	
(defun make-history-bindings (h sig)
  (g-map (v in (cdr sig))
	 (attr in (cdr (get (car sig) 'sig-hist-map)))
	 (when (is-variable v))
	 (save (list v (get h attr)))))


; needed, because the search isn't guaranteed to be depth-first 
; otherwise could just use next-node!

(defun postorder (n)
    (cond ((node-children n)
	   (nconc (g-map (c in (reverse (node-children n)))
		       (splice (postorder c)))
		 (list n)))
	  ((list n))))


(defun mark-bad-result (sig n)
  (if (member (car sig) '(fails interacts op-succeeds))
      (g-loop (init lst-nm (cond ((eq (car sig) 'fails) '*NULL-F-RESULTS*)
				 ((eq (car sig) 'interacts) '*NULL-GI-RESULTS*)
				 ((eq (car sig) 'op-succeeds) '*NULL-S-RESULTS*)))
	      (while n)
	      (do (and (assoc sig *PROVED* :test #'equal) (return))
		  (set lst-nm (cons n (eval lst-nm)))
		  (cond ((and (eq (car sig) 'fails)
			      (eq (node-gi-label n) 'supporting-failure))
			 (mark-bad-result (list 'interacts n) n))))
	      (until (not (node-parent n)))
	      (next n (node-parent n)))))
    
(defun unmark-bad-result (sig n)
  (if (member (car sig) '(fails interacts op-succeeds))
      (g-loop (init lst-nm (cond ((eq (car sig) 'fails) '*NULL-F-RESULTS*)
				 ((eq (car sig) 'interacts) '*NULL-GI-RESULTS*)
				 ((eq (car sig) 'op-succeeds) '*NULL-S-RESULTS*)))
	      (while n)
	      (do (cond ((member n (eval lst-nm))
			 (set lst-nm (del-equal n (eval lst-nm))))
			((return nil)))
		  (cond ((and (eq (car sig) 'fails)
			      (eq (node-gi-label n) 'supporting-failure))
			 (unmark-bad-result
			  (list 'interacts n) n))))
	      (until (not (node-parent n)))
	      (next n (node-parent n)))))


;  if we can intercompress with more than one rule,
; may what to add timestring..

(defun new-scr-nm (h)
  (let ((nm (cond ((get h 'orig-hst) ; intercompressed
		   (intern 
		    (concatenate 'string
				 "R-" (prin1-to-string *NUM-RUNS*)
				 "-I-" (subseq (symbol-name h) 3))))
		  (t (intern
		      (concatenate 'string "R-" (prin1-to-string *NUM-RUNS*)
				   "-"  (subseq (symbol-name h) 3)))))))
    (cond ((member nm *LEARNED-RULES*) 
	   (format t "~%warning...duplicate nm encountered")
	   (g-loop (init new-nm nil conflict-num 0)
		   (do (setq new-nm
			     (intern
			      (concatenate 'string (symbol-name nm) "-"
					   (prin1-to-string conflict-num))
			      'USER)))
		   (until (not (member new-nm *LEARNED-RULES*)))
		   (next conflict-num (+ 1 conflict-num))
		   (result new-nm)))
	  (t (setf (symbol-plist nm) nil)
	     nm))))



(defun make-learned-scr-rule (h unique-sig exp)
    (let ((sig (get (car (get h 'te)) 'signature))
	  (tc (car unique-sig))
	  lhs-desc rhs-desc nm template tmp-lhs-rhs
	  old-vars new-vars)
; subst in rule-vars
	 (setq old-vars (find-all-vars (list unique-sig exp)))
	 (setq new-vars (make-n-rule-unique-vars (length old-vars)))
	 (setq unique-sig (subpair old-vars new-vars unique-sig))
	 (setq exp (subpair old-vars new-vars exp))
	 (setq exp (change-bindings-vars-type unique-sig exp))
	 (setq nm (new-scr-nm h))
	 (setf (get nm 'unique-sig) unique-sig)
	 (setf (get nm 'lhs-for-ebs) exp)
	 (setq template (get (car sig) 'sc-rule-template))
	 (setq template (subpair (cdr (get tc 'signature))
			    (cdr unique-sig)
			    template))
	 (setq rhs-desc (cadr (caddr template)))
	 (setq rhs-desc (subst-is-equals-from-lhs rhs-desc exp))
	 (setq lhs-desc (cadr (cadr template)))
	 (setq lhs-desc (subst exp unique-sig lhs-desc
			       :test #'equal))
	 (setq lhs-desc (outer-simplify lhs-desc))
	 (setq tmp-lhs-rhs (check-for-needed-subvars rhs-desc lhs-desc))
	 (setq lhs-desc (car tmp-lhs-rhs) rhs-desc (cadr tmp-lhs-rhs))
	 (setf (get nm 'rhs) rhs-desc)
	 (setf (get nm 'lhs) lhs-desc)
	 ; may want to change priority to least important...
	 (cond ((eq (car rhs-desc) 'prefer)
		(setf (get nm 'priority) 0)))
	 (push nm *LEARNED-RULES*)
	 (push nm *NEW-LEARNED-RULES*)
         (cond ((boundp '*PROB-NM*)
	        (setf (get nm 'problem) *PROB-NM*))
               (t (setf (get nm 'problem) 'Unnamed-problem)))
	 (setf (get nm 'training-ex) (get h 'te))
	 (setf (get nm 'was-learned) t)
	 (setf (get h 'learned-rule-nm) nm)
	 (setf (get nm 'history) h)
	 (setf (get nm 'est-cost) (get h 'est-cost))
	 (setf (get nm 'est-savings) (get h 'est-savings))
	 (setf (get nm 'cum-savings) (get h 'est-savings))
	 (format t "~%New Learned Rule: ~a" nm )	 
	 nm
    ))


; oops, have to make sure than candidate bindings are constants!
; using special type of variable. See meta-fn candidate-bindings.

(defun change-bindings-vars-type (sig exp)
  (prog (bindings-vars eq-constraint sig-var un-exp)
	(cond ((< (length sig) 5)
	       (return exp)))
	(setq sig-var (elt sig 4))
	(setq eq-constraint (get-eq-constraint sig-var exp))
	(and (null eq-constraint)(error "change-bindings-vars error"))
	(setq bindings-vars (cond ((eq sig-var (cadr eq-constraint))
				   (caddr eq-constraint))
				  (t (cadr eq-constraint))))
	(and bindings-vars (atom bindings-vars) 
	     (error "error2,change bindings-vars"))
	(setq un-exp (subst t eq-constraint exp :test #'equal))
	(return (subpair 
		 bindings-vars
		 (g-map (v in bindings-vars)
			(save (cond ((r-memq v un-exp)
				     (intern (concatenate 'string
							  "<&"
							  (subseq
							   (symbol-name v)
							   1))
					     'USER))
				    (t v))))
		 exp))))



(defun get-eq-constraint (var exp)
  (cond ((atom exp) nil)
	((atomic-formula-p exp)
	 (cond ((and (eq (car exp) 'is-equal)
		     (or (equal (cadr exp) var)
			 (equal (caddr exp) var)))
		exp)
	       (t nil)))
	(t (g-loop (init ret-val nil)
		   (next exp (cdr exp))
		   (while exp)
		   (do (setq ret-val (get-eq-constraint var (car exp)))
		       (if ret-val (return ret-val)))
		   (result nil)))))
		 


; oops, tc-specs may leave a variable on rhs, and
; scntrl doesn't like that right now.

(defun check-for-needed-subvars (rhs lhs)
    (cond ((and (eq (car rhs) 'prefer)
		(eq (cadr rhs) 'bindings)
		(g-map (v in rhs) 
		      (when (is-variable v))
		      (save v)))
	   (let (new-subvars op old-var)
	     (setq op (caddr (get-form-from-exp 'current-op lhs)))
		(cond ((null op) (error "CHECK-FOR-NEEDED-SUBVARS: null op"))
		      ((is-variable op)
		       (error "CHECK-FOR-NEEDED-SUBVARS: var op")))
		(setq new-subvars 
		      (make-n-new-vars (length (get op 'params))))
		(setq old-var 
		      (car (g-map (v in rhs) 
				 (when (is-variable v))
				 (save v))))
		(subst new-subvars old-var (list lhs rhs))))
	  ((list lhs rhs))))

		
		     
(defun load-new-scrs ()
    (format t  "~%~a new rules added.~%" (length *NEW-LEARNED-RULES*))
    (setq *LAST-NUM-RULES-ADDED* (length *NEW-LEARNED-RULES*))
    (g-loop (init nm nil new-rules (nreverse *NEW-LEARNED-RULES*))
	  (while (setq nm (pop new-rules)))
	  (do (push nm *LEARNED-RULES-IN-SYS*)
	      (dynamically-add-scr nm))
	  (result (setq *NEW-LEARNED-RULES* nil)))
    t)


; there is usually at least one is-equals that should be substituted in...

(defun subst-is-equals-from-lhs (rhs-desc exp)
    (g-loop (init ret-val nil rhs-guy nil)
	  (while (setq rhs-guy (pop rhs-desc)))
	  (do (cond ((is-variable rhs-guy)
		     (push (get-lhs-is-equal rhs-guy exp) ret-val))
		    ((push rhs-guy ret-val))))
	  (result (nreverse ret-val))))


(defun get-lhs-is-equal (rhs-var exp)
    (g-loop (init ret-val nil sub nil)
	  (while (setq sub (pop exp)))
	  (do (cond ((atom sub))
		    ((and (eq 'is-equal (car sub))
			  (member rhs-var sub))
		     (cond (ret-val (error "two relevant is-equals"))
			   ((eq (cadr sub) rhs-var)
			    (setq ret-val (caddr sub)))
			   ((setq ret-val (cadr sub)))))))
	  (result (or ret-val rhs-var))))



(defun replace-non-unique-vars (exp all-vars)
  (let* ((non-unique-vars (remove-duplicates 
			   (g-map (v in all-vars)
				  (when (not (is-unique-var v)))
				  (save v))))
	 (new-uniques (make-n-unique-vars (length non-unique-vars))))
    (subpair non-unique-vars new-uniques exp)))





; hack to take care of 	
;  (... (forall <x> (inroom a <x>))
;       (forall <x> (inroom b <x>))..)
;  singleton-gen-simplifier puts a and b in same room...
; cant just change names since may be defined outside


(defun check-dual-forall-vars (exp orig-exp)
  (cond ((atom exp) nil)
	((eq 'forall (car exp))
	 (cond ((and (or (assoc (car (get-gen-exp exp)) *SINGLETON-PREDS*)
			 (and (eq 'known (car (get-gen-exp exp)))
			      (assoc (caaddr (get-gen-exp exp)) *SINGLETON-PREDS*)))
		     (theres-another-forall orig-exp (get-vars-lst exp) exp)
		     (or (format t "~%Looks Suspiciously like dual vars") t)
		     (not (look-for-outside-definers 
			   (get-vars-lst exp) orig-exp)))
		(format t "~%WARNING, CONFIRMED -- DUAL VARS, will realign~a"
			(get-vars-lst exp))
		(list exp))
	       ((or (check-dual-forall-vars (get-gen-exp exp) orig-exp)
		    (check-dual-forall-vars (get-exp exp) orig-exp)))))
	((member (car exp) '(and or exists))
	 (g-map (sub in (cdr exp))
		(splice (check-dual-forall-vars sub orig-exp))))
	(t nil)))


(defun subst-dual-foralls (exp dual-forall-exps)
    (cond ((atom exp) exp)
	  ((atomic-formula-p exp) exp)
	  ((member exp dual-forall-exps)
	   (subpair (get-vars-lst exp) 
	       (make-n-proof-vars (length (get-vars-lst exp)))
	       exp))
	  ((g-map (sub in exp)
		 (save (subst-dual-foralls sub dual-forall-exps))))))

	
				 
; look for outside definers -- vars not defined by foralls

(defun look-for-outside-definers (vars exp)
    (cond ((atom exp) nil)
	  ((atomic-formula-p exp) (intersect vars exp))
	  ((member (car exp) '(and or))
	   (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (and (look-for-outside-definers  vars (car exp))
			  (return t)))))
	  ((and (eq 'forall (car exp))
		(intersectq (get-vars-lst exp) vars)) nil)
	  ((member (car exp) '(forall exists))
	   (or (look-for-outside-definers vars (get-gen-exp exp))
	       (look-for-outside-definers vars (get-exp exp))))
	  ((negated-p exp) nil)
	  ((error "bad-exp"))))
	 

				
(defun theres-another-forall (exp vars forall-exp)
    (cond ((atom exp) nil)
	  ((atomic-formula-p exp) nil)
	  ((member (car exp) '(and or))
	   (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (and (theres-another-forall (car exp) vars forall-exp)
			  (return t)))))
	  ((negated-p exp) nil)
	  ((eq exp forall-exp) nil)
	  ((and (eq 'forall (car exp))
	        (not (eql exp forall-exp))
		(intersectq (get-vars-lst exp) vars))
	   t)
	  ((member (car exp) '(forall exists))
	   (or (theres-another-forall (get-gen-exp exp) vars forall-exp)
	       (theres-another-forall (get-exp exp) vars forall-exp)))
	  ((error "bad-exp"))))
	
