#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *ALL-NODES* *L-RESULTS* *EBL-PRINTING*
          *LEARNED-RULES-IN-SYS* *TRIM-FACTOR* *RULE-LST-NMS* *EBL-FLAG*
	  *INCR-LEARNING* *OPTIMIZE-MODE* *HALT-PROBLEM-SOLVER* 
	  *ONLY-TOP-GIS* *MAX-EXP-SIZE* *OBS-HIST* *HALT*
	  *TARGET-CONCEPTS* *LAST-TRIMMED-RULES* *TESTER* *MATCHER-TRACING* 
	  *MACRO-LEARNING* *START-STATE* *NULL-F-RESULTS* *NULL-GI-RESULTS* 
	  *NULL-S-RESULTS* *PROVED* *SUB-PROOFS* *LEARNED-RULES*
	  *NEW-LEARNED-RULES* *PROCESSED-NODES* *NUM-RUNS* *SUCC-RECORD*
	  *RULE-STACK* *EBL-PRINTING*))



(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


(defun reset-obs ()
    (reset-hists)
    (setq *NULL-F-RESULTS* nil)
    (setq *NULL-GI-RESULTS* nil)
    (setq *NULL-S-RESULTS* nil)
    (setq *PROCESSED-NODES* nil)
    (setq *NEW-LEARNED-RULES* nil)
    (setq *PROVED* nil)
    (setq *SUB-PROOFS* nil)
    (format t "~%OBSERVER reset~%")
    (reset-unique-vars)
    (format t "~%Number of rules learned: ~a" (length *LEARNED-RULES*))
    (format t "~%Number of learned rules still in: ~a~%" (length *LEARNED-RULES-IN-SYS*))
    t)


(defun find-rules-with-tc (tcs)
    (g-loop (init sys-rules *LEARNED-RULES-IN-SYS* r nil ret-val nil)
	  (while (setq r (pop sys-rules)))
	  (do (cond ((not (member (car (get r 'unique-sig)) tcs))
		     (push r ret-val))))

          (result ret-val)))



(defun o1 (top-node)
    (format t "~%Observer 1 invoked")
    (or *EBL-FLAG* (error "*EBL-FLAG* not set"))
    (setq *INCR-LEARNING* nil  
	  *OPTIMIZE-MODE*  nil 
	  *HALT-PROBLEM-SOLVER* nil
          *NUM-RUNS* (+ 1 *NUM-RUNS*))
    (if (not (node-first-succ-node (eval 'N1)))
        (setf (node-first-succ-node (eval 'N1))  (first-succ-node)))
    (cond ((node-top-gi-found (eval 'N1))
	   (setq *ONLY-TOP-GIS* t))
	  (t (setq *ONLY-TOP-GIS* nil)))
    (add-history-info-to-tree)
    (tc-process-single-node top-node))
	

			   
		  
(defun o2 (top-node)
  (cond ((not (node-children N1))
	 (format t "~%No learning")
	 nil)
	(t (format t "~%Observer 2 invoked")
	   (or *EBL-FLAG* (error "*EBL-FLAG* not set"))
	   (setq *INCR-LEARNING* nil  
		 *OPTIMIZE-MODE*  nil 
		 *HALT-PROBLEM-SOLVER* nil)
	   (setq *NUM-RUNS* (+ 1 *NUM-RUNS*))
	   (if (not (node-first-succ-node (eval 'N1)))
	       (setf (node-first-succ-node (eval 'N1))  (first-succ-node)))
	   (cond ((node-top-gi-found (eval 'N1))
		  (setq *ONLY-TOP-GIS* t))
		 (t (setq *ONLY-TOP-GIS* nil)))
	   (cond ((straight-solution N1)
		  (format t "~%straight to solution")
		  (setf (node-straight-solution (eval 'N1)) t)))
	   (setf (node-estart-time (eval 'N1)) (get-internal-run-time))
	   (add-history-info-to-tree)
	   (cond ((and (not (node-did-interactions (eval 'N1)))
		       (interaction-tcs))
		  (setf (node-did-interactions (eval 'N1)) t)
		  (interaction-check (eval 'N1))))
	   (setf (node-estop-time (eval 'N1)) (get-internal-run-time))
	   (setq *ONLY-TOP-GIS* nil) ; unnecessary
	   (cond (*SUB-PROOFS*
		  (format t "~%STARTING o2 MIDWAY")))
	   (setq *OBS-HIST* nil)
	   (setf (node-lstart-time (eval 'N1)) (get-internal-run-time))
	   (tc-process-nodes top-node)
	   (setf (node-lstop-time (eval 'N1)) (get-internal-run-time)))))

; uses node structure
(defun get-path-to-top (n)
  (g-loop (init ret-val (list n))
	  (while (setq n (node-parent n)))
	  (do (push n ret-val))
	  (result ret-val)))

; bot node is assumed to be reg-success

(defun no-optimal-path (bot-node)
  (prog (found-top-gi)
	(if (not (and (node-children bot-node)
		      (node-succeeded (car (node-children bot-node)))))
	    (error "no such success node"))
	(setq *ONLY-TOP-GIS* t)
	(g-loop (init path (get-path-to-top bot-node))
		(while path)
		(do (cond ((hist-protection-violation (car path) nil)
					; return to virgin state
			   (setf (node-protection-violation (car path)) nil)
			   (setq found-top-gi t))))
		(next path (cdr path))
		(until found-top-gi))
	(setq *ONLY-TOP-GIS* nil)
	(cond (found-top-gi
	       (format t "~%Found Top-level GI on success path~%")
	       (setf (node-top-gi-found (eval 'N1)) t))
	      (t (format t "~%no go, no top-level GI on success path~%")))))
		  

(defun optimal-path (bot-node)
  (prog (found-top-gi found-reg-gi)
	(if (not (and  (node-children bot-node)
		       (node-succeeded (car (node-children bot-node)))))
	    (error "no such success node"))
	(setq *ONLY-TOP-GIS* t)
	(g-loop (init path (get-path-to-top bot-node))
		(while path)
		(do (cond ((hist-protection-violation (car path) nil)
			   ;; return to virgin state
			   (setf (node-protection-violation (car path)) nil)
			   (setq found-top-gi t))))
		(next path (cdr path))
		(until found-top-gi))
	(setq *ONLY-TOP-GIS* nil)
	(cond (found-top-gi
	       (format t "~%no go, Top-level GI on optimal path~%")
	       (return)))
	(g-loop (init path (get-path-to-top bot-node))
		(while path)
		(do (cond ((or (hist-prerequisite-violation
				(car path)
				(car (alt-unmatched-conds ; usual 1 goal assumption
				      (node-generating-alt
				       (car path)))) nil)
			       (hist-protection-violation (car path) nil))
			   ;; return to virgin state
			   (setf (node-protection-violation (car path))
				 nil)
			   (setq found-reg-gi t))))
		(next path (cdr path))
		(until found-reg-gi))
	(cond (found-reg-gi
	       (setf (node-top-gi-found (eval 'N1)) t)
	       (format t "~%DID find reg GI along optimal path and no top-gi ~%"))
	      (t (format t "~%NO reg-gi found along opt path~%")))
	(return t)))





(defun get-result (sig hist)
  (prog (initial-result simplified-result ordered-result uniqued-result
			further-simplified-result dual-foralls)
        (setq *RULE-STACK* nil)
        (reset-proof-vars)
        ;; if an problem is reported below, we will catch, and get a nil result
        (catch 'learning-result
            (setq initial-result 
		(ps-descend-match sig '((nil nil)) hist)))
	(if *EBL-PRINTING*
	    (let ((*print-level* nil))
	      (format t "~%INITIAL-RESULT:")
	      (format t "~%~a if " sig)
	      (pprint initial-result)))
	(and (setq dual-foralls 
		   (check-dual-forall-vars initial-result initial-result))
	     (setq initial-result 
		   (subst-dual-foralls initial-result dual-foralls))
	     *EBL-PRINTING*
	     (pprint initial-result))
	  ; the "not" should be "~", but change it everywhere,(eg. pl-simp, inter.l)
	(setq simplified-result ; shouldn't change sig!
	      (simplify `(or (not ,sig) ,initial-result)))
	(if *EBL-PRINTING*
	    (let ((*print-level* nil))
	      (format t "~2%SIMPLIFIED-RESULT:")
	      (format t "~%~a if " sig)
	      (pprint (caddr simplified-result))))
	(cond ((< (length simplified-result) 3)
	       (warning-stop)		   		 
	       (setq simplified-result nil))
	      ((eq (length simplified-result) 3)
	       (setq simplified-result (caddr simplified-result)))
	      ((> (length simplified-result) 3)
	       (setq simplified-result (cons 'or (cddr simplified-result)))))
	(cond ((and simplified-result 
		    (not (get hist 'dont-make-rule)))
	       (format t "~%Turning on TP")
	       (setq further-simplified-result 
		     (top-level-tp simplified-result
				   `((or (not ,sig) ,simplified-result))))
	       (if (and *EBL-PRINTING* (not (equal further-simplified-result
						   simplified-result)))
		   (progn
		     (format t "~%FURTHER-SIMPLIFIED-RESULT:")
		     (let ((*print-level* nil))
		       (format t "~%~a if " sig)
		       (pprint further-simplified-result)))))
	      (t (setq further-simplified-result simplified-result)))
	(if (> (count-atomics further-simplified-result) *MAX-EXP-SIZE*)
	   (progn
	     (if *EBL-PRINTING*
		(format t "~%Eliminating horrible result from consideration!"))
	     (setq further-simplified-result nil)))
	(setq ordered-result
	      (reorder-exp-for-match further-simplified-result (cdr sig)))
	(setq uniqued-result 
	      (uniqify ordered-result sig hist (get hist 'node)))
	(return uniqued-result)))

; 
; Forall variables that are not unique...subst in unique ones, get
; the unique bindings, match, and update unique bindings.

; could get values for new vars from child generating alts, but
; what if two operators have the same var names -- could be disaster!

(defun uniqify (exp sig h node)
    (prog (new-bindings-lists new-sig in-bindings init-time now-time 
	      match-time old-op-tracing old-print-tracing)
	  (setq exp (replace-non-unique-vars exp (find-all-vars exp)))
	  ;; have to do this bs to get unique vars, but we keep exp for
	  ;; rule-making
	  (setq new-sig (cons (car sig) (make-n-unique-vars (length (cdr sig)))))
	  (setq exp (subpair (cdr sig) (cdr new-sig) exp)) 
	  (setq sig new-sig)
	  (setf (get h 'unique-sig) new-sig)
	  (setq in-bindings (g-map (val in (cdr (get h 'te)))
                   	           (var in (cdr sig))
		                   (save (list var val))))
	  (setq init-time (get-internal-run-time))
	  (setq new-bindings-lists (exp-pl-track ;;does match count,may want to
				       exp       ;;; change mode to "one"
				       in-bindings
				       (node-state node)))
	  (setq now-time (get-internal-run-time))
	  (setq match-time  (- now-time init-time))
	  (cond ((and (boundp '*TESTER*) ; for debugging
		      *TESTER*)
                 (setq old-op-tracing *OP-TRACING*)
		 (setq *OP-TRACING* t) ; should save old values !!!!!
                 (setq old-print-tracing *PRINT-TRACING*)
                 (setq *print-tracing* t)
		 (exp-match exp in-bindings (node-state node))
                 (setq *print-tracing* OLD-PRINT-TRACING)
		 (setq *OP-TRACING* old-op-tracing)))
	  (cond (new-bindings-lists
		    (and (cdr new-bindings-lists)
			 (format t "~%At node ~a multiple potential bindings~%"
				 node))
		    (setf (get h (node-name node))
			  (ebl-tracked-lits *SUCC-RECORD*)) ; dependencies
		    (cond ((and *MACRO-LEARNING* 
				(not (get h 'dont-make-rule)))
			   (make-macro exp sig h))
			  ((and (node-dont-learn-fails (eval 'N1))
				(member (car sig) 
                                  '(fails op-fails goal-fails bindings-fail)))
			   (format t "~%Not learning from failure flag set"))
			  ((and (not (get h 'dont-make-rule))
				(utility-est h exp match-time)
				(not (has-potential-bug sig exp)))
			   (make-learned-scr-rule h sig exp)
			   (inter-compress exp sig in-bindings (get h 'te)
			       match-time (get h 'est-savings) h))
			  ((get h 'dont-make-rule)
			   (format t "~%No rule: Dont-make-rule-flag -- ~a"
				   (get h 'dont-make-rule)))
			  (t (format t "~%No rule: Neg Utility Est.")))
		    (return exp))
		((null exp)
		 (mark-bad-result sig (getn h))
		 (return nil))
		(t (format t "~%Warning, UNIQUIFY: Cant find match~%" )
		   (warning-stop)		   
		   (mark-bad-result sig (getn h))
		   (return nil)))))

(defun has-potential-bug (sig exp)
    (cond ((and (eq (car sig) 'sole-op)
		(get-forms-from-exp 'is-top-level-goal exp))
	   (format t "~%Being careful, has potential bug, no rule")
	   t)))


; Hack, counts on *ALL-NODES* being created in depth-first manner
  
  (defun first-succ-node ()
    (setf (node-first-succ-node (eval 'N1)) 
	  (g-loop (init n nil tmp-nodes (reverse *ALL-NODES*))
		  (while (setq n (pop tmp-nodes)))
		  (do (cond ((and (eql '*FINISH*
				       (alt-op (node-generating-alt n)))
				  (node-applied-node n))
			     (return n)))))))
    


(defun straight-solution (n)
    (let ((cs (node-children n)))
	 (cond ((and (node-succeeded n)
		     (null cs))
		t)
	       ((null cs) nil)
	       ((> (length cs) 1) nil)
	       ((straight-solution (car cs))))))
	  
			    

		 
      
	 


