#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

;******* VERSION 1-34 ******* Locked by nobody *******

; Contains the match routines for PRODIGY. 

(proclaim '(special *SUCC-RECORD* *MATCH-COUNT* *CLOSED-PREDS* *EBL-FLAG*
	     *FAILURE-RECORDING* *STATE* *FAILURE-RECORD*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))




;  MAJOR change was really only to forall-match
;  I assume there are no (known (forall ....)) or 
;  for that matter, anthing other than known atomics


(defun exp-pl-track (exp in-bindings state)
    (setq *SUCC-RECORD* nil)
    (setq *STATE* state
	  *MATCH-COUNT* 0
	  *FAILURE-RECORD* nil
	  *FAILURE-RECORDING* nil)
    (and exp
	 (descend-pl-track exp (or in-bindings (list '(nil nil))) 'all)))




;  This is the recursive match routine that does all the work. 
;  (Can make more efficient by remmoving atomic formula test & moving to rear)

(defun descend-pl-track (exp bindings mode)
    (cond ((null *SUCC-RECORD*))
	  ((atom (caaar *SUCC-RECORD*)))
	  ((error "got one")))
    (cond ((eq exp t)
	   (list *SUCC-RECORD*)
	   (list bindings))
	  ((eq (car exp) 'and)
	   (and-pl-track (cdr exp) bindings mode))
	  ((eq (car exp) 'exists)	       
	   (exists-pl-track bindings (get-gen-exp exp)(get-exp exp) mode))
	  ((eq (car exp) 'forall)
	   (forall-pl-track bindings (get-gen-exp exp)(get-exp exp) mode))
	  ((eq (car exp) '~)
	   (let ((result (negation-match (cadr exp) bindings)))
		(setq *FAILURE-RECORDING* nil)
		(cond ((not (null result))
		       (cond ((not (eq (caadr exp) 'exists))
			      (setq *SUCC-RECORD*  
				    (list (cons (list exp bindings) 
						*SUCC-RECORD*))))
			     ((setq *SUCC-RECORD* (list *SUCC-RECORD*))))
		       result)
		      (t (setq *SUCC-RECORD* nil)
			 nil))))
	  ((eq (car exp) 'or)
 	   (or-pl-track (cdr exp) bindings mode))
	  ((null exp) 
	   (setq *SUCC-RECORD* (list *SUCC-RECORD*))
	   (list bindings))
	  ; must be an atomic formula
	  ((let ((vals (gen-values exp bindings)))
		(cond ((or (null vals) 
			   (eq vals 'no-match-attempted))
		       (setq *SUCC-RECORD* nil) 
		       nil)
		      ((eq vals t)
		       (setq *SUCC-RECORD* (list (cons (list exp bindings)
						     *SUCC-RECORD*)))
		       (list bindings))
		      ((let ((new-bls (g-map (b in vals); should replace with nconc 
					    (save (append b bindings)))))
			    (setq *SUCC-RECORD* ; can be more efficient?
				  (g-map (b in new-bls)
					(save (cons (list exp b)
						    *SUCC-RECORD*))))
			    new-bls)))))))

				
(defun and-pl-track (exps bindings mode)
    (cond ((null exps)
	   (setq *SUCC-RECORD* (list *SUCC-RECORD*))
	   (list bindings))
	  ((null (cdr exps))
	   (descend-pl-track (car exps) bindings mode))
	  ((g-loop (init new-bls (descend-pl-track (car exps) bindings mode)
		       ret-val nil gen-succ-records *SUCC-RECORD* subresult nil
		       new-succ-records nil) ; in order
		 (while new-bls)
		 (do (setq *SUCC-RECORD* (pop gen-succ-records))
		     (setq subresult 
			   (and-pl-track (cdr exps) (pop new-bls) mode))
		     (and subresult 
			  (setq new-succ-records 
				(nconc *SUCC-RECORD* new-succ-records)))
     		     (setq ret-val (nconc subresult ret-val)))
		 (until (and ret-val (eq mode 'one)))
		 (result (progn (setq *SUCC-RECORD* new-succ-records)
				(and (not (eql (length *SUCC-RECORD*)
					       (length ret-val)))
				     (error "NEW-PL-TRACK"))
				ret-val))))))
		     

(defun or-pl-track (exps bindings mode)
    (g-loop (init subresult nil exp nil new-succ-records nil 
		orig-succ-record *SUCC-RECORD* ret-val nil)
	  (while (setq exp (pop exps)))
	  (do (setq *SUCC-RECORD* orig-succ-record)
	      (setq subresult (descend-pl-track exp bindings mode))
	      (and subresult 
		   (setq new-succ-records 
			 (nconc *SUCC-RECORD* new-succ-records)))
	      (setq ret-val (append subresult ret-val)))  ; no nconc
	  (until (and (eq mode 'one) subresult)) ; cause we test
						 ; subresult here
	  (result (progn (setq *SUCC-RECORD* new-succ-records) 
			 ret-val))))


(defun forall-pl-track (start-bindings gen-exp exp mode)
    (g-loop (init values (gen-values gen-exp start-bindings) bindings nil
		gen-succ-records nil new-succ-records nil
		bls nil)
	  (before-starting  ; make sure values are good
	      (cond ((null values)
		     (setq *SUCC-RECORD* (list *SUCC-RECORD*)) ;  DO WE WANT TO
				; PUT NOT on it?
		     (return (list start-bindings)))
		    ((eq values 'no-match-attempted) 
		     (setq *SUCC-RECORD* nil)
		     (return nil))
		    ((eq values t)
		     (push (list gen-exp start-bindings) *SUCC-RECORD*)
		     ;  note, we keep mode here, unlike matching
		     (return (descend-pl-track exp start-bindings 'one)))
		    (t (setq bls (g-map (b in values)
				       (save (append b start-bindings))))
		       (setq gen-succ-records
			     (g-map (b in bls)
				   (save (cons (list gen-exp b) *SUCC-RECORD*)))))))
	  (while bls)
	  (next bindings (pop bls))
	  (do (setq *SUCC-RECORD* (pop gen-succ-records))
	      (cond ((not (descend-pl-track exp bindings 'one)) 
		     (setq *SUCC-RECORD* nil)
		     (return)))
	      (setq new-succ-records 
		    (nconc *SUCC-RECORD* new-succ-records)))
	  (result (progn (setq *SUCC-RECORD* 
			       (list (apply 'append new-succ-records)))
			 (list start-bindings)))))


; Matches an existentially quantified expression. Returns start-bindings,
; with the new var-value pairs appended on front. 

(defun exists-pl-track (start-bindings gen-exp exp mode)
    (g-loop (init values (gen-values gen-exp start-bindings) bls nil
		subresult nil subresults nil bindings nil new-succ-records nil
		gen-succ-records nil)
	  (before-starting 
	      (cond ((null values)
		     (setq *SUCC-RECORD* nil)
		     (return))
		    ((eq values 'no-match-attempted)
		     (setq *SUCC-RECORD* nil)
		     (return))
		    ((eq values t)
		     (push (list gen-exp start-bindings) *SUCC-RECORD*)
		     (return (descend-pl-track exp start-bindings mode)))
		    (t (setq bls (g-map (b in values)
				       (save (append b start-bindings))))
		       (setq gen-succ-records
			     (g-map (b in bls)
				   (save (cons (list gen-exp b) *SUCC-RECORD*)))))))
	  (while bls)
	  (next bindings (pop bls))
	  (do (setq *SUCC-RECORD* (pop gen-succ-records))
	      (setq subresult (descend-pl-track exp bindings mode))
	      (and subresult 
		   (setq new-succ-records
			 (nconc *SUCC-RECORD* new-succ-records)))
	      (setq subresults (append subresult subresults))) ; no nconc
				; cause of test below
	  (until (and subresults (eq mode 'one)))
	  (result (progn (setq *SUCC-RECORD* new-succ-records)
			 subresults))))


;  ------


(defun ebl-tracked-lits (s-records)
    (setq s-records (apply 'append s-records))
    (g-loop (init ret-val nil bls nil exp nil entry nil)
	  (while s-records)
	  (do (setq exp (caar s-records))
	      (cond ((or (assoc exp ret-val) ;  NOTE EQ
		         (and (eq 'known (car exp))
			      (assoc (caddr exp) ret-val))))
		    ((not (is-trackable (car exp))))
		    ((setq entry
			   (get-inst-lits-from-tracking exp s-records))
		     (push entry ret-val))))
	  (next s-records (cdr s-records))
	  (result ret-val)))

(defun is-trackable (pred)
    (or (member pred '(alt-on-deck has-bound-vars on-goal-stack previous-state-diff 
			was-added was-deleted was-deleted-by in-goal-exp
			protected-goal adjunct-goal is-top-level-goal known))
	(member pred *CLOSED-PREDS*)))

(defun get-inst-lits-from-tracking (exp s-records)
    (g-loop (init ilit nil ret-val nil)
	  (while s-records)
	  (do (cond ((eq exp (caar s-records)) ; eq?
		     (cond ((eq (car exp) 'known)
			    (setq ilit (subst-bindings (caddr exp)
					   (cadar s-records))))
			   ((setq ilit (subst-bindings exp
					   (cadar s-records)))))
		     (or (member ilit ret-val :test #'equal)
			 (push ilit ret-val)))))
	  (next s-records (cdr s-records))
	  (result (cond ((eq (car exp) 'known)
			 (list (caddr exp) ret-val))
			((list exp ret-val))))))



; depends on the fact that bindings are only added to on the front, so
; the stored bindings must be a tail

; can do much better after I get rid of all these
; (nil nil) pairs

;(defun get-real-pair (b)
;    (cond ((null b) nil)
;	  ((caar b) b)
;	  ((get-real-pair (cdr b)))))


;(defun was-a-good-one (bindings good-bls)
;    (g-loop (init real-pair (get-real-pair bindings)
;		end-bindings (member real-pair bindings))
;	  (before-starting (cond ((and (null real-pair)
;				  	 good-bls)
;				  (return t))))
;	  (while good-bls)
;	  (do (and (equal end-bindings 
;			  (member real-pair (car good-bls)))
;		   (return t)))
;	  (next good-bls (cdr good-bls))))


;(defun get-ilits-from-tracking (exp good-bls s-records)
;'    (g-loop (init ilit nil ret-val nil)
;	  (while depends)
;	  (do (cond ((and (eq exp (caar depends))
;			  (..)
;		          (was-a-good-one (cadar depends) good-bls))
;		     (setq ilit (subst-bindings exp (cadar depends)))
;		     (or (member ilit ret-val)
;			 (push ilit ret-val)))))
;	  (next depends (cdr depends))
;	  (result ret-val)))


;(defun old-bebl-tracking-results (s-records)
;    (g-loop (init ret-val nil bls nil exp nil iexps nil)
;	  (while depends)
;	  (do (setq exp (caar depends))
;	      (cond ((assoc exp ret-val))
;		    ((setq iexps
;			   (get-ilits-from-tracking exp good-bls
;			       depends))
;		     (push (list exp iexps) ret-val))))
;	  (next depends (cdr depends))
;	  (result ret-val)))

		




;(defun tracking-get-lits (exp)
;    (cond ((eq exp t) nil)
;	  ((null exp) nil)
;	  ((or (eq (car exp) 'exists)
;	       (eq (car exp) 'forall))
;	   (nconc (tracking-get-lits (get-gen-exp exp))
;		  (tracking-get-lits (get-exp exp))))
;	  ((eq (car exp) 'known)
;	   (tracking-get-lits (caddr exp)))
;	  ((atomic-formula-p exp)
;	   (and (is-trackable (car exp))
;		(list exp)))
;	  ((negated-p exp) 
;	   (cond ((eq (caadr exp) 'exists) nil)
;		 ((is-trackable (caadr exp))
;		  (list exp))))
;	  ((or (eq (car exp) 'and)
;	       (eq (car exp) 'or))
;	   (g-map (sub in (cdr exp))
;		 (splice (tracking-get-lits sub))))
;	  (t (error exp))))



;(defun get-matched-lits-from-ebl-track (exp bls node)
;    (g-map (lit in (tracking-get-lits exp))
;	  (save (list lit (get-inst-lits (find-all-vars lit) lit node nil bls)))))


;(defun consistent-bs (var val bls)
 ;   (g-map (b in bls)
;	  (when (equal val (cadr (assoc (car vars) b))))
;	  (save b)))
    

;(defun get-inst-lits (vars lit node bindings bls)
;    (cond ((null vars)
;	   (let ((inst-lit (subst-bindings lit bindings)))
;		(and (atomic-formula-match inst-lit (node-state node))
;		     (list inst-lit))))
;	  ((g-loop (init temp-bls bls new-vals nil val nil ret-val nil)
;		 (while temp-bls)
;		 (do (setq val (cadr (assoc (car vars) (car temp-bls))))
;		     (cond ((null val))
;			   ((member val new-vals))
;			   (t (push val new-vals)
;			      (setq ret-val 
;				    (nconc (get-inst-litsp (cdr vars) lit node
;					       (cons (list (car vars) val) bindings)
;					       (and (cdr vars)
;						    (consistent-bs (car vars) val
;							bls)))
;					   ret-val)))))
;		 (next temp-bls (cdr temp-bls))
;		 (result ret-val)))))

				
										   
				
			    
