#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *CLOSED-PREDS* *STATIC-PREDS* *FUNCTION-PREDS* 
		 *RULE-STACK* *CACHABLE-SIGS* *SUB-PROOFS* *EBS-CACHED-VALUE*
		*SCHEMA-TABLE* *EVALUABLE-SIGS* *NUM-RULE-UNIQUE-COUNT*
		*PROVED* *NUM-UNIQUE-COUNT* *NUM-COUNT*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))



; now returns ((bindings rbindings)(bindings rbindings)....)

(defun ev-descend-match (exp bindings h)
  (cond ((eq (car exp) 'and)
	 (ev-and-match (cdr exp) bindings h))
	((eq (car exp) 'or)
	 (ev-or-match (cdr exp) bindings h))
	((eq (car exp) 'forall)
	 (ev-forall-match bindings h
			  (get-gen-exp exp)(get-exp exp)))
	((or (eq (car exp) 'exists)	       
	     (eq (car exp) 'let))	       
	 (ev-and-match (list (get-gen-exp exp)(get-exp exp)) 
		       bindings h))
	((atomic-formula-p exp) 
	 (cond ((is-cached exp bindings h)
		(g-map (b1 in (get-cached-result exp bindings h))
		       (save (append b1 bindings))))
	       ((is-open exp)
		(and (> (length *RULE-STACK*) 35)
		     (error "looks infinite.."))
		(let ((rule (discriminate-rule exp bindings h)))
		  (and rule
		       (prog2 
			(push rule *RULE-STACK*)
			(ev-descend-match (expand-exp exp rule bindings)
					  bindings h)
			(pop *RULE-STACK*)))))
	       (t (let ((bls (apply (car exp) 
				    (cons h (subst-bindings 
					     (cdr exp) bindings)))))
		    (cond ((eq bls t) (list bindings))
			  ((null bls) nil)
			  ((g-map (b in bls)
				  (save (append b bindings)))))))))
	((and (eq (car exp) '~)
	      (atomic-formula-p (cadr exp))
	      (not (has-unbound-proof-vars (cadr exp) bindings)))
	 (and (not (ev-descend-match (cadr exp) bindings h))
	      (list bindings)))
	(t (error "EV-DESCEND-MATCH - bad expression:" exp))))
	  
	  
	  
(defun ev-forall-match (start-bindings h gen-exp exp)
  (g-loop (init bls (ev-descend-match gen-exp start-bindings h)
		bindings nil ret-val nil)
	  (while bls)
	  (next bindings (car bls)
		bls (cdr bls))
	  (do (or (setq ret-val (ev-descend-match exp bindings h))
		  (return nil)))
	  (result (list ret-val))))
	  

(defun ev-and-match (exps bindings h)
  (cond ((null exps) (list bindings))
	((g-loop (init binding-lists 
		       (ev-descend-match (car exps) bindings h)
		       ret-val nil sub-result nil)
		 (while binding-lists)
	         (do (setq sub-result 
			   (ev-and-match (cdr exps) (car binding-lists) h))
		     (setq ret-val (append sub-result ret-val)))
		 (next binding-lists (cdr binding-lists))
		 (result ret-val))))) ;  can use nconc (or g-map splice)


(defun ev-or-match (exps bindings h)
  (g-loop (init ret-val nil)
	  (while exps)
	  (do (setq ret-val (ev-descend-match (car exps) bindings h)))
	  (next exps (cdr exps))
	  (until ret-val)
	  (result ret-val)))


(defun ps-descend-match (exp bindings h)
    (cond ((eq (car exp) 'and)
	   (ps-and-match (cdr exp) bindings h))
	  ((eq (car exp) 'or)
	   (ps-or-match (cdr exp) bindings h))
	  ((eq (car exp) 'exists)	       
	   (ps-exists-match (get-vars-lst exp)
	       (get-gen-exp exp)(get-exp exp) bindings h))
	  ((eq (car exp) 'forall)
	   (ps-forall-match (get-vars-lst exp)(get-gen-exp exp)(get-exp exp)
	       bindings h))
	  ((eq (car exp) 'let)
	   (ps-let-match (get-vars-lst exp)(get-gen-exp exp)(get-exp exp)
	       bindings h))
	  ((atomic-formula-p exp) 
	   (ps-atomic-match exp bindings h))
	  ((eq '~ (car exp)) 	; hmm, in light of paper, is this right?
	   (cond ((and (atomic-formula-p (cadr exp))
		       (is-evaluable (cadr exp) bindings h)
		       (not (has-unbound-proof-vars (cadr exp) bindings)))
		  ; last line needed?
		  (not (ev-descend-match (cadr exp) bindings h)))     
		 ((list '~ (ps-descend-match (cadr exp) 
			       bindings h)))))
	  ((null exp) nil)
	  (t (error "PS-DESCEND-MATCH - bad expression:" exp))))

(defun is-bls (result)
    (and (listp (car result))
	 (listp (caar result))))

(defun ps-atomic-match (exp bindings h)
    (cond ((is-cached exp bindings h)
	   (let ((cached-result (get-cached-result exp bindings h)))
		(cond ((is-bls cached-result) t)
		      (cached-result))))
	  ((is-compiled exp)
	   (apply (car exp) (cons h (subst-bindings (cdr exp) bindings))))
	  ((is-evaluable exp bindings h)
	   (and (apply (car exp)
		       (cons h (subst-bindings (cdr exp) bindings)))
		t))
	  ((is-open exp) 
	   (let ((rule (discriminate-rule exp bindings h)))
		(cond (rule
			   (push rule *RULE-STACK*)
			   (and (> (length *RULE-STACK*) 35)
				(error "looks infinite.."))
			   (let ((subresult (ps-descend-match 
						(expand-exp exp rule bindings)
						bindings h)))
				(pop *RULE-STACK*)
				subresult)))))
	  (t (subst-bindings exp bindings))))

(defun ps-and-match (exps bindings h)
  (g-loop (init ret-val nil)
	  (while exps)
	  (do (push (ps-descend-match (car exps) bindings h) ret-val)
	      (cond ((eq t (car ret-val))
		     (pop ret-val))
		    ((eq nil (car ret-val))
		     (return))))
	  (next exps (cdr exps))
	  (result (cond ((null ret-val) t)
			((null (cdr ret-val)) (car ret-val))
			(t (cons 'and (nreverse ret-val)))))))
	  
	  
(defun ps-or-match (exps bindings h)
  (g-loop (init ret-val nil)
	  (while exps)
	  (do (push (ps-descend-match (car exps) bindings h) ret-val)
	      (cond ((eq nil (car ret-val))
		     (pop ret-val))
		    ((eq t (car ret-val))
		     (return t))))
	  (next exps (cdr exps))
	  (result (cond ((null ret-val) nil)
			((null (cdr ret-val)) (car ret-val))
			(t (ao-simplify (cons 'or (nreverse ret-val))))))))
	  
(defun ps-exists-match (gen-vars gen-exp exp bindings h)
    (cond ((is-compiled gen-exp)
	   (let ((constraints (apply (car gen-exp) 
				     (cons h 
					   (subst-bindings 
					       (cdr gen-exp) bindings)))))
		(list 'and constraints
		      (ps-descend-match exp
			  (append (constraints-to-bindings
				   constraints bindings)
				  bindings)
			  h))))
	  ((is-evaluable gen-exp bindings h) ; evaluable needs hval already...
	   (ao-simplify
	       (g-loop (init hvals (get-mult-vals gen-exp h) b nil ret-val nil)
		     (while hvals)
		     (do (if (typep (caar hvals) 'node) (error "debuggin-aid"))
		         (setf (get h (caar hvals)) (cadar hvals))
			 (setq b (car (ev-descend-match gen-exp bindings h)))
			 (push (ps-descend-match exp b h) ret-val))
		     (next hvals (cdr hvals))
		     (result (cons 'or ret-val)))))
	  ; can't have more than training example currently if not evaluable
	  (t (list 'and gen-exp
		   (ps-descend-match exp bindings h)))))
	  
; currently a rule can have max one exists or forall per
; generator-predicate,

; history property= name-of-discrim-fn is property
; value= ((gen-predicate (prop val)(prop val)) 
;	  (gen-predicate (prop val)(prop val)(prop val))))
; 
	  
;  returns list of (prop val)
(defun get-mult-vals (gen-exp h)
    (or (cdr (assoc (car gen-exp) (get h (car *RULE-STACK*))))
	(list '(fake-prop fake-val))))

(defun put-mult-vals (h rule-nm gen-pred prop vals)
    (setf (get h rule-nm) 
	  (cons (cons gen-pred
		      (g-map (v in vals)
			     (save (list prop v))))
		(get h rule-nm))))


	      
	  
; should really make ps-forall-match and ps-exists-match consistent re: mult
; vals.
	  
(defun ps-forall-match (gen-vars gen-exp exp bindings h)
    (cond ((is-evaluable gen-exp bindings h)
	   (ao-simplify
	       (cons 'and (g-map (b in (ev-descend-match gen-exp bindings h))
				(save (ps-descend-match exp b h))))))
	  ((list 'forall gen-vars
		 (ps-descend-match gen-exp bindings h)
		 ; hv is a attribute value pair
		 (cons 'or (g-map (hv in (get-mult-vals gen-exp h))
				 (save (progn (setf (get h (car hv)) (cadr hv))
					      (ps-descend-match exp bindings
						  h)))))))))
	  
	  
	  
(defun ps-let-match (gen-vars gen-exp exp bindings h)
     (cond ((is-evaluable gen-exp bindings h)
	   (let ((bls (ev-descend-match gen-exp bindings h)))
		(ps-descend-match exp (car bls) h)))
	  ((ao-simplify
	       (list 'and (ps-descend-match gen-exp bindings h)
		     (ps-descend-match exp bindings h))))))

;  should really let variable be in first OR second place

; constraints-to-bindings returns just the NEW BINDINGS

(defun eq-to-bindings (eq-exp bindings)
    (cond ((and (is-variable (cadr eq-exp))
		(not (is-variable (caddr eq-exp)))
		(not (assoc (cadr eq-exp) bindings))) ; already bound
	   (list (list (cadr eq-exp) (caddr eq-exp))))
	  (t bindings)))

; constraints-to-bindings returns just the NEW BINDINGS

(defun constraints-to-bindings (constraints bindings)
    (cond ((atom constraints) nil)
	  ((eq (car constraints) 'is-equal)
	   (eq-to-bindings constraints bindings))
	  ((eq (car constraints) 'and) (error "nyet implemented"))
	  (t nil)))



; converts to te...may just want to do standard transfer
 
(defun corresponding-instance (exp h)
  (cond ((eq (car exp) 'fails)  
	 (list 'fails (get h 'h-child)))
	((eq (car exp) 'interacts)  ;  right now sub-hist is node-nm
	 (cond ((and (eq 'supporting-failure (node-gi-label (get h 'h-child)))
		     (not (previously-proved ; in case side extended
			   (list 'interacts (get h 'h-child)))))
		(list 'fails (get h 'h-child)))
	       (t (list 'interacts (get h 'h-child)))))
	((eq (car exp) 'op-fails)
	 (list 'op-fails (getn h) (get h 'h-goal) (get h 'h-op)))
	((eq (car exp) 'goal-fails)
	 (list 'goal-fails (getn h) (get h 'h-goal)))
	((eq (car exp) 'op-interacts)
	 (list 'op-interacts (getn h) (get h 'h-goal) (get h 'h-op)))
	((and (eq (car exp) 'op-succeeds)
	      (get h 'get-result-from-same-node))
	 (list 'op-succeeds (getn h)
	       (get h 'h-goal)
	       (get h 'h-applic-op)
	       (get h 'h-bindings)))
	((and (eq (car exp) 'op-succeeds)
	      (get h 'top-level-succ-with-mult-goals))
	 (list 'op-succeeds (get h 'h-child)
	       (get h 'new-h-goal)
	       (get h 'new-h-applic-op)
	       (get h 'new-h-bindings)))
	((eq (car exp) 'op-succeeds)
	 (list 'op-succeeds (get h 'h-child)
	       (get h 'h-goal)
	       (get h 'h-applic-op)
	       (get h 'h-bindings)))))
		
(defun cached-h (cached-result)
  (cadr cached-result))
	  
(defun cached-te (cached-result)
  (caddr cached-result))
	  
(defun cached-tc-sig (cached-result)
  (cadddr cached-result))

(defun cached-description (cached-result)
  (caddr (cddr cached-result)))

	  
; only returns a single value (ie bindings list)
; SUBPROOFS= (target-c training-ex-hist training-ex tc-sig description)
;  e.g. (op-fails node1-op-history (op-fails push N10)(op-fails <f-op> <f-n>) (and ....))
; when evaluable, assume the description must be converted
; to bindings (must filter already bound variables)

	  
(defun is-cached (exp bindings h)
  (and *RULE-STACK*
       (assoc (car exp) *CACHABLE-SIGS*)
       (g-loop (init alist *SUB-PROOFS* entry nil ret-val nil found nil
		     te (get-proved-te (corresponding-instance exp h)))
	       (while (setq entry (pop alist)))
	       (do (and (eq (car entry) (car te))
			(equal te (cached-te entry))
			(setq found t)))
	       (until found)
	       (result (cond (found 
			      (setq *EBS-CACHED-VALUE* 
				    (list (list exp h) entry))
			      t)
			     (t nil))))))

(defun te-to-desc (te)
  (g-loop (init tmp-subproofs *SUB-PROOFS* entry nil desc nil
		new-te (cadr (assoc te *PROVED* :test #'equal)))
	  (while (setq entry (pop tmp-subproofs)))
	  (do (cond ((equal new-te (cached-te entry))
		     (setq desc (cached-description entry))
                     (if desc (return desc)))))))
				

(defun get-cached-result (exp bindings h)
    (cond ((and (eq exp (caar *EBS-CACHED-VALUE*))
		(eq h (cadar *EBS-CACHED-VALUE*)))
	   (make-cached-result exp bindings h (cadr *EBS-CACHED-VALUE*)))
	  (t (format t "~%no cached value found!!!!~%"))))

; note: should really uniqify subresults each time returned,
; in case a subresult is used more than once, but
; theres a problem. the evaluable clause returns
; a description which is processed by cmpl. routines,
; and realify expects the clauses to be the same as
; was matched below...

; if its evaluable, its got to be first variable

(defun make-cached-result (exp bindings h entry)
  (cond ((get (car exp) 'evaluable) ;  make bls
	 (list (list (list (cadr exp) 
			   (cons 'and 
				 (cons (cached-description entry)
				       (g-map (oldv in (cdr (cached-tc-sig entry)))
					      (newv in (subst-bindings (cdr exp) bindings))
					      (save (list 'is-equal oldv
							  newv)))))))))
	(t (subpair (cdr (cached-tc-sig entry))
		    (subst-bindings (cdr exp) bindings)
		    (cached-description entry)))))
	  
	  
 ;  schema = (signature form)

(defun reset-unique-vars ()
    (setq *NUM-UNIQUE-COUNT* 0))
	  
(defun get-next-unique-num ()
    (setq *NUM-UNIQUE-COUNT* (+ 1 *NUM-UNIQUE-COUNT*))
    *NUM-UNIQUE-COUNT*)   
	  
(defun make-n-unique-vars (n)
    (cond ((eq n 0) nil)
	  (t (cons (intern
		       (concatenate 'string
				    "<@!" (prin1-to-string
					   (get-next-unique-num))
				    ">")
		       'USER)
		   (make-n-unique-vars (- n 1))))))
	  
(defun is-unique-var (atm)
    (and (symbolp atm)
	 (eq #\! (char (symbol-name atm) 2))))
	  
	  
(defun reset-rule-unique-vars ()
    (setq *NUM-RULE-UNIQUE-COUNT* 0))
	  
(defun get-next-rule-unique-num ()
    (setq *NUM-RULE-UNIQUE-COUNT* (+ 1 *NUM-RULE-UNIQUE-COUNT*))
    *NUM-RULE-UNIQUE-COUNT*)

(defun make-n-rule-unique-vars (n)
  (cond ((eq n 0) nil)
	(t (cons (intern (concatenate 'string "<@!R"
				      (prin1-to-string
				       (get-next-rule-unique-num))
				      ">")
			 'USER)
		 (make-n-rule-unique-vars (- n 1))))))



(defun reset-proof-vars ()
    (setq *NUM-COUNT* 0))
	  
(defun make-n-proof-vars (n)
    (cond ((eq n 0) nil)
	  (t (cons (intern (concatenate 'string
		       "<@" (prin1-to-string (get-next-new-num)) ">")
			   'USER)
		   (make-n-proof-vars (- n 1))))))
	  
(defun get-next-new-num ()
    (setq *NUM-COUNT* (+ 1 *NUM-COUNT*))
    *NUM-COUNT*)   
	  
(defun is-proof-var (atm)
    (and (symbolp atm)
	 (not (eq atm t))
         (let ((nm (symbol-name atm)))
              (and (> (length nm) 1)
	           (eq #\@ (char (symbol-name atm) 1)))))) ;  tests 2nd ele

	  
; uses make-n-new-vars, which gives exp domain vars, not proof vars
(defun replace-vars (exp)
    (let ((old-vars (find-all-vars exp)))
	 (subpair old-vars (make-n-new-vars (length old-vars)) exp)))
	  
	  
 ;  returns (rule bindings) or nil
(defun discriminate-rule (exp bindings h)
    (g-loop (init rules (cdr (assoc (car exp) *SCHEMA-TABLE*))
		rule nil ret-val nil)
	  (while (setq rule (pop rules)))
	  (do (cond ((not (fboundp rule))(return rule))
		    ((apply rule (cons h (subst-bindings (cdr exp) bindings)))
		     (setq ret-val rule))))
	  (until ret-val)
	  (result ret-val)))
	  
	  
;  -- you know, I can do this at load-schema time, and only
;     for recursive ones worry about it...
;     also, we can subst-bidings in exp before calling expand-exp,
;     and speed things up, since its also done in discriminate rule.

;  bindings should not already be substituted in
;  I can speed this up
(defun expand-exp (exp rule bindings)
    (prog (new-vars fresh-sig-form)
	  (setq new-vars (make-n-proof-vars (get rule 'num-vars)))
	  (setq exp (subst-bindings exp bindings))
	  (setf (get rule 'new-vars) new-vars)
	  (setq fresh-sig-form (subpair (get rule 'vars)
				   new-vars
				   (get rule 'sig-form)))
	  (return (subpair (cdr (car fresh-sig-form))
		      (cdr exp)
		      (cadr fresh-sig-form)))))

;  less efficient than above, for dynamic expansion

(defun fresh-vars (exp)
  (let ((vars (find-all-vars exp)))
    (subpair vars (make-n-proof-vars (length vars)) exp)))
	  
	  
(defun is-open (exp)
   (assoc (car exp) *SCHEMA-TABLE*))
	  
(defun is-compiled (exp)
  (member (car exp) *COMPILED-SCHEMAS*))
	  
(defun is-evaluable (exp bindings h)
  (cond ((null *RULE-STACK*) nil)
	((assoc (car exp) *CACHABLE-SIGS*) 
	 (and (get (car exp) 'evaluable)
	      (prog (p-vs)
		    (setq p-vs (get-mult-vals exp h))
		    (if (typep (caar p-vs) 'node) (error "badtype")) ;DEBUGGING
		    (setf (get h (caar p-vs)) (cadar p-vs))
		    (return (is-cached exp bindings h)))))
	((evaluable-check (assoc (car exp) *EVALUABLE-SIGS*) exp bindings))))
	  

(defun evaluable-check (eval-sig exp bindings)
  (cond ((null eval-sig) nil)
	((g-loop (next eval-sig (cdr eval-sig)
		       exp (cdr exp))
		 (while eval-sig)
		 (do (cond ((or (null (car eval-sig))
				(not (is-proof-var (car exp)))
				(and (assoc (car exp) bindings) ; has binding
				     (not (is-proof-var 
					   (cadr (assoc (car exp) 
							bindings)))))))
			   (t (format t "~%FUNCTION call not evaluable: ~a~%" 
				      exp)
			      (error "not evaluable")
			      (return)) ; debugging aid
			   ((return))))
		 (result t)))))

(defun full-assoc (var bindings)
  (let ((pair (assoc var bindings)))
    (cond ((and (is-variable (cadr pair))
		(assoc (cadr pair) bindings))
	   (full-assoc (cadr pair) bindings))
	  (pair))))

(defun has-unbound-proof-vars (lit bindings)
  (g-loop (init args (cond ((negated-p lit)(cdadr lit))
			   ((cdr lit))))
	  (while args)
	  (do (or (not (is-proof-var (car args)))
		  (assoc (car args) bindings)
		  (return t)))
	  (next args (cdr args))))

