#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

;;;  Host: bacon.arc.nasa.gov
;;;  File: /home/copernicus/prodigy/version2/system/ebl/ebl-data-types.lisp
;;;  Contains: Access functions for the EBL data types.
;;;  Author: Andy Philips (abp@bacon.arc.nasa.gov)
;;;  Created: Mon Jun 12 16:22:44 1989
;;;  Updated: Thu Jun 15 14:24:25 1989

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))

;;;  These functions map an access function call onto a property list.
;;;  They are written to be used with all nodes.

(defmacro node-EBL-reject-bindings-hst (n)
  `(get (node-name ,n) 'EBL-reject-bindings-hst))


(defmacro node-added-after-restart (n)
  `(get (node-name ,n) 'added-after-restart))


(defmacro node-added-nodes-for-gi (n)
  `(get (node-name ,n) 'added-nodes-for-gi))


(defmacro node-gi-label (n)
  `(get (node-name ,n) 'gi-label))


(defmacro node-gr-cond (n)
  `(get (node-name ,n) 'gr-cond))


(defmacro node-match-failure-history (n)
  `(get (node-name ,n) 'match-failure-history))


(defmacro node-success-child (n)
  `(get (node-name ,n) 'success-child))


(defmacro node-tree-gi-labeled (n)
  `(get (node-name ,n) 'tree-gi-labeled))


(defmacro node-bindings-level-failures (n)
  `(get (node-name ,n) 'bindings-level-failures))


(defmacro node-bindings-level-gis (n)
  `(get (node-name ,n) 'bindings-level-gis))


(defmacro node-bro-deletion-node (n)
  `(get (node-name ,n) 'bro-deletion-node))


(defmacro node-cum-time (n)
  `(get (node-name ,n) 'node-cum-time))


(defmacro node-first-succ-node (n)
  `(get (node-name ,n) 'first-succ-node))


(defmacro node-goal-level-failures (n)
  `(get (node-name ,n) 'goal-level-failures))


(defmacro node-goal-level-gis (n)
  `(get (node-name ,n) 'goal-level-gis))


(defmacro node-h-child (n)
  `(get (node-name ,n) 'h-child))


(defmacro node-interaction-explained-at-higher-level (n)
  `(get (node-name ,n) 'interaction-explained-at-higher-level))


(defmacro node-learning-reset-node (n)
  `(get (node-name ,n) 'learning-reset-node))


(defmacro node-node-level-failure (n)
  `(get (node-name ,n) 'node-level-failure))


(defmacro node-node-level-gi (n)
  `(get (node-name ,n) 'node-level-gi))


(defmacro node-op-level-failure (n)
  `(get (node-name ,n) 'op-level-failure))


(defmacro node-op-level-failures (n)
  `(get (node-name ,n) 'op-level-failures))


(defmacro node-op-level-gis (n)
  `(get (node-name ,n) 'op-level-gis))


(defmacro node-prerequisite-violation (n)
  `(get (node-name ,n) 'prerequisite-violation))


(defmacro node-protection-violation (n)
  `(get (node-name ,n) 'protection-violation))


(defmacro node-recent-ebl-hist (n)
  `(get (node-name ,n) 'recent-ebl-hist))


(defmacro node-sig-for-ebs (n)
  `(get (node-name ,n) 'sig-for-ebs))


(defmacro node-u-op (n)
  `(get (node-name ,n) 'u-op))


(defmacro node-optimize-mode-failure (n)
  `(get (node-name ,n) 'node-optimize-mode-failure))


;;; These are access functions that are strictly used for holding constants.
;;; The constants are properties of Node 1 -- N1


(defmacro node-did-interactions (n)
  `(get (node-name ,n) 'did-interactions))


(defmacro node-dont-learn (n)
  `(get (node-name ,n) 'dont-learn))


(defmacro node-dont-learn-fails (n)
  `(get (node-name ,n) 'dont-learn-fails))


(defmacro node-estart-time (n)
  `(get (node-name ,n) 'estart-time))


(defmacro node-estop-time (n)
  `(get (node-name ,n) 'estop-time))


(defmacro node-lstart-time (n)
  `(get (node-name ,n) 'lstart-time))


(defmacro node-lstop-time (n)
  `(get (node-name ,n) 'lstop-time))


(defmacro node-straight-solution (n)
  `(get (node-name ,n) 'straight-solution))


(defmacro node-top-gi-found (n)
  `(get (node-name ,n) 'top-gi-found))
