#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *SINGLETON-PREDS* *AT-LEAST-ONE-GENERATORS*
		*SINGLE-GENERATORS* *EVALUABLE-DOMAIN-FNS* 
		*SIMPLIFICATION-RULES* *PROOF-RULES*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


(defun process-ebl-axioms ()
   (format t "~% Checking EBL axioms syntax...")
   (check-ebl-axiom-nms-are-bound)
   (check-ebl-axioms-syntax)
   (check-ebl-simp-rules)
   (process-simp-rules)
   (process-single-generators))

(defun process-simp-rules ()
  (setq *PROOF-RULES* (mapcar #'car *SIMPLIFICATION-RULES*))
  (dolist (rule *SIMPLIFICATION-RULES*)
	  (dolist (att-val (cdr rule))
		  (setf (get (car rule) (car att-val)) (cadr att-val)))))


;;; This is used to convert the *SINGLETON-GENERATORS* in ebl-axioms
;;; to the old form of ((on 1)(on 2)(holding 1)....)

(defun process-single-generators ()
  (setq *SINGLETON-PREDS* '((current-goal 2)))
  (dolist (singleton-gen *SINGLE-GENERATORS*)
	  (g-loop (init pred (pop singleton-gen) arg-num 1)
		  (while singleton-gen)
		  (do (cond ((not (car singleton-gen))
			     (push (list pred arg-num) *SINGLETON-PREDS*)
			     (return nil))))
		  (next singleton-gen (cdr singleton-gen)
			arg-num (1+ arg-num))
		  (result (error "No t found in *SINGLE-GENERATORS* for ~A"
				 pred)))))

	       
(defun check-ebl-axiom-nms-are-bound ()
  (dolist (nm '(*AT-LEAST-ONE-GENERATORS*
		*SINGLE-GENERATORS*
		*EVALUABLE-DOMAIN-FNS*
		*SIMPLIFICATION-RULES*))
	  (cond ((not (boundp nm))
		 (format t "~%Warning: ~A is not setf in ebl-axioms file" nm)
		 (format t "~% Did you create an ebl-axioms file?  See the")
		 (format t "~% manual-for-ebl in ebl directory for details.")
		 (format t "~% Setting ~A to NIL, assuming you were lazy" nm)
		 (set nm nil)))))


(defun check-ebl-axioms-syntax ()
  (dolist (nm '(*AT-LEAST-ONE-GENERATORS* *SINGLE-GENERATORS*
					  *EVALUABLE-DOMAIN-FNS*))
	  (dolist (entry (eval nm))
                  (cond ((not (member (car entry) *PREDICATES*))
			 (error "In ~A, syntax error, unknown predicate in: ~A" 
				nm entry))
			((not  (every #'(lambda (marker) (or (null marker)
							     (eq marker t)))
				      (cdr entry)))
			 (error "In ~A, syntax error, all args must be t's and nil's: ~A" nm entry))))))

		      

(defun check-ebl-simp-rules ()
  (dolist (rule *SIMPLIFICATION-RULES*)
          (check-ebl-simp-rule-syntax rule))
  (rename-vars-in-simp-rules))

;;; lists all vars (with dups) from Simplication rules, and all var
;;; from operators and inference rules, and then makes sure those in
;;; the simplification rules are really unique.
  
(defun rename-vars-in-simp-rules ()
  (let ((var-lst (append  (do ((x *SIMPLIFICATION-RULES* (cdr x))
			       (y nil (append y (find-all-vars (car x)))))
			      ((null x) y))
			  (find-all-vars (append *OPERATORS*
						 *INFERENCE-RULES*)))))
    (setq *SIMPLIFICATION-RULES* 
	  (mapcar #'(lambda (x) (help-uniquefy-exp
				 (car x) x var-lst)) *SIMPLIFICATION-RULES*))))



(defun check-ebl-simp-rule-syntax (rule)
  (let ((rule-nm (car rule))
	(p-exp (assoc 'p-exp (cdr rule)))
	(q-exp (assoc 'q-exp (cdr rule)))
	(known-cond (assoc 'known-cond (cdr rule)))
	(prove-cond (assoc 'prove-cond (cdr rule))))
    (if (not p-exp)
	(error "EBL: Syntax error, Missing p-exp from rule: ~A" rule-nm))
    (if (not q-exp)
	(error "EBL: Syntax error, Missing q-exp from rule: ~A" rule-nm))
    (if (not known-cond)
	(error "EBL: Syntax error, Missing known-cond from rule: ~A" rule-nm))
    (if (not prove-cond)
	(error "EBL: Syntax error, Missing prove-cond from rule: ~A" rule-nm))
    (dolist (entry (list p-exp q-exp known-cond prove-cond))
	    (cond ((check-exp-in-simp-rule (cadr entry))
		   (let ((error (check-exp-in-simp-rule (cadr entry))))
		     (format t "~%~%Error in ~A of simplification rule: ~A"
			     (car entry) rule-nm)
		     (format t "~% Syntax Error type: ~A" (car error))
		     (format t "~% ~A" (cadr error))))))))     
   
    
(defun check-exp-in-simp-rule (exp)
  (cond ((null exp) nil)
        ((eq exp t) nil)
        ((eq (car exp) 'forall)
	 (cond ((not (or (equal 4 (length exp)) (equal 3 (length exp))))
		(list "Expression is wrong length" exp))
	       ((check-vars-lst exp))
	       ((check-gen-exp exp))
	       (t (check-exp-in-simp-rule (get-exp exp)))))
	((eq (car exp) 'exists)	       
	 (cond ((not (or (equal 4 (length exp)) (equal 3 (length exp))))
		(list "Expression is wrong length" exp))
	       ((check-vars-lst exp))
	       ((check-gen-exp exp))
	       (t (check-exp-in-simp-rule (get-exp exp)))))
	((eq (car exp) '~)
	 (cond ((equal (caadr exp) 'exists)
		(check-exp-in-simp-rule (cadr exp)))
	       (t (check-atomic-formula (cadr exp)))))
	((eq (car exp) 'and)
	 (cond ((< (length exp) 3)
		(list "Not enough conjuncts in expression" exp))
	       (t (car (mapcan #'(lambda (x) 
				   (let ((val (check-exp-in-simp-rule x)))
				     (cond (val (list val))
					   (t nil))))
			       (cdr exp))))))
	((eq (car exp) 'or)
	 (cond ((< (length exp) 3)
		(list "Not enough disjuncts in expression" exp))
	       (t (car (mapcan #'(lambda (x) 
				   (let ((val (check-exp-in-simp-rule x)))
				     (cond (val (list val))
					   (t nil))))
			       (cdr exp))))))
	((null exp) nil)
	(t  (check-atomic-formula-for-simp-rule exp)))) ; key point


(defun check-atomic-formula-for-simp-rule (exp)
  (cond ((listp (car exp))
	 (list "Not a correct atomic formula: " exp))
	((not (boundp '*PREDICATES*)) nil) ;  default exit
        ((member (car exp) *META-FUNCTIONS*) nil) 
        ((assoc (car exp) *TP-FNS*)
	 (if (not (equal (cadr (assoc (car exp) *TP-FNS*)) (length exp)))
	     (list "Wrong number of arguments for function" exp)))
	((member (car exp) *PREDICATES*) 
	 ;;
	 ;; arity check
	 ;;
	 (let ((expected-arity (cadr (assoc (car exp) *PREDICATE-ARITIES*)))
	       (actual-arity (length exp)))
	   (cond ((< actual-arity expected-arity)
		  (list "Too few terms in predicate" exp))
		 ((> actual-arity expected-arity)
		  (list "Too many terms in predicate" exp)))))
	(t (list "Unknown predicate in atomic formula: " exp))))
