;;;
;;;
;;;
;;; These axioms are used to augment the given goals.  If any of these goals are
;;; find in the goal list, then the corresponding goals are added since they 
;;; also must hold in the final state.  
;;;
(setq *AXIOMS* 
      '(
	((next-to <box.1-1> <box.2-1>) . ((inroom <box.1-1> <room.1-1>)
					  (inroom <box.2-1> <room.1-1>)))
	((next-to robot <box.1-2>) . ((in-room <box.1-2> <room.1-2>)
				      (in-room robot <room.1-2>)))
	((next-to robot <door.1-3>) . ((connects <door.1-3> <room.x-3> <room.y-3>)
				       (in-room robot <room.x-3>)))
	((~ (statis <door.1-4> closed)) . ((statis <door.1-4> open)))
	((~ (statis <door.1-5> open)) . ((statis <door.1-5> closed)))
	))

(setq *VARIABLE-EXPANSION* nil)
(setq *VARIABLE-TYPING* '(
			  (isa 'robot 'type)
			  (isa 'box 'object)
			  (isa 'door 'object)
			  (isa 'object 'type)
			  (isa 'room 'type)
			  (isa 'loc 'type)
			  (isa 'status 'type)
			  (isa-instance 'open 'status)
			  (isa-instance 'closed 'status)
			  (isa-instance 'robot 'robot)
			  (isa-instance 'box.1 'box)
			  (isa-instance 'box.2 'box)
			  (isa-instance 'box.3 'box)
			  (isa-instance 'box.a 'box)
			  (isa-instance 'box.b 'box)
			  (isa-instance 'box.c 'box)
			  (isa-instance 'box.d 'box)
			  (isa-instance 'box.e 'box)
			  (isa-instance 'box.f 'box)
			  (isa-instance 'room.uni 'room)
			  (isa-instance 'room.mys 'room)
			  (isa-instance 'room.ram 'room)
			  (isa-instance 'room.hal 'room)
			  (isa-instance 'room.pdp 'room)
			  (isa-instance 'room.clk 'room)
			  (isa-instance 'room.ril 'room)
			  (isa-instance 'door.unimys 'door)
			  (isa-instance 'door.mysram 'door)
			  (isa-instance 'door.ramhal 'door)
			  (isa-instance 'door.myspdp 'door)
			  (isa-instance 'door.pdpclk 'door)
			  (isa-instance 'door.mysclk 'door)
			  (isa-instance 'door.ramclk 'door) 
			  (isa-instance 'door.clkril 'door)
			  ))

(setq *PRIMARY* '(
      ((next-to robot <box>) . (GOTO-BOX))
      ((next-to robot <door>) . (GOTO-DOOR))
      ((at robot <loc.x> <loc.y>) . (GOTO-LOC))
      ((next-to <box.1> <box.2>) . (PUSH-BOX))
      ((next-to <box> <door>) . (PUSH-TO-DOOR))
      ((at box <loc.x> <loc.y>) . (PUSH-TO-LOC))
      ((in-room robot <room>) . (GO-THRU-DOOR))
      ((in-room <box> <room>) . (PUSH-THRU-DOOR))
      ((statis <door> open) . (OPEN-DOOR))
      ((statis <door> closed) . (CLOSE-DOOR))
      ))

(setq *SINGLE-HIERARCHY* nil)