;;EBL simplifier functions which were used.

#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



; gets single atomic formulas with pred-type
; used when you know there will be only one 

(defun get-form-from-exp (pred-nm exp)
  (let ((forms (get-forms-from-exp pred-nm exp)))
    (cond ((eq (length forms) 1) (car forms))
	  (t (error "GET-FORM-FROM-EXP:")))))



; gets all atomic formulas with pred-type
(defun get-forms-from-exp (pred-nm exp)
  (cond ((eq t exp) nil)
	((null exp) nil)
	((atomic-formula-p exp)
	 (cond ((eq pred-nm (car exp)) (list exp))
	       ((member (car exp) '(known achievable provable))
		(get-forms-from-exp pred-nm (caddr exp)))
	       (t nil)))
	((member (car exp) '(forall exists))
	 (nconc (get-forms-from-exp pred-nm (get-gen-exp exp))
		(get-forms-from-exp pred-nm (get-exp exp))))
	((negated-p exp)
	 (get-forms-from-exp pred-nm (cadr exp)))
	((member (car exp) '(and or))
	 (g-map (sub in (cdr exp))
		(splice (get-forms-from-exp pred-nm sub))))))

(defun TF-trimable (exp)
    (and (not (eql t exp))
	 (or (member t exp)(member nil exp))))

(defun TF-trim (exp)
    (cond ((eql (car exp) 'and)
	   (cond ((member nil exp) nil)
		 ((member t exp)
		  (g-map (e in exp)
			(when (not (eql t e)))
			(save e)))
		 (t exp)))
	  ((eql (car exp) 'or)	
	   (cond ((member t exp) t)
		 ((member nil exp)	
		  (g-map (e in exp)
			(when e)
			(save e)))
		 (t exp)))))

