;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;-------------------------------------------------------------------

;;This file contains modifications to Prodigy to fix errors in Prodigy.

;;  Prodigy fixes.
;;  Made for Prodigy Version 2.11
;;  By Rob Spiger   
;;  E-mail Address: spiger@wolf.cs.washington.edu
;;
;;
;;  Summary:  Prodigy errors when applying the negation of existential
;;             quantification.  Error appears to be sloppy coding in
;;             the function negated-exists-match in the Prodigy system
;;             file matching.lisp.  An explanation of the problem 
;;             (including examples) and also a fix follows.
;;
;;
;;
;; PROBLEM #1
;;
;; What the problem was:
;;   Somebody got sloppy and though they could negate literals just
;;    by sticking an extra ~ around the literal.  The problem was
;;    that if the literal was already negated, the result was a 
;;    double negation.
;;
;; (This error was in the function negated-exists-match) 
;; 
;;  For example:
;;  
;;  (~ (Holding <x>)) became (~ (~ (Holding <x>)))
;;
;; Later on down the line, Prodigy found things like
;;    (~ (~ (Holding <x>))) to be unachievable.
;;
;; As an example of this problem occuring in a real problem take
;; this example for the FROZENBLOCKSWORLD
;;
;;
;;(load-goal '(~ (EXISTS (<x>) (object <x>) (~ (holding <x>)))))
;;
;;(load-start-state '((object a)
;;					(on-table a)
;;					(clear a)))
;;
;; This problem results in FAILURE.
;;
;; But logically it is exactly equivalent to this problem:
;;
;;(load-goal '(FORALL (<x>) (object <x>) (holding <x>)))
;;
;;(load-start-state '((object a)
;;					(on-table a)
;;					(clear a)))
;;
;;  Which results in SUCCESS.
;;
;;
;;
;;------------------------------------------------------------------
;;
;; PROBLEM #2
;;
;; The function negate-exists-match still didn't handle things like:
;;
;;(load-goal '(~ (EXISTS (<x>) (object <x>) 
;;                (~ (EXISTS (<x>) (object <x>) (holding <x>))))))
;;
;;
;;(load-start-state '((object a)
;;					(on-table a)
;;					(clear a)))
;;
;;  This problem resulted in FAILURE.
;;
;; Whereas the problem's logical equivalent resulted in SUCCESS.
;;
;; 
;;(load-goal '
;;(FORALL (<x>) (Object <x>) (EXISTS (<x>) (object <x>) (holding <x>))))
;;
;;
;;(load-start-state '((object a)
;;					(on-table a)
;;					(clear a)))
;;
;;
;;  
;;-------------------------------------------------------------------
;; Basically the function negate-exists-match was very poorly written
;;   whereas the functions handling FORALLs seem to be just fine.
;;
;; So, the solution is to just convert the ~EXIST statements
;;  into their logical equivalent FORALL statements.  
;;
;; This change can be accomplished by the following fix:

;; 
;;  FUNCTION: Rob-negate-sentence
;;
;;  Negates any legal Prodigy sentence.
;;  Uses demorgan's law for OR and AND.
;;  Uses simple inversion for NOT
;;  Uses (~ (FORALL p G F)) = (EXISTS p G ~F)
;;  Uses (~ (EXISTS p G F)) = (FORALL p G ~F)
;;  Uses (~ (EXISTS G))     = (FORALL p G ~G) **Tricky here, see note.
;;        
;;  Note:  Should result in requiring Prodigy to subgoal on ~G.
;;         
;;        
;;  Will return 'error-here when expression is illegal.
;;  (This thing works great - good for debuggin your domains too!)
;;
(defun rob-negate-sentence (exp)
 (if (atom exp)
  (cond
   ((equal exp 'OR) 'AND)
   ((equal exp 'AND) 'OR)
   (t (print 'bad-sentence-error)))
  (let ((keyword (first exp)))
   (cond 
    ((rob-atomic-formula? exp) 
     `(~ ,exp))
    ((equal keyword 'AND)
     (mapcar #'rob-negate-sentence exp))
    ((equal keyword 'OR)
     (mapcar #'rob-negate-sentence exp))
    ((equal keyword 'NOT)
     (second exp))
    ((equal keyword '~)
     (second exp))
    ((equal keyword 'EXISTS)
     (if (equal (length exp) 4)
     `(FORALL ,(second exp) ,(third exp) ,(rob-negate-sentence (fourth
														   exp)))
     `(FORALL ,(second exp) ,(third exp) ,(rob-negate-sentence
                                             (third exp)))))
    ((equal keyword 'FORALL)
     `(EXISTS ,(second exp) ,(third exp) ,(rob-negate-sentence (fourth
														   exp))))
	(t (print 'unknown-sentence-for-rob-negate-sentence))))))


   
;; FUNCTION: rob-atomic-formula? 
;;
;; Function returns T if exp is an atomic-formula.
;;          Else it returns nil.
  
(defun rob-atomic-formula? (exp)
 (unless (null exp)
  (if (find-if #'(lambda (x) (not (atom x))) exp)
   nil
   t)))

;; FUNCTION CHANGED FROM WHAT IS WAS IN PRODIGY file MATCHING.LISP
;;
;; WAS:
;;
;;(defun negation-match (exp bindings)
;;    (cond ((eq exp t) nil)
;;	  ((eq (car exp) 'exists)
;;	   (negated-exists-match exp bindings))
;;	  ((member (car exp) *PREDICATES*)
;;	   (negated-pred-match exp bindings))
;;	  (t (error "NEGATION-MATCH: bad expression ~A" exp))))
;;
;;
;;

(defun negation-match (exp bindings mode)
;;                The extra parm mode was passed.
    (cond ((eq exp t) nil)
	  ((eq (car exp) 'exists)
       (descend-match (rob-negate-sentence exp) bindings mode))
;;    The line above has been modified.
	  ((member (car exp) *PREDICATES*)
	   (negated-pred-match exp bindings))
	  (t (error "NEGATION-MATCH: bad expression ~A" exp))))

;; FUNCTION CHANGED FROM WHAT IS WAS IN PRODIGY file MATCHING.LISP
;;
;; WAS:
;;(defun descend-match (exp bindings mode)
;;;    (and *EBL-FLAG* (setq *MATCH-COUNT* (1+ *MATCH-COUNT*)))
;;    (cond ((eq exp t) (list bindings))
;;	  ((eq (car exp) 'and)
;;	   (and-match (cdr exp) bindings mode))
;;	  ((eq (car exp) 'exists)	       
;;	   (exists-match bindings (get-gen-exp exp) (get-exp exp) mode))
;;	  ((eq (car exp) 'forall)
;;	   (forall-match bindings (get-gen-exp exp) (get-exp exp)))
;;	  ((eq (car exp) '~)
;;	   (cond ((negation-match (cadr exp) bindings))
;;		 (t (record-failure exp bindings))))
;;	  ((eq (car exp) 'or)
;;	   (or-match (cdr exp) bindings mode))
;;	  ((null exp) (list bindings))
;;	  ; must be an atomic formula
;;	  ((let ((vals (gen-values exp bindings)))
;;		(cond ((null vals)
;;		       (record-failure exp bindings))
;;		      ((eq vals 'no-match-attempted)
;;		       nil)
;;		      ((eq vals t)
;;		       (list bindings))
;;		      ((mapcar #'(lambda (b) (append b bindings))
;;			       vals))))))) ; should replace with nconc 
;;
;;BECAME:

(defun descend-match (exp bindings mode)
;    (and *EBL-FLAG* (setq *MATCH-COUNT* (1+ *MATCH-COUNT*)))
    (cond ((eq exp t) (list bindings))
	  ((eq (car exp) 'and)
	   (and-match (cdr exp) bindings mode))
	  ((eq (car exp) 'exists)	       
	   (exists-match bindings (get-gen-exp exp) (get-exp exp) mode))
	  ((eq (car exp) 'forall)
	   (forall-match bindings (get-gen-exp exp) (get-exp exp)))
	  ((eq (car exp) '~)
	   (cond ((negation-match (cadr exp) bindings mode)) 
                    ;;the only mod is on the line above the
                    ;; mode parameter was passed to negation-match
		 (t (record-failure exp bindings))))
	  ((eq (car exp) 'or)
	   (or-match (cdr exp) bindings mode))
	  ((null exp) (list bindings))
	  ; must be an atomic formula
	  ((let ((vals (gen-values exp bindings)))
		(cond ((null vals)
		       (record-failure exp bindings))
		      ((eq vals 'no-match-attempted)
		       nil)
		      ((eq vals t)
		       (list bindings))
		      ((mapcar #'(lambda (b) (append b bindings))
			       vals))))))) ; should replace with nconc 


;;ANOTHER PRODIGY FIX BY ROB SPIGER
;;Sponsoring Professor Oren Etzioni

;; SEND MAIL OR QUESTIONS TO SPIGER@WOLF.CS.WASHINGTON.EDU

;;THIS FUNCTION COMES FROM THE PRODIGY FILE 
;;      /prodigy/system/planner/load-domain.lisp
;;
;;THE FOLLOWING IS A FIX FOR THE FUNCTION:


(defun check-atomic-formula (exp)
  (cond ((listp (car exp))
	 (list "Not a correct atomic formula: " exp))
	((not (boundp '*PREDICATES*)) nil) ;  default exit
	((member (car exp) *PREDICATES*) 
	 ;;
	 ;; arity check
	 ;;
	 (let ((expected-arity (cadr (assoc (car exp) *PREDICATE-ARITIES*)))
	       (actual-arity (length exp)))
       (unless (null expected-arity) ;;arity not known, so 
                                     ;;can't check it.
;;THE ONLY MODIFICATION MADE WAS TO ADD THE UNLESS STATEMENT ABOVE.
;;THE ERROR IN PRODIGY WAS THAT IF NO ARITY EXISTED FOR THE PREDICATE,
;; THEN NIL WOULD BE SENT TO THE FUNCTION "LESS THAN" IN THE LINE
;; BELOW.  THIS CAUSED PRODIGY TO CRASH UNNECESSARILY.

 	    (cond ((< actual-arity expected-arity)
		   (list "Too few terms in predicate" exp))
		  ((> actual-arity expected-arity)
		   (list "Too many terms in predicate" exp))))))
	(t (list "Unknown predicate in atomic formula: " exp))))


;;AS AN EXAMPLE OF WHEN THIS WOULD OCCUR TRY FEEDING THE FOLLOWING SC-RULE
;;TO PRODIGY FOR THE EXTENDED-STRIPS DOMAIN:
;;
;;(R2-PREFER-INROOM-OVER-INROOM-USING-OP-ANY
;; (LHS
;;  (AND (CURRENT-NODE <NODE>) (CANDIDATE-GOAL <NODE> (INROOM <V46> <G-3>))
;;       (CANDIDATE-GOAL <NODE> (INROOM ROBOT <G-1>))
;;       (KNOWN <NODE>
;;              (AND (IS-KEY <V40> <V46>) (DR-TO-RM <V40> <V45>)
;;                   (DR-TO-RM <V40> <G-1>) (IS-DOOR <V40>)
;;                   (CONNECTS <V40> <G-1> <V39>) (~ (DR-OPEN <V40>))
;;                   (~ (UNLOCKED <V40>)) (NOT-EQUAL <V46> ROBOT)
;;                   (~
;;                    (EXISTS (<V162>) (DR-TO-RM <V40> <V162>)
;;                     (EXISTS (<V163>) (IS-KEY <V40> <V163>)
;;                      (AND (CONNECTS <V40> <G-1> <V39>) (IS-DOOR <V40>)
;;                           (DR-TO-RM <V40> <G-1>)
;;                           (OR (NOT-EQUAL <V45> <V162>)
;;                               (NOT-EQUAL <V46> <V163>))))))))))
;; (RHS (PREFER GOAL (INROOM ROBOT <G-1>) (INROOM <V46> <G-3>)))) 

