#ifdef __GNUC__
 #pragma once
#endif

#ifndef _ERROR_H_
#define _ERROR_H_
#include "debug.h"
#include <stdio.h>
#include <errno.h>


#ifdef DEBUG

#define Error(fprintf_args) \
  fprintf(stderr, "$ Error: %s line %d  (in %s)\n  ", \
	  module_string, __LINE__, procedure_string), \
  fprintf fprintf_args , \
  perror("") , \
  fflush(stderr)

#else

#define Error(fprintf_args) \
  fprintf(stderr, "$ ") , \
  fprintf fprintf_args , \
  perror("") , \
  fflush(stderr)

#endif

  
#define SYS_ERROR(sys_func_str, ret_code, action) \
  { \
  Error((stderr, "%s returned %d: (errno: %d) \n", \
	 sys_func_str, ret_code, errno)) ; \
  action ; }


#endif  /* _ERROR_H_ */
