;
;	BUILD II, by John Nagle
;
;	Definitions for planning system
;
;						Version 1.6 of 5/17/87
;
(require 'builddefs "builddefs")
(use-package 'builddefs)
(require 'database "database")
(use-package 'database)
(provide 'plandefs)
;
;
;	gripehandlers  --  macro used in defining gripe handlers
;
;	Used within choice functions.  Usage is
;
;	(defun choicefn (...)
;	  (gripehandlers
;		(handlername (handlerargs) handlerbody)
;		(handlername (handlerargs) handlerbody)
;		...)
;	     body of choice fn))
;
;	Gripehandlers generates a local function definition for each
;	gripe handler.  The body of the choice function is enclosed
;	in the same tagbody that encloses the gripe handlers, so that
;	GO escapes from the gripehandlers are permissible.  The
;	variables of the choice function are visible to the gripe
;	handlers, of course.
;
;	This macro expands into the form
;
;	(defun choicefn (...)
;	  (prog (handlername handlername ...)
;	    (setq handlername (function (lambda (handlerargs) handlerbody)))
;	    (setq handlername (function (lambda (handlerargs) handlerbody)))
;	    body of choice fn))
;
(defmacro gripehandlers (handlers &body body)
  `(prog
    ,(mapcar #'first handlers)		; declare names of handlers
    ;	Generate handler definitions
    ,@`,(mapcar 
	 #'(lambda (handler)
		   `(setq ,(first handler) 
			  (function 
			   (lambda ,(second handler) 
				   (block ,(first handler)	; named block
					  ,@(cddr handler))))))
	 handlers)
    ,@body))				; body of choice fn
;
;	Global variables of the planning system
;
;
;	Contexts generally visible
;
(defparameter empty-context context "The empty context")
(defvar real-world-context (push-context) "State of the robot's world")
