;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.4 of 3/2/87
;
;	Tower-building for counterweight and scaffolding purposes.
;
(require 'builddefs "builddefs")		; prerequisite
(require 'addblock "build3")
(require 'vector "build1")
;
;	findtower-w  --  find combination of spares to make tower of weight w.
;
;	I (Nagle) have serious doubts that this ever worked in its original
;	form.   The code is invalid and the algorithm is poor.  Something
;	like a change-making algorithm is needed.  A minor rewrite has been
;	done, but a major rewrite is necessary.
;
(defun findtower-w (weightneeded spares
				 &aux (towerw 0.0) (h 0.0) tower cg w)
  (map nil 
       (function
	(lambda (spare)
		;	Done when tower is of desired weight.
		(when (aeq (towerw weightneeded) 
			   (return-from findtower-w tower)))
		(setq w (get spare 'weight))		; weight of this block
		(setq cg (get spare 'cgrav))		; center of gravity
		(cond
		 ((not (member (get spare 'shape)	; only bricks and wedges
			       '(brick wedge))))
		 ((> w (+ tol1 (- weightneeded towerw)))) ; too heavy, ignore
		 (t 
		  ;	Position blocks with CGs vertically in line.
		  ;	returns ((BLK . AT) (BLK . AT) ...)
		  (push
		   (cons spare
			 (atchange orgloc
				   (list (- (first cg))
					 (- (second cg))
					 (+ h (- (aref (get spare 'size) 2)))
					 0.0
					 0.0
					 0.0)))
		   tower)
		  ;	Compute current height and weight of tower.
		  (setq towerw (+ towerw w))
		  (setq h (+ h (aref (get spare 'size) 2)))))))
       spares)
  ;	Did we succeed?
  (when (aeq (towerw weightneeded) 
	     (return-from findtower-w tower)))
  nil)					; otherwise fail
;
;	findtower-h  --  find combination of spares to make tower of 
;			 height TH.
;
;	Definitely only good for bricks and wedges.
;
(defun findtower-h (ch th spares
		       &aux shape b size initn cg x)
  ;	Try each spare, looking for a usable one.
  (loop
   (unless spares (return-from findtower-h nil))
   (setq b (pop spares))		; take next spare
   (setq shape (get b 'shape)
	 size (get b 'size)
	 cg (get b 'cgrav))
   ;	For bricks, all 3 orientations may be tried, but for wedges, only
   ;	one is considered.
   (setq initn
	 (cond  ((eq shape 'brick) 0)
		((eq shape 'wedge) 2)
		(t nil)))
   ;	Try allowed orientations.
   (when initn
	 (do ((n initn (1+ n)))
	     ((= n 3))
	     (when
	      (aeq (aref size n) th)		; Tower height OK, done.
	      (return-from 
	       findtower-h 
	       (list (list b
			   (atchange (ftarrays n)
				     (list (- (first cg))
					   (- (second cg))
					   (+ ch (half (aref size n)))
					   0.0
					   0.0
					   0.0))))))
	     (unless (< (aref size n) th)		; Unless block too big
		     ;	Recursively construct tower
		     (setq x (findtower-h 
			      (+ ch (size n)) 
			      (- th (size n)) 
			      spares))
		     (unless x (return-from findtower-h nil)) ; fails if no subtower
		     (return (cons (list b
					 (atchange (ftarrays n)
						   (list (- (first cg))
							 (- (second cg))
							 (+ ch (half (size n)))
							 0.0
							 0.0
							 0.0)))
				   x)))))))
;
;	Initialization  -- orientations for piling.
;
(defparameter ftarrays 
  (make-array '(3) :initial-contents
	      (list (atchange orgloc 0.0 0.0 0.0 0.0 0.25 0.0) ; rot. about Y
		    (atchange orgloc 0.0 0.0 0.0 0.25 0.0 0.0) ; rot. about X
		    orgloc)))					; unrotated
