;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.3 of 4/4/87
;
(require 'builddefs "builddefs")		; prerequisite
;
;	try-msa  --  try to find a way to win using movable subassemblies.
;
;	***NEEDS EXTENSIVE WORK***
;
(defun try-msa (losses sg
		       &aux losers posbases b r when x y g)
  ;
  ;	Gripe handlers
  ;
  (gripehandlers 
   ;
   ;	fromverify  --  verifiy operation failed (?)
   ;	
   ;	***SO WHY ARE WE ACTING LIKE THIS IS A SUCCESS?
   ;
   ((fromverify (message returnable)
		(setq backtag nil)
		(return-from try-msa plan))
    ;
    ;	frompmsa  --  trouble placing subassembly at goal position.
    ;
    (frompmsa (message returnable)
	      (cond ((eq (first message) 'hit-g)	; collision
		     (let ((l
			    (mapcar
			     (function
			      (lambda (z)
				      (cond ((eq (first z) (second message))
					     (cons (second z) (getat (cadr z))))
					    ((memq (first z) (third message))
					     (cons (second z) (getat (cadr z))))
					    ((cons (first z) (getat (car z))))))
			      (fourth message)))))
			  (loop
			   (when (null l) (return-from try-msa backtag))
			   (and (eq (cdar l) (getat (caar l)))
				(prevgoal (list 'get-rid-of (caar l) (ncons sg))
					  backtag
					  fromunhit))
			   (pop l)))))
	      ;	Not hit, other kind of problem.
	      (setq posbases (rest posbases) backtag nil context oldcon)
	      (go loop1))		; abandon this subgoal
    ;
    ;	fromunhit  -- trouble during get-rid-of of obstacle.
    ;
    ;	Abandons the subgoal
    ;
    (fromunhit (message returnable)
	       (setq posbases (rest posbases) backtag nil context oldcon)
	       (go loop1)))
   ;
   ;	Body of try-msa
   ;
   (setq losers (mapcar #'cadr losses))
   (setq posbases (posbases losses sg))
   ;	Try next possible base block for subassembly.
   loop1
   (cond ((null posbases) (gripe (list 'no-msa)))
	 ((null (setq r (maxmsa (setq b (first posbases)) sg))))
	 ((< (length (commonels losers (cons b r))) 2))
	 ((setq x (unplaceable-msa b r sg))
	  (unless (eq t x)
		  (push (first x) posbases)))
	 ((go gotmsa)))
   (pop posbases)			; base no good, try another.
   (go loop1)
   gotmsa
   (and (present (list 'in-place x b))	; if already in place
	(setq when (prevmoved x plan))
	(go timetravel))
   ;	Subgoal  --  try to place multiple subassembly.
   (setq plan (goal 'place-msa (list b r sg nil) frompmsa))
   (setq context (cadar plan))		; accept new context
   (return-from try-msa plan)		; success, done
   timetravel
   (setq plan (first when)
	 context (cond (plan (cadar plan))
		       (t (caar (last oldplan)))))
   (setq g (list 'place-msa b r sg nil))
   (setq plan (goal g (tag 'frompmsa)))
   (setq context (cadar plan))
   (setq x (rest when))
   loop2
   (cond ((null x) (return plan))
	 ((ignore (cddar x)))
	 ((csetq g (caddar x))
	  (csetq plan (goal g (tag 'fromverify)))
	  (csetq context (cadar plan))))
   (csetq x (rest x))
   (go loop2)))


;;given base, riders of msa in sg, create and move such an msa in sp.
;;if test is nil, it is certain that the given msa is legal.

(cdefun place-msa
          ('baseg 'riders 'sg "optional" ('test t))
          "aux"
          (intersg riderlocs helpers g y bmat rmat loc)
          (csetq loc (findspace-msa baseg riders sg))
          (and (eq (first loc) 'lose) (gripe (rest loc)))
          (csetq helpers (rest loc) loc (first loc))
          (csetq intersg (globalsprout))
          (csetq riderlocs
               (in-context sg '(saverel (getat baseg) riders)))
          (add '(,baseg at ,loc) intersg)
          (in-context intersg '(reladd loc riderlocs))
          (mapc
          '(lambda (x)
                    (add '((/@ car x) at (/@ cdr x)) ,intersg))
                         (not (eq x ,baseg))
                         (not (nemq x ,riders))
                         (not (assq ,y ,helpers))
                         (add '((/@ . x)
                              at
                              (/@ in-context ,sg '(getat x)))
                            ,intersg)))
           (getobs sg))
          (csetq g (list 'build intersg))
          (csetq plan (goal g (tag 'frombuild)))
          (csetq context (cadar plan))
          (or (present '(in-place ?y ,baseg))
               (error baseg not placed - place-msa))
          (csetq bmat y)
          (csetq rmat
                 (mapcar
                  '(lambda (x) (or (present '(in-place ?y (/@ . x)))
                                   (error (* x) not placed - place-msa))
                               ,y)
                  riders))
          (remall '(in-place ? ?))
          (protectorbs sg)
          (csetq g
               (list 'moveg
                    bmat
                    rmat
                    (getat bmat)
                    (unrelate (relate (getat bmat)
                                        (in-context intersg
                                                  '(getat baseg)))
                                   (in-context sg '(getat baseg)))
                         test))
          (csetq plan (goal g (tag 'frommoveg)))
          (csetq context (cadar plan))
          (add '(in-place ,bmat ,baseg))
          (mapc
           '(lambda (x y) (add '(in-place (/@ . x) (/@ . y))))
           rmat
           riders)
          (return plan)
          :frombuild
          (pass)
          :frommoveg
          (pass))


;;sprout new context from global (only table present).

(defun globalsprout nil (new-context (list (cframe) ,global)))


;;find place to build msa.

(defun findspace-msa (baseg riders sg)
        (prog (l x fcon sw)
               (setq l (in-context sg '(saverel (get baseg) riders))) 
               (cond ((setq x (curpos baseg l sg)) (return x))
                     ((setq x (findtablepos baseg riders sg l)))
                     ((return (list 'lose
                                    'unstab-on-table
                                    baseg
                                    riders____
               (setq fcon ,context sw nil)
         loop (cond ((setq x (in-context fcon
                                        '(findspace baseg x nil)))
                     (and (in-context fcon '(checkspace x baseg l))
                          (return (ncons x)))
                     (go loop))
                    (sw (return (list 'lose
                                      'no-space-g
                                      baseg
                                      riders)))
                    (t (setq sw t fcon (flushobs fcon))
                       (store (x 3 0) 0.0)
                       (store (x 3 1) 0.0)
                       (go loop)))))


;
;	checkspace  --  see if MSA fits into current state at location LOC.
;
;	Thought experiment - does not change state.
;	Pure predicate - returns T if MSA can be placed at LOC.
;
(defun checkspace (loc b l)
  (in-context 
   (push-context)		; begin thought experiment
   (addat b loc)		; add base block B.
   (reladd loc l)		; add other blocks L.
   (return-from checkspace (not (eq 'hit (first (gettouch)))))))


;;flush everything but obs already in place.

(defun flushobs (con)
          (prog (fcon)
               (setq fcon (push-context))
               (mapc '(lambda (x)
                              (or (present '(in-place (/@ . x) ?))
                                  (unrealize (present '((/@ . x) at ?))
                                             (fcon)))
                      (getobs))
               (return fcon)))


;;see if current position of best candidate to match baseg is good
;;place to assemble msa. this routine currently too dumb to consider
;;symmetrical orientations of this block. it must be on table right
;;side up. also too dumb to try other good matches.

(defun curpos (baseg l sg)
       (prog (bmat loc)
             (setq bmat (first (supsort (getmatches baseg sg))))
             (and (equal (getsupsof (first bmat)) '(table))
                  (eq (rest bmat) orgloc)
                  (msaposok baseg l (setq loc (getat (first bmat))))
                  (in-context (flushobs ,context)
                              '(checkspace loc baseg l))
                  (return (ncons loc)))
             (return nil)))


;;see if nsa is stable in given orientation. does not shake.

(defun msaposok (b l loc) (prog (oldcon)
                                   (setq oldcon ,context)
                                   (csetq context (globalsprout))
                                   (add '((/@ . b) at (/@ . loc)))
                                   (and (eq 't (checkstate))
                                        (or (reladd loc l) t)
                                        (eq 't (checkstate))
                                        (add '(immovable (/@ . b)))
                                        (rem '(table at ?))
                                        (eq 't (checkstate))
                                        (csetq context oldcon)
                                        (return t))
                                   (csetq context oldcon)
                                   (return nil)))


;;find orientation of baseg and height such that msa is stable
;;on table. tries all lower planes of baseg as supports.

(defun findtablepos (baseg riders sg l)
          (prog (f susp sgat loc)
          (setq f
                    (in-context sg '(getfacep baseg))
                    susp
                    nil
                    sgat
                    (in-context sg '(getat baseg)))
          (do i
              0.
              (1+ i)
              (= i (first (get f 'dimension)))
              (and (< (f i 2) botlim) (setq susp (cons f susp))))
          loop (and (null susp) (return nil))
               (setq loc (stand baseg sgat f (first susp)))
               (and (msaposok baseg l loc)
                    (store (loc 3 0) 0.0)
                    (store (loc 3 1) 0.0)
                    (return loc))
               (setq susp (rest susp))
               (go loop)))


;;tip block and raise or lower it so plane i of array p is flat on
;;table. return new at array.

(defun stand (b at ff i)
          (prog (newat w nv newv lowv)
               (cond ((aeq 0.0 (setq w (sqrt (+ (sq (ff i 0))
                                                  (sq (ff i 1))))))
                      (and (aeq -1.0 (ff i 2))
                           (setq newat (copy at) newv (getverts b))
                           (go fixheight))
                      (setq newat (fillarray '(4 3)
                                             (list (minus (/  (* (ff i 0)
                                                                   (ff i 2))
                                                                w))
                                                   (minus (/  (ff i 1) w))
                                                   (minus ff i 0/))
                                                   (minus (/  (* (ff i 1)
                                                                   (ff i 2))
                                                                 w))
                                                   (/  (ff i 0) w)
                                                   (minus (ff i 1))
                                                   w
                                                   0.0
                                                   0.0
                                                   0.0)))
???                 skip (setq new at (unrelate newat ai))
               (convert (setq newv (gv b))
                    newv
                    newat
                    (setq mv (first (get newv 'dimension))))
          fixheight 
               (setq lowv (newv 0 2))
               (do j
                   0.
                   (1+ j)
                   (= j (first (get newv 'dimension)))
                   (and (< (newv j 2) lowv) (setq lowv (newv j 2))))
               (store (newat 3 2) (- (newat 3 2) lowv))
               (return newat)))


;;find good candidates for msa bases.

(defun posbases (losses sg)
 (prog (unl l1 l2 y)
  (setq unl nil l1 nil l2 nil)
  (mapc   
  '(lambda (x)
    (cond
     ((eq (first x) 'unreadysup) 
      (and (= (lenth (third x)) 1)
          (setq unl (cons (caaddr x) unl))))
     ((> (length (setq y (in-context (rvalue 'context
                                             (first (cddddr x)))
                                     '(reallosers (second x)
                                                  (third x)
                                                  (mapcar 'car
                                                          (fourth x))
                                                 sg))))
          1))
      ((memq (first y) l2))
      ((memq (cary l1) (setq l2 (cons (first y) l2)))
      ((setq l1 (cons (cary) l1)))))
 losses)
(mapc
 '(lambda (x)
          (or (memq x l2) (and (memq x l1) (setq l2 (cons x l2)))))
 unl)
(return l2)))


;;find place or place in losing chain where sg support relations fail

(defun reallosers (sgb spb losers sg)
     (prog (l y ll)
          (cond ((memq spb losers) (return (ncons sgb)))
                ((immovable spb) (return nil)))
          (setq l nil)
          (mapc
          '(lambda (x)
                   (and (setq y (present '(in-place (/@ . x) ?)))
                        (setq l (cons (cons x (caddar y)) l))))
          (getsupof spb))
         (setq ll l)
     loop (cond ((nul ll))
                ((present '((/@ cdar ll) sup-by (/@ . sgb) . ?)
                         sg)
                 (return (ncons sgb)))
                (t (setq ll (rest ll)) (go loop)))
          (return (mapcan
                    '(lambda (x)
                             (reallosers (rest x) (first x) losers sg))
                    l))))


;;find maximal msa in sg that has b as base.

(defun maxmsa (b con)
       (prog (oldcon y)
               (setq oldcon ,context)
               (csetq context (push-context con))
               (and (immovable b) (return nil))
               (mapc '(lambda (x) (and (immovable x)
                                        (rem '((/@ . x) at ?))))
                    (getobs))
               (add '(immovable ,b))
       loop (cond ((eq 't (setq y (checkstate))) (go shake))
                    ((eq 'hit (first y)) (error hit in maxmsa))
                    ((mapc
                      '(lambda (x) (rem '((/@ car x) at ?)))
                      (rest y))
                     (go loop)))
       shake(cond ((setq y (shakeup clumsitude))
                   (mapc
                    '(lambda (x) (rem '((/@ car x) at ?)))
                    (rest y))
                   (go loop))
                  (t (setq y (delq b (getobs)))
                    (csetq context oldcon)
                    (return y)))))


;;see if msa can be safely placed.

(defun unplaceable-msa (b r sg)
          (prog (oldcon l y ans)
               (setq oldcon ,context)
               (csetq context (push-context sg))
               (setq l (cons b (append r (supporting b))) ans t)
               (mapc
                '(lambda (x)
                         (or (memq x l) (rem '((/@ . x) at ?))))
                (getobs))
               (cond ((eq 't (setq y (checkstate)))
                      (setq ans nil))
                     ((eq 'hit (first y))
                      (error hit in unplaceable-msa))
                     ((eq (length (setq y (reallosers b
                                                      b
                                                      (mapcar 'car
                                                              (rest y))
                                                      sg)))
                         2)
                      (setq ans y)))
               (csetq context oldcon)
               (return ans)))


;;find intersection of two lists.

(defun commonels (l1 l2)
          (prog (l)
               (setq l nil)
               (mapc '(lambda (x) (and (memq x l2) (setq l (cons x l))))
                    l1)
               (return l)))


;;find if b previously moved.
;;split plan into part before prep-for move and part after move.

(defun prevmoved (b plan)
          (prog (x y) (setq x nil)
               loop1(cond ((null plan) (return nil))
                         ((and (eq (caar (setq y (caddar plan)))
                                   'move)
                               (eq (cadar y) b))
                         (setq plan (rest plan))
                         (go loop1)
               loop2(cond ((null plan) (return (cons nil x)))
                          ((prepping b (caddar plan)))
                          ((return (cons plan x))))
                    (setq plan (rest plan))
                    (go loop2)))


;;is moving b part of reason?

(defun prepping (b reas)
          (cond ((null reas) nil)
                ((and (eq (caar reas) 'move) (eq (cadar reas) b)))
                (t (prepping b (rest reas)))))


;;seeif this step should be skipped during verification.

(defun ignore (step)
          (cond ((eq (first step 'move)
                 (not (eq (getat (second step)) (third step))))
                ((eq (first step 'moveg)
                 (not (eq (getat (second step)) (fourth step))))))


