;
;	BUILD II  --  a blocks world
;
;						John Nagle
;						Version 1.4 of 4/14/87
;
(require 'builddefs "builddefs")		; prerequisite
(require 'plandefs "plandefs")		
;
;	Path planning (preliminary)
;
;	This is an initial implementation of path planning.  All
;	moves consist of vertical movement to a high position,
;	an X,Y translation with rotation about the Z axis only,
;	and a downward movement to the final position.
;
;	For a path to be valid, we must be able to get the gripper
;	around the object at a valid grip point.  We must then be
;	able to move the gripper and object upward without a collision.
;
;
;	move-path-check
;
;	Given a base object B at FROM to be moved to TO, along with a
;	list of additional blocks L to be moved while maintaining 
;	relative position, is a straight-line move between the points
;	possible without colliding with anything?
;
(defun move-path-check (from to b l)
	)

;
;	translation-collision-test-1  --  check for collision during move
;
;	Single-block test.
;	The translation volume is constructed and a collision check is made.
;	The translation volume is removed after the test.
;
(defun translation-collision-test-1 (from to b)
  (let ((tv (translation-volume from to b)))	; gen translation volume
       (let ((hits (gettouch tv)))		; do collision check
	    (remblock tv)			; get rid of translation volume
	    (if (eq (first hits) 'hit)		; collision?
		(rest hits)			; yes, return obstacles
		nil))))				; no, return nil.
;
;	translation-collision-test  --  check for collision during move
;
;	Multi-block test.
;
;	If WANTOBSTACLES is set, the complete list of obstacles in the
;	path is returned; otherwise just T if a collision.
;	 
(defun translation-collision-test (from to b l &optional (wantobstacles nil)
)
;
;	z-rotation-collision-test  --  check for collision during rotation
;
;	At present, only rotation about the Z axis is actually supported.
;
;	This test is very conservative; one can only do a rotation if
;	a full circle rotation would be legal at the current location.
;	We construct a rectilinear enclosing volume that encompasses
;	all possible Z-axis rotations for this test.
;
(defun z-rotation-collision-test (where b l)
)
;
;	move-details  --  plan move of block at detailed level.
;
;	Choice function.
;
(defun move-details (from to b)
)
;
;	get-free  --  grip block and get free of obstacles
;
;	Choice function.
;
(defun getfree (b)
)
;
;	transport  --  transport block to point above goal.
;
;	Choice function.
;
(defun transport (locg b)
)
;
;	put-in-place  --  put block in desired place
;
;	Choice function.
;
(defun put-in-place (locg b)
)
