;
;	BUILD II  --  a blocks world
;
;						John Nagle
;						Version 1.1 of 5/17/87
;
(require 'builddefs "builddefs")
(use-package 'builddefs)
(require 'vector "vector")
(use-package 'vector)
;
;	Latitude/longitude calculations for rotations.
;
(defconstant halfpi (* pi 0.5))
(defconstant prime-meridian-at-equator (make-vector3 1.0 0.0 0.0))
;
;	angles-from-orientation  -- returns latitude and longitude
;				    given orientation matrix.
;
;	Returns (lat . lng)
;
;	Returned angles are in form 1.0=full circle.
;
(defun angles-from-orientation (orient)
  (let* ((ovec (rotate-vertex prime-meridian-at-equator orient))
	 (latitude (asin (vector3-z ovec)))	; angle from equator
	 (longitude (if (< (vector3-x ovec) 0.0); angle from prime meridian
			(- halfpi (fix-complex (asin (vector3-y ovec))))
			(fix-complex (asin (vector3-y ovec))))))
	(cons (/ latitude twopi) (/ longitude twopi))))
;
;	fix-complex  --  fix unwanted complex number
;
;	KCL's asin and acos sometimes produce complex numbers with small
;	imaginary parts for values in the range -1.0..1.0.
;
(defun fix-complex (val)
  (assert (< (abs (imagpart val)) 1.0E-10)) ; trap non-trivial imaginary part
  (realpart val))			; return real part
;
;	rotate-vertex  --  convert a single point or vector per LOC
;
(defun rotate-vertex (pnt rot)
  (check-type pnt vector3)	; must be vector3
  (let ((x (vector3-x pnt))	; extract coords of point
	(y (vector3-y pnt))
	(z (vector3-z pnt)))
       ;	Construct new point
       (make-vector3
	(+ (* (aref rot 0 0) x)
	   (* (aref rot 1 0) y)
	   (* (aref rot 2 0) z))
	(+ (* (aref rot 0 1) x)
	   (* (aref rot 1 1) y)
	   (* (aref rot 2 1) z))
	(+ (* (aref rot 0 2) x)
	   (* (aref rot 1 2) y)
	   (* (aref rot 2 2) z)))))
;
;	orientation-from-angles  --  compute orientation given lat and long.
;	***DOESN'T WORK***
;
(defun orientation-from-angles (lat lng)
  (let ((rot 	(make-array '(3 3) :element-type 'long-float))
	(cx	(cos (* rx twopi)))	; sines and cosines of rotation
	(cy	(cos (* ry twopi)))
	(cz	(cos (* lng twopi)))
	(sx	(sin (* rx twopi)))
	(sy	(sin (* ry twopi)))
	(sz	(sin (* lng twopi))))
       (store (rot 0 0)	(* cy cz)) ; build new rotation matrix
       (store (rot 0 1)	(* cy sz))
       (store (rot 0 2)	(- sy))
       (store (rot 1 0)	(- (* sx sy cz) (* cx sz)))
       (store (rot 1 1)	(+ (* sx sy sz) (* cx cz)))
       (store (rot 1 2)	(* sx cy))
       (store (rot 2 0)	(+ (* cx sy cz) (* sx sz)))
       (store (rot 2 1)	(- (* cx sy sz) (* sx cz)))
       (store (rot 2 2)	(* cx cy))
  rot))
;
;	rotation-about-z  --  compute orientation matrix for rotation about Z
;
(defun rotation-about-z (lng)
  (let ((rot 	(make-array '(3 3) :element-type 'long-float))
	(cz	(cos (* lng twopi)))
	(sz	(sin (* lng twopi))))
       (store (rot 0 0)	cz) ; build new rotation matrix
       (store (rot 0 1)	sz)
       (store (rot 0 2)	0.0)
       (store (rot 1 0)	(- sz))
       (store (rot 1 1)	cz)
       (store (rot 1 2)	0.0)
       (store (rot 2 0)	0.0)
       (store (rot 2 1)	0.0)
       (store (rot 2 2)	1.0)
       rot))
