;
;	BUILD II  --  a blocks world
;
;						John Nagle
;						Version 1.1 of 5/11/87
;
(require 'builddefs "builddefs")		; prerequisite
(require 'plandefs "plandefs")		
;
;	Robot kinematics of the RS-1 robot.
;
;	All joint values here assume that the robot has been calibrated
;	to operate in a workspace with X,Y, and Z bounds as defined
;	by XMIN, etc.
;
;	pos-to-joints   --   given location, compute joint values
;
;	The POS is the point midway between the endpoints of the
;	jaws.
;	The PLN is the orientation of the plane which is perpendicular
;	to the line between the jaws, and therefore is also the plane of
;	the jaw faces.
;	The APPROACH-ANGLE is the remaining degree of freedom; the
;	orientation of the axis of the gripper.  An APPROACH-ANGLE
;	of 0 corresponds to an approach from directly above.
;	The JAW-WIDTH is how far the jaws are to be open.
;
;	A set of seven joint values suitable for transmission to the robot
;	is returned.  The joint set is NOT validated for collision
;	or limit stops.
;
(defun pos-to-joints (pos pln approach-angle jaw-width)
)
;
;	joints-to-pos  --  given joint values, compute position, etc.
;
;	Inverse operation of JOINTS-TO-LOC.
;
;	Returns (POS PLN APPROACH-ANGLE JAW-WIDTH).
;
(defun joints-to-pos (joints)
)
;
;	joint-limit-check  --  check joint set for validity
;
;	Determines whether a given joint set is valid.  All joints
;	must be within limits and all parts of the gripper must be
;	above the table for this check to pass.
;
;	The present version of this check is conservative.  It
;	simply places bounds on the Z axis value.
;	It will thus not allow the gripper to get closer to the table 
;	than the distance allowed with all the rotational joints at 0.
;
;
(defun joint-limit-check (joints)
	nil)				; ***TEMP***
;
;	joints-to-parts  --  given joint set, return positions of the
;			     parts of the manipulator.
;
;	This drives the collision detection mechanism.  Given a joint
;	set, a list of pairs of the form
;
;		(blk location)
;
;	is returned, indicating the positions of the blocks making up
;	the model of the manipulator.  A collision detection check
;	performed on these parts will determine whether the manipulator
;	will hit anything if placed in the indicated position.
;
(defun joints-to-parts (joints)
)
