;
;	BUILD II  --  a blocks world
;
;						John Nagle
;						Version 1.3 of 5/11/87
;
(require 'builddefs "builddefs")		; prerequisite
(require 'plandefs "plandefs")		
;
;	Model of the RS-1 robot gripper used to detect collisions with
;	the manipulator.
;
;	Measured dimensions of volume enclosing RS-1 robot gripper for
;	zero-pitch position.  Dimensions in mm.
;
;	The position described here represents the gripper pointed
;	straight down, with zero roll, with the gripper just touching
;	the table and with the jaws of the gripper closed.  The origin
;	is where the centerline of the gripper intersects the table.
;
;
;	gripper-parts  --  components of the gripper model
;
(defparameter gripper-parts
  (list
   (genblock	'jaw1	'brick	45.0	26.0	70.0)
   (genblock	'jaw2	'brick	45.0	26.0	70.0)
   (genblock	'wrist	'brick	251.0	58.0	128.0)
   (genblock	'arm	'brick	432.0	432.0	432.0)
   ))
;
;	gripper-part-positions  --  return list of gripper part positions
;				    given operating parameters of gripper.
;
;	***NEEDS WORK***
;
(defun gripper-part-positions (jaw-opening roll)
  (list
   (list (make-location	:x (+ 22.5 jaw-opening)	:y 0.0	:z 35.0) 'jaw1)
   (list (make-location	:x (- -22.5 jaw-opening) :y 0.0	:z 35.0) 'jaw2)
   (list (make-location	:x 42.0	:y 0.0	:z 134.0) 'wrist)
   (list (make-location	:x 0.0	:y 0.0	:z 414.0) 'arm)))
;
;	add-manipulator  --  adds manipulator to the current context at
;			     the indicated point and rotation.
;	***NEEDS WORK****
;
(defun add-manipulator (loc jaw-opening)
  (dolist (grp (gripper-part-positions jaw-opening 0.0))
	  (addat (name-block (second grp))
		 (unrelate-location loc (first grp)))))
;
;	remove-manipulator  --  get manipulator out of model
;
(defun remove-manipulator nil
	(mapc #'remblock gripper-parts))
;
;	manipulator-collision-test  --   will placing manipulator at given
;					 position cause a collision?
;
;	This is the first-line test of collision detection; if the manipulator
;	can't be placed at the desired point for a grasp, path testing is
;	unnecessary.
;
;	For our initial system, we only move straight up and down, and our
;	model of the manipulator is so constructed that if this test passes,
;	such a path will not result in a collision.
;
(defun manipulator-collision-test ()
	)
