;
;	BUILD II  --  a blocks world
;
;						John Nagle
;						Version 1.2 of 4/10/87
;
(require 'builddefs "builddefs")		; prerequisite
(require 'plandefs "plandefs")		
;
;	Grasp planning  (preliminary)
;
;	We can only grasp objects having two parallel faces.
;
;	We find all pairs of opposing faces.  Preference is given
;	to faces that aren't touching anything.
;
;	This version always grasps with the gripper aligned with a line
;	through the center of gravity and perpendicular to the chosen
;	faces.  Thus, for any face pair, there is only one remaining 
;	degree of freedom, the angle of the gripper about the line through
;	the CG.  We try some standard angles, 0 (vertical), +90, -90,
;	+45, and -45. 
;
;	When considering grips, we first consider whether the situation
;	that will exist when the gripper is closed around the object
;	is free of collisions.  If this works, we visualize the actual
;	approach-close-lift sequence taking place, noting any collisions.
;
;	Initially we will only consider vertical gripper positions;
;	this will change when we improve the solid model of the
;	manipulator so that we really have a decent model of the wrist.
;
;	Everything here operates during planning, not manipulation; when
;	we speak here of "grasping" we are not actually driving the 
;	manipulator; that happens during plan execution, later.  So
;	we can explore various approaches here and discard unsuccessful
;	ones.
;
;
;
;	grasp  --  grasp a block
;
;	Choice function.  Plans grasping tasks.  
;	Chooses suitable grasp, plans move to grasp position, grasps.
;	Initial state has gripper in clear space directly above block.
;	Final state has gripper closed on block, but block not yet moved.
;	***DO LIFT HERE TOO?***
;
(defun grasp (b)
)
;
;	ungrasp  --  place and release a block.
;
;	Choice function.  Plans ungrasping and release task.
;
;	Initial state has gripper closed on block at desired position.
;	Final state has gripper open on block at desired position.
;	Insures that enough space is available to open the gripper, and
;	does so.
;
(defun ungrasp (b)
	)
;
;	grippable-faces  --  find all pairs of grippable faces for a shape
;
;	Returns a list of face index pairs.
;	This is independent of orientation and current position of the block.
;
(defun grippable-faces (shp)
)
;
;	easy-grasps
;
;	Returns a list of possible grasping approaches that don't involve
;	removing any obstructing blocks.
;
(defun easy-grasps (b)
)
;
;	possible-grasps
;
;	Returns a list of possible grasping approaches.
;	For each approach, there may be a list of obstructing blocks.
;
(defun possible-grasps (b)
)
