;
;	BUILD II, by John Nagle
;
;						Version 1.9 of 4/22/87
;
;	Tools to assist manually manipulating the situation.
;
(require 'builddefs "builddefs")
(require 'database "database")
(require 'plandefs "plandefs")
(use-package 'builddefs)
(use-package 'database)
;
(defparameter moveunit 0.25 "Move block this fraction of its own max dim")
(defconstant left '(-1 0 0))
(defconstant right '(1 0 0))
(defconstant hither '(0 -1 0))
(defconstant yon '(0 1 0))
(defconstant up '(0 0 1))
(defconstant down '(0 0 -1))
;
;	moveuntilhit  --  move block until it hits something
;
;	We then align the block so that it just touches.
;
(defun mvuntilhit (b dir
		     &aux origtouchers touchers loc)
  ; how much to move
  (setq dir (vscale (vnorm dir) (* moveunit (block-maxdimension b)))) 
  (setq origtouchers (touchblocks b))		; get original touchers
  (setq touchers origtouchers)			; initial touchers
  (loop
   (unless (subsetp touchers origtouchers) ; touched something new
	   (return))
   (setq loc (getat b))			; get loc of B
   (when (or 
	  (< (aref loc 3 0) xmin)
	  (> (aref loc 3 0) xmax)
	  (< (aref loc 3 1) ymin)
	  (> (aref loc 3 1) ymax)
	  (< (aref loc 3 2) zmin)
	  (> (aref loc 3 2) zmax))
	 (return))			; out of bounds
   (mvv b dir)				; move the block
   (setq touchers (touchblocks b)))	; new touchers
  ;	Hit something, touched something, or went off page
  (unless touchers (return-from mvuntilhit nil)) ; off page
  ;	Back off until just touching if hit
  (loop
   (cond ((eq (first touchers) 'hit)	; hit
	  (mvv b (vscale dir -0.5)))	; back up half a unit
	 ((not (subsetp touchers origtouchers)) ; touched something new
	  (return))			; just touched, done
	 (t	
	  (setq dir (vscale dir 0.5));	; free, halve move
	  (mvv b dir)))			; try again
   (setq touchers (touchblocks b)))	; new touchers
  t)
;
;	touchblocks  --  get simple list of touching blocks
;
;	Returns (blk blk ...) or '(hit) or nil
;
(defun touchblocks (b &aux touchers)
  (setq touchers (gettouch b))
  (cond ((eq (car touchers) 'hit)
	 touchers)
	(t (mapcar #'car touchers))))

;
;	mvv  --  move per vector
;
(defun mvv (b vec)
	(moveblock b (first vec) (second vec) (third vec)))
