;
;      BUILD  --  a blocks world
;
;      Originally by Scott Fahlman, as part of a Master's thesis
;      at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;      in 1974.
;
;      Brought back to life in 1987 by John Nagle.  
;      Keyboarded from Fahlman's Conniver source, with some comments
;      by Nagle.
;
;
;						Version 1.39 of 5/18/87
;
;	Declarations
;
;	This file must be present when compiling any other file of BUILD.
;
(provide 'builddefs)				; we provide this module.
(in-package 'builddefs)
(export '(
	  genarray
	  fillarray
	  subdivide
	  mkvectors
	  store
	  putprop
	  half
	  sq
	  twopi
	  halfpi
	  orgloc
	  killmsa
	  plotsw
	  showinter
	  showstep
	  blocklabels
	  tracks
	  trackstop
	  dumpstates
	  debug
	  xmin
	  ymin
	  zmin
	  xmax
	  ymax
	  zmax
	  tol1
	  mtol1
	  tol2
	  mtol2
	  grav
	  mu
	  density
	  fullscreen
	  halfscreen
	  woblim
	  findstep
	  clumsitude
	  shakevectors
	  plan
	  reason
	  goalp
	  *choices
	  goaldepth
	  size
	  sg
	  win
	  lose
	  hit
	  inside
	  outside
	  on
	  immovable
	  block
	  table
	  at
	  shape-name
	  shape-edges
	  shape-vertices
	  shape-edgefaces
	  shape-faceinfo
	  shape-faceplanes
	  shape-size
	  shape-weight
	  shape-cgrav
	  shape-maxd
	  shape-findpos-function
	  shape-match-function
	  shape-vertex-edges
	  ))
;
;
;	Maclisp compatibility functions
;
;	In general, we have chosen to convert the code to Common LISP
;	rather than converting the language system to Maclisp.  So
;	there are only a few compatibility functions.  Only functions
;	needed at compile/load time are present here.
;
;	genarray  --  generate an empty array object
;
;	usage: (genarray <dim1> <dim2> ...)
;
(defun genarray (&rest dimensions)
	(make-array dimensions))	; use given list
;
;	fillarray  --  generate a filled array object
;
;	usage (fillarray <list of dimensions> <list of initial values>)
;
;	Unlike make-array in Common LISP, the list of initial values is
;	a flat list, not a list with the form of the array.
;
(defun fillarray (dimensions values)
  (make-array dimensions :initial-contents 
	      (mkvectors (reverse dimensions) values)));
;
;	subdivide  --  subdivide a list into parts each M long.
;		       This must come out even.
;
(defun subdivide (lst m &aux row)
  (cond	((null lst) nil)			; nil if done
	(t (do ((i 0 (1+ i)))			; accumulate one part
	       ((= i m) nil)			; until did m elts
	       (when (null lst)
		     (error "List to fillarray not of proper length"))
	       (setq row (cons (car lst) row))	; prepend new elt
	       (setq lst (cdr lst)))		; use up elt
	   (cons (reverse row) (subdivide lst m)))))
;
;	mkvectors  --   make a flat list into a list of lists per
;			the dimensions given.
;
(defun mkvectors (dimensions values)
  (cond	((null (cdr dimensions))	; last dimension?
		values)			; yes, just return values
	(t (mkvectors (cdr dimensions)	; otherwise keep subdividing
		      (subdivide values (car dimensions))))))
;
;	store  --  store into array
;
;	(store (<array> <subscripts>) rvalue))
;
(defmacro store (lvalue rvalue)
	`(setf (aref ,@lvalue) ,rvalue))
;
;	putprop  --  compatibility with MacLISP
;
(defun putprop (name value tag)
	(setf (get name tag) value))
;
;	halve  --  multiply by 0.5
;
(defmacro half (x) `(* ,x 0.5))
;
;	sq  --  square
;
(defmacro sq (x) `(* ,x ,x))
;
;      Parameters
;
(defparameter twopi (* 2.0 pi))		; if a constant, KCL gripes on reload.
(defparameter halfpi (* 0.5 pi))
;
;      location array of origin
;
(defvar orgloc)
;
;	Operating modes
;
(defparameter killmsa t "Disable multiple support assemblies if on")
;
;      If plotsw is on,	plot everything	shown.
;
(defvar plotsw nil "Plotting enabled if on")
;
;	Output verbosity control
;
(defparameter showinter nil "Show each part of a step if on")
(defparameter showstep nil "Show each step if on")
(defparameter blocklabels t "Show block names if on")
(defparameter tracks t "Print goal calls and gripes if on")
(defparameter trackstop nil "Break at each track if on")
(defparameter dumpstates nil "Dump state before/after goal if on")
(defparameter debug 0 "More internal debug print if larger integer")
;
;      Boundaries of defined space
;
(defparameter xmin 0.0)
(defparameter ymin 0.0)
(defparameter zmin 0.0)
(defparameter xmax 1000.0)
(defparameter ymax 400.0)
(defparameter zmax 200.0)
;
;      System-wide roundoff tolerance
;
(defparameter tol1 1.0e-3)
(defparameter mtol1 (- tol1))
;
;      Tolerance for crud removal (clean)
;
(defparameter tol2 1.0e-3)
(defparameter mtol2 (- tol2))
;
;      Usual coefficient of friction
;
(defparameter mu 0.5)
;
;      Density of block	material
;      Choose so typical block weight near 1.0,	avoid tolerance	trouble
;
(defparameter density 1.0e-6)
;
;      Display dimensions
;      ***WILL NEED CHANGING***
;
(defparameter fullscreen 1024.0)
(defparameter halfscreen 512.0)
;
;      Limit of	wobbliness for findspace
;
(defparameter woblim 8.0)
;
;      Size of findspace increment
;
(defparameter findstep 100.0)
;
;      Parameters for shaking during moveg.
;
(defparameter clumsitude 0.2 "Assumed clumsiness factor of manipulator")
(defparameter shakevectors '(
		     (1.0 0.0 0.0)
		     (-1.0 0.0 0.0)
		     (0.0 1.0 0.0)))
;
;
;
;      Initialize vars for planning system.
;
(defvar plan nil)				; current plan
(defvar reason nil)				; why current goal
(defvar goalp nil)
(defvar *choices nil)				; chain of gripe handlers
(defvar goaldepth 0)				; depth in goal stack
;
;	Special variables rebound elsewhere
;
(defvar size)					; size of shape
(defvar sg)					; goal state
(defvar grav)					; which way is down?
;
;	Global constant names
;
;	Results of stability and collision tests.
(defconstant win 'win)				; used for winning
(defconstant lose 'lose)			; used for losing
(defconstant hit 'hit)				; when collision
;	Results of plane/point tests.
(defconstant inside 'inside)
(defconstant outside 'outside)
(defconstant on 'on)
;
;
;	Properties of shapes and/or blocks.
;
(defconstant shape-name 'shape-name)
(defconstant shape-edges 'shape-edges)
(defconstant shape-vertices 'shape-vertices)
(defconstant shape-edgefaces 'shape-edgefaces)
(defconstant shape-faceinfo 'shape-faceinfo)
(defconstant shape-faceplanes 'shape-faceplanes)
(defconstant shape-size 'shape-size)
(defconstant shape-weight 'shape-weight)
(defconstant shape-cgrav 'shape-cgrav)
(defconstant shape-maxd 'shape-maxd)
(defconstant shape-findpos-function 'shape-findpos-function)
(defconstant shape-match-function 'shape-match-function)
(defconstant shape-vertex-edges 'shape-vertex-edges)
;
;
;	Generally accessable database items
;
(defconstant at 'at)
(defconstant immovable 'immovable)
;
;	The table - our one built-in object
;
(defvar table)
