;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.1 of 4/18/87
;
;	Fragility testing for multiple block groups
;
;
;	***UNUSED--UNTESTED***
;
(require 'database "database")
(use-package 'database)
(require 'vector "vector")
(use-package 'vector)
(require 'builddefs "builddefs")		; prerequisite
(use-package 'builddefs)
(require 'buildutil "buildutil")
(use-package 'buildutil)
(require 'stability "build6.lsp")
(use-package 'stability)
;
;	shakeout  --  shake test for groups of blocks
;
;	Can we handle this collection of groups solely by moving
;	BASEG, or will some of the RIDERS fall off?
;
;	Imagine BASEG and RIDERS alone in space.  See what falls or can be
;	shaken loose.
;
(defun shakeout (baseg riders) (xout baseg riders t))
;
;	fallout  --  like shake test, but without permuted gravity.
;
(defun fallout (baseg riders) (xout baseg riders nil))
;
;	xout  --  conduct shake in thought-experiment environment.
;
(defun xout (baseg riders shake 
		   &aux x (context (push-context)))
  ;	Get rid of everything in context other than BASEG and RIDERS.
  ;	(We really need a way to get an empty context.  This could be slow.)
  (mapc 
   (function
    (lambda (b)
	    (unless (or (eq b baseg) (member b riders))
		    (remblock b))))
   (getobs))
  ;	Assume that the base block is immovable, since we are holding it.
  (context-add (list 'immovable baseg))
  ;	Make sure state is stable with normal gravity.
  (unless (eq t (setq x (checkstate)))
	 (return-from xout (cons 'static (cdr x))))
  ;	Try shaking experiment.
  (when shake
	(setq x (shakeup clumsitude))
	(return-from xout x))
  nil)
;
;	shakeup  --  shake by jiggling gravity vector, testing for stability.
;
;	The state for the experiment has already been set up.
;
(defun shakeup (clumsiness &aux losers)
  ;	Try shake test for all standard shaking directions.  Adjust
  ;	gravity vector as appropriate.
  (map nil
       (function 
	(lambda (shakedir)
		(setq losers (shake (vplus grav (vscale shakedir clumsiness))))
		(unless (eq t losers)			; if something fell
			(return-from shakeup losers))))	; tell caller
       shakevectors)
  t)
;
;	shake  --  remove all SUP-BY relations and check using new gravity.
;
;	Note that we are rebinding GRAV, which CHECKSTATE uses as the
;	direction of gravity.
;
(defun shake (grav) 
  (in-context (push-context)			; new scratch context
	      (delete-all-stability-relationships) ; force full recomputation
	      (checkstate)))			; full state check
