;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.10 of 4/22/87 
;
(require 'database "database")
(use-package 'database)
(require 'builddefs "builddefs")
(use-package 'builddefs)
(require 'vector "vector")
(use-package 'vector)
(require 'buildutil "buildutil")
(use-package 'buildutil)
;
;	Matching between states.
;
;	matchpos  --  is B1 in C1 identical to B2 in C2?
;
;	DISP is the displacement between the two scenes.
;
;	This works for any convex shape.
;	But the approach is brute-force.
;
(defun matchpos (b1 c1 b2 c2 disp
		    &aux won)
  ;	Number of faces must match.
  (let ((nf (array-dimension (block-faceplanes b1 0)))) ; number of faces
       (unless (= nf (array-dimension (block-faceplanes b2) 0))
	       (return-from matchpos nil))
       (let ((f1 (in-context c1 (getfacep b1)))	; faces of b1 in c1
	     (f2 (convert-planes (in-context c2 (getfacep b2)) disp)))
	    ;	Iterate over all pairs of faces of shapes.
	    ;	Each face must match some face of other object.
	    (do ((i 0 (1+ i)))
		((= i nf))
		(setq won nil)
		(do ((j 0 (1+ j)))
		    ((or (= j nf) won))
		    ;	Compare planes for equality.
		    (and (v3equalp (aref f1 i) (aref f2 j))
			 (aeq (plane-distance (aref f1 i))
			      (plane-distance (aref f2 j)))
			 (setq won t)))
		(unless won (return-from matchpos nil))))) ; fails if no match
  t)					; return T if all faces matched
;
;	match  --  find out if two blocks match
;
;	Shape names must be the same, uses specific match test for each shape.
;
(defun match (b1 b2)
  (unless (eq (block-shape b1)
	      (block-shape b2))
	  (return-from match nil))	; not same shape, reject
  (funcall (block-match b1) b1 b2))	; apply proper match test.
;
;	bwmatch  --  match tester for brick and wedge.
;
;	Assumes directions in correct order.
;	Something in block generation should enforce this.
;
(defun bwmatch (b1 b2
		   &aux (s1 (block-size b1)) (s2 (block-size b2))) 
  ;	Just test whether sizes are equal.
  (cond ((and (aeq (aref s1 0) (aref s2 0))
	      (aeq (aref s1 1) (aref s2 1))
	      (aeq (aref s1 2) (aref s2 2)))
	 orgloc)			; equal, return null displacement.
	(t nil)))			; sizes not equal, fail.
