;;; 02 Simple Grammar.Lisp
;;;
;;; A grammar that generates one string, viz. "Uther sleeps".
;;; Based on Shieber's example in Chapter, Section 3, pp. 21-22.
;;;
;;; The parser ignores anything following a semi-colon to the end of a line,
;;; so anything following a semi-colon is a comment to you, dear reader!
;;;
;;; Read this grammar into the parser by choosing "Eval Buffer" from the
;;; "Eval" menu.  Then enter "(p uther sleeps)" in the Listener (and press
;;; Return) to parse the utterance "Uther sleeps".  You should see a
;;; Tree Window displaying a parse tree, and an Avm Window displaying the
;;; the features associated with the top node in that tree.

#[  

category-prefix = cat.      ; Put all category values under attribute cat.
value-prefix = head.        ; Put all values under the attribute head

start-category := cat(**) = s.   ; We use ** here, since * = head(**) 


; AV Parser notation                                 Shieber's notation
; ------------------                                 ------------------

s --> np vp :                                     ;  s --> np vp
  *0 = *2,                                        ;     <s head> = <vp head>
  subject(*0) = *1.                               ;     <s head subject> = <np head>

uther np:                                         ; Word uther:  <cat> = np
  number(agreement(*)) = singular,                ;     <head agreement number> = singular
  person(agreement(*)) = third.                   ;     <head agreement person> = third

sleeps vp:                                        ; Word sleeps:  <cat> = vp
  form(*) = finite,                               ;     <head form> = finite
  number(agreement(subject(*))) = singular,       ;     <head subject agreement number> = singular
  person(agreement(subject(*))) = third.          ;     <head subject agreement person> = third
  
#]   ; end of grammar.
  