;;; 01 Simplest Grammar.Lisp
;;;
;;; A grammar that generates one string, viz. "Uther sleeps".
;;; Based on Shieber's example in Chapter, Section 3, pp. 21-22.
;;; It also generates two other strings (what are they?).
;;;
;;; The parser ignores anything following a semi-colon to the end of a line,
;;; so anything following a semi-colon is a comment to you, dear reader!
;;;
;;; Read this grammar into the parser by choosing "Eval Buffer" from the
;;; "Eval" menu.  Then enter "(p uther sleeps)" in the Listener (and press
;;; Return) to parse the utterance "Uther sleeps".  You should see a
;;; Tree Window displaying a parse tree, and an Avm Window displaying the
;;; the features associated with the top node in that tree.


#[     ; this tells Lisp to beging reading a grammar.


; AV Parser notation                                 Shieber's notation
; ------------------                                 ------------------

_ --> _ _ :                                       ;  X0 --> X1 X2
  cat(*0) = s,                                    ;     <X0 cat> = s
  cat(*1) = np,                                   ;     <X1 cat> = np
  cat(*2) = vp,                                   ;     <X2 cat> = vp
  head(*0) = head(*2),                            ;     <X0 head> = <X2 head>
  subject(head(*0)) = head(*1).                   ;     <X0 head subject> = <X1 head>

uther :                                           ; Word uther:
  cat(*) = np,                                    ;     <cat> = np
  number(agreement(head(*))) = singular,          ;     <head agreement number> = singular
  person(agreement(head(*))) = third.             ;     <head agreement person> = third

sleeps :                                          ; Word sleeps:
  cat(*) = vp,                                    ;     <cat> = vp
  form(head(*)) = finite,                         ;     <head form> = finite
  number(agreement(subject(head(*)))) = singular, ;     <head subject agreement number> = singular
  person(agreement(subject(head(*)))) = third.    ;     <head subject agreement person> = third
  
#]   ; end of grammar.
  