;;;  This file provides run-time support for the grammar reader

(defparameter *u-env* (make-avnode))

(defvar *vars* nil "the names of variables used in this grammar")
(defvar *val-prefix* nil "the value prefix")
(defvar *cat-prefix* nil "the category prefix")
(defvar *start-cat* nil "the start category")
(defvar *restrictor-cat* nil "the restrictor category")
(defvar *rules* nil "the rules of the grammar")
(defvar *lexical-entries* nil  "the lexical entries")

(defvar *current-form* nil "the form currently being parsed")

(defun nullfn (&rest args)
  nil)

(defparameter *ulexforms*
  '(symbol colon comma period equal left-parenthesis right-parenthesis |#]|
    variables start-category category-prefix value-prefix restrictor star underline -->))


(defparameter *avg-readtable*
  (let ((r (copy-readtable)))
    (flet ((turn-off (char) (set-syntax-from-char char #\a r))
           (set-value (char value)
             (set-macro-character char
                                  #'(lambda (stream char)
                                      (declare (ignore char))
                                      value)
                                  nil r)))
      (turn-off #\#)
      (turn-off #\')
      (set-value #\( 'left-parenthesis)
      (set-value #\) 'right-parenthesis)
      (set-value #\. 'period)
      (set-value #\' 'quote)
      (set-value #\, 'comma)
      (set-value #\= 'equal)
      (set-value #\: 'colon)
      (set-value #\* 'star)
      (set-value #\_ 'underline)
    r)))

(defun read-grammar (stream)
  (let ((pos 0)
        (*readtable* *avg-readtable*))
    (labels ((next-input ()
                         (let* ((word (read stream))
                                (cat (if (member word *ulexforms*)
                                       word
                                       'symbol)))
                           (incf pos)                 ; move read pointer
                           (cons cat                  ; category
                                 word)))              ; value
             (parse-error ()
                          (format t "Error at position ~a" pos)))
      (New-Generation)
      (lalr:lalr-parser #'next-input #'parse-error))))

(set-dispatch-macro-character #\# #\[ 
                              #'(lambda (stream subchar arg)
                                  (declare (ignore subchar arg))
                                  (setq *g* (read-grammar stream))
                                  nil))
                                     
