/*	PCKIMMO.H - global defines and struct definitions
 ***************************************************************************
 *
 *	typedef struct ... LEXICON
 *	typedef struct ... ALTERNATION
 *		struct lex_item
 *		struct fsa_column
 *	typedef struct ... RULE
 *	typedef struct ... LANGUAGE
 *	typedef struct ... RESULT
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	 4-Mar-89	written by Dave Smith
 *	19-May-89	TRIE.H written by Steve McConnel
 *	19-Sep-89	SRMc - reorganize and reformat the file
 *			     - redefine subsets field of Language, add
 *				numsubsets field
 *			     - redefine name field of Rule
 *	21-Sep-89	SRMc - removed MAXLEV, MAXALPH, MAXFP, TRACE[0-3],
 *				LTRACE
 *			     - removed extern declarations
 *			     - convert char to unsigned char for 8-bit safety
 *	23-Sep-89	SRMc - add okay field to ResNode
 *			     - rename file from MORPH.H to KIMMO.H
 *	25-Sep-89	SRMc - move MAXLINELEN definition from getrules.c
 *	26-Sep-89	SRMc - include TRIE.H, remove TRIE definition
 *			     - replace struct endlst with struct lex_item
 *			     - add rule_active field to Rule struct
 *			     - remove rulState field from Language struct
 *			     - make letters field of TRIE unsigned
 *	27-Sep-89	SRMc - define typedef RULE to replace typedef Rule
 *	29-Sep-89	SRMc - define ALTERNATION, revise struct lex_item,
 *				and revise Language
 *	30-Sep-89	SRMc - finish changing lexicon storage
 *	 2-Oct-89	SRMc - consolidated lexicon storage was a mistake --
 *				back up to previous scheme
 *			     - rename Language to LANGUAGE
 *			     - rename ResNode to RESULT
 *			     - replace typedefs ContClass and Alt with
 *				typedef ALTERNATION
 *			     - replace typedef Lexicon with typedef LEXICON
 *	 6-Oct-89	SRMc - define USE_SIGNAL if we can signal(SIGINT,f)
 *	 9-Oct-89	SRMc - define NUL, FATAL, NONFATAL, and struct message
 *	11-Oct-89	SRMc - define typedef SUBSET, revise LANGUAGE
 *			     - add initial_lex field to LANGUAGE
 *	13-Oct-89	SRMc - renamed file from KIMMO.H to PCKIMMO.H
 *			     - added boundary field to LANGUAGE
 *	21-Oct-89	SRMc - imported TRIE.H
 *	24-Oct-89	SRMc - rename numRows to num_rows
 *			     - rename numCols to num_cols
 *			     - rename numRules to num_rules
 *			     - rename lexPair to lex_pair
 *			     - rename surfPair to surf_pair
 *			     - rename numPairs to num_pairs
 *			     - rename lexchars to lex_chars
 *			     - rename surfchars to surf_chars
 *	 2-Jan-90	SRMc - more delinting
 *	26-Jan-90	SRMc - port to 4.2BSD (SunOS)
 *	19-Apr-90	EA   - #ifdef for THINK_C
 *	12-Jul-90	SRMc - replace "void *" with "VOIDP", as suggested
 *				by Greg Lee (lee@uhccux.uhcc.hawaii.edu) for
 *				port to ULTRIX
 *	26-Feb-91	SRMc - change definitions of ALTERNATION and struct
 *				lex_item to store array indices rather than
 *				pointers into arrays (that may be shifted
 *				around in memory during loading)
 *	30-Jan-92	SRMc - add function prototypes
 *			     - add USE_STDARG definition from pckfuncs.c
 *	18-Feb-92	SRMc - add conditional definition of NEED_8BIT_STRCHR
 ***************************************************************************
 * Copyright 1989, 1992 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#ifndef TRUE
#define TRUE       1		/* must be nonzero */
#endif
#ifndef FALSE
#define FALSE      0		/* must be zero */
#endif

#define MAXLINELEN 255		/* nominal maximum line length */

#ifndef NUL
#define NUL '\0'		/* ASCII NUL character terminates strings */
#endif

#define FATAL 1			/* severe error that aborts command */
#define NONFATAL 0		/* minor error that user should be told */

#ifdef MSC
#define USE_SIGNAL	/* we can call signal(SIGINT,handler_function) */
#define NOGETOPT
#endif

#ifdef THINK_C
#define isascii(x) (!(x & 0200))
#define USE_STDARG	/* include <stdarg.h> instead of <varargs.h> */
#define USE_SIGNAL
#define NOGETOPT
#endif

#ifdef __GNUC__
#define USE_STDARG	/* include <stdarg.h> instead of <varargs.h> */
#endif

#ifdef DJGPP
#define NEED_8BIT_STRCHR
#endif

#ifdef USG		/* AT&T Unix (System III, System V) */
#define USE_SIGNAL
#endif

#ifdef BSD		/* Berkeley Unix (4.2BSD, 4.3BSD, SunOS) */
#define USE_SIGNAL
#ifndef ULTRIX
#define NOGETOPT
#define strchr  index
#define strrchr rindex
#define NOMEMSET
#endif
#ifndef __GNUC__
#define VOIDP char *
#endif
#endif

#ifdef USE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifndef VOIDP		/* the generic pointer is indeed "void *" */
#define VOIDP void *
#endif

/****************************************************************************
 * NAME
 *    typedef TRIE
 * DESCRIPTION
 *    structure used in generic tries
 */
typedef struct s__trienode
    {
    unsigned char *letters;		/* string of letters at this node */
    struct s__trienode *children;	/* pointer to children trie nodes */
    struct s__trienode *siblings;	/* pointer to sibling trie nodes */
    VOIDP trieinfo;			/* pointer to stored information */
    } TRIE;

/****************************************************************************
 * NAME
 *    typedef LEXICON
 * DESCRIPTION
 *    structure for storing a section of the lexicon
 */
typedef struct
    {
    unsigned char *lex_name;	/* NUL-terminatated character string */
    TRIE *lex_storage;		/* TRIE-based storage of lexical info */
    } LEXICON;

/****************************************************************************
 * NAME
 *    typedef ALTERNATION
 * DESCRIPTION
 *    structure for storing an alternation (continuation class) of lexicons
 */
typedef struct
    {
    unsigned char *alt_name;	/* NUL-terminated character string */
    short *alt_lexicons;	/* -1 terminated array of indices */
    } ALTERNATION;

/****************************************************************************
 * NAME
 *    struct lex_item
 * DESCRIPTION
 *    structure for linked list of items stored in a lexicon
 */
struct lex_item
    {
    struct lex_item *link;		/* link to next element */
    unsigned char *lex_string;		/* lexical string */
    short lex_continue;		/* array index of continuation ALTERNATION */
    unsigned char *lex_gloss;		/* gloss string ("feature") */
    };

/****************************************************************************
 * NAME
 *    typedef SUBSET
 * DESCRIPTION
 *    structure for storing an alphabet subset
 */
typedef struct
    {
    unsigned char *name;	/* NUL-terminatated character string */
    unsigned char *members;	/* NUL-terminatated character string */
    } SUBSET;

/****************************************************************************
 * NAME
 *    struct fsa_column
 * DESCRIPTION
 *    structure for storing one column of a rule
 */
struct fsa_column
    {
    unsigned char *lex_name;	/* literal from file input */
    unsigned char lex_type;	/* ALPHABET_CHAR, SUBSET_CHARS, ... */
    unsigned char *surf_name;	/* literal from file input */
    unsigned char surf_type;	/* ALPHABET_CHAR, SUBSET_CHARS, ... */
    unsigned char *lex_chars;	/* lexical chars of feasible pairs */
    unsigned char *surf_chars;	/* surface chars of feasible pairs */
    short precedence;		/* number of feasible pairs */
    short *transitions;		/* column from the state transition table */
    };
#define ALPHABET_CHAR  01	/* single alphabetic character */
#define SUBSET_CHAR    02	/* subset of the entire alphabet */
#define NULL_CHAR      04	/* the "null" character */
#define ANY_CHAR      010	/* any character at all */
#define BOUNDARY_CHAR 020	/* word boundary */

/****************************************************************************
 * NAME
 *    typedef RULE
 * DESCRIPTION
 *    structure for storing rules
 */
typedef struct
    {
    unsigned char *name;		/* name of this rule */
    short num_rows;			/* number of rows */
    short num_cols;			/* number of columns */
    struct fsa_column *columns;		/* one for each column */
    unsigned char *final_states;	/* one for each row */
    short rule_active;			/* off/on flag */
    } RULE;

/****************************************************************************
 * NAME
 *    typedef LANGUAGE
 * DESCRIPTION
 *    structure for storing all the information about a language
 */
typedef struct
    {
    /*
     *  loaded or derived from the rules file
     */
    unsigned char *alphabet;	/* alphabet */
    unsigned char null;		/* null character */
    unsigned char any;		/* wild card character */
    unsigned char boundary;	/* word boundary character */
    SUBSET *subsets;		/* alphabet subsets */
    int numsubsets;		/* number of alphabet subsets */
    RULE *automata;		/* array of automata (RULE) structures */
    int num_rules;		/* number of rules in automata */
    unsigned char *lex_pair;	/* lex half of feasible pairs */
    unsigned char *surf_pair;	/* surface half of feasible pairs */
    int num_pairs;		/* number of feasible pairs */
    /*
     *  loaded from the lexicon file
     */
    ALTERNATION *alterns;	/* array of alternations */
    int num_alterns;		/* number of alternations stored */
    LEXICON *lex_sections;	/* sections of the lexicon */
    LEXICON *initial_lex;	/* first ("INITIAL") section of lexicon */
    int num_lex_sections;	/* number of sections of the lexicon */
    } LANGUAGE;

/****************************************************************************
 * NAME
 *    typedef RESULT
 * DESCRIPTION
 *    structure for storing a linked list of results
 */
typedef struct s_result
    {
    struct s_result *link;
    unsigned char *str;		/* primary result string */
    unsigned char *feat;	/* feature string for result */
    short okay;			/* flag that this result is okay */
    } RESULT;

/****************************************************************************
 * NAME
 *    struct message
 * DESCRIPTION
 *    structure for both the number and the string for an error message
 */
struct message
    {
    int number;
    char *string;
    };

/*****************************************************************************
 *  Function prototypes
 */


#ifdef __STDC__		/* handle prototypes vs. old-fashioned declarations */
#define P(s) s
#else
#define P(s) ()
#endif

/* generate.c */
RESULT *generator P((unsigned char *lexform , LANGUAGE *lang , int limit , int trace , FILE *logfp ));

/* lexicon.c */
LEXICON *find_lexicon P((unsigned char *name , LANGUAGE *lang ));
void free_lexicons P((LANGUAGE *lang ));
int load_lexicons P((unsigned char *lexiconfile , LANGUAGE *lang , unsigned comment ));

/* pckfuncs.c */
#ifdef NOMEMSET
char *memset P((char *dst , int val , int num ));
char *memcpy P((char *dst , char *src , int num ));
#endif
#ifdef USE_STDARG
void report_error P((int severity, struct message *err_msg, int *pline,
		  char *filename, ...) );
#else
/*VARARGS4*/
void report_error P((int severity, struct message *err_msg, int *pline, 
		  char *filename, va_dcl) );
#endif
VOIDP myalloc P((unsigned size ));
VOIDP mystrdup P((char *str ));
VOIDP myrealloc P((VOIDP s , unsigned size ));
void myfree P((VOIDP s ));
int move_automata P((unsigned lexChar , unsigned surfChar , int *config , LANGUAGE *lang ));
int final_config P((int *config , LANGUAGE *lang ));
int valid_form P((unsigned char *form , LANGUAGE *lang , FILE *logfp ));
RESULT *add_result P((unsigned char *pres , unsigned char *pfeat , RESULT *headp , unsigned nullchar , int trace , FILE *logfp ));
unsigned char *getline P((FILE *infp , int *line_num , unsigned comment_char ));
int strpos P((unsigned char *s , unsigned c ));
unsigned char *strtok8 P((unsigned char *s1 , unsigned char *s2 ));
TRIE *add_to_trie P(( TRIE *trp, char *key, VOIDP info,
		  VOIDP (*linkinfo)(VOIDP,VOIDP), int maxlevel ));
void show_trie P((TRIE *trp, void (*showinfo)(VOIDP) ));
void erase_trie P((TRIE *trp, void (*eraseinfo)(VOIDP) ));
void free_result P((RESULT *resp ));

/* recogniz.c */
RESULT *recognizer P((unsigned char *surf_form , LANGUAGE *lang , int limit , int trace , FILE *logfp ));

/* rules.c */
void free_rules P((LANGUAGE *lang ));
void feasible_pairs P((LANGUAGE *lang ));
int load_rules P((unsigned char *rulefile , LANGUAGE *lang , unsigned comment ));


#undef P
