/*	FILE:		ZAPNL.C
 *	DATE WRITTEN:	 2-Sep-86	BY: SRMc
 *	DATE MODIFIED:	26-Mar-87	BY: SRMc - reformat, minor rewrite
 *
 *	FUNCTIONS:	zapnl - as developed for CADA
 */
#define NULL (char *)0
#define NUL '\0'
/************************************************************************
 * NAME
 *    zapnl
 * ARGUMENTS
 *    s - address of a NUL-terminated string
 * DESCRIPTION
 *    Remove any trailing newlines from the string.
 * RETURN VALUE
 *    s (unchanged address)
 */
char *zapnl(s)
register char *s;
{
register char *p;

if ((p = s) != NULL)
    {
    while (*p)				/* move to end of string */
	++p;
    while ((--p >= s) && (*p == '\n'))	/* replace trailing newlines */
	*p = NUL;
    }
return(s);
}
