/*	TEMPLATE.H - definition of word template structure
 ***************************************************************************
 *
 *	struct word_template
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	26-APR-82	D. Weber/Bob Kasper
 *	   ...
 *	 1-Jun-88	SRMc - add orig_word field to template structure
 *	 2-Jun-88	SRMc - remove new_word[256] field from template
 *				structure
 *	11-May-89	SRMc - extract from AMPLE's defs.h file
 *			     - added strlist pointer fields
 *			     - renamed structure to word_template
 *	19-Jan-91	SRMc - add catlist and fdlist to the structure,
 *				to handle the \cat and \fd fields output by
 *				AMPLE 1.6
 *	 1-Mar-91	SRMc - revise some comments
 ***************************************************************************
 * Copyright 1988, 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
/***************************************************************************
 *  structure for holding complete information about a word and its
 *  punctuation and formatting environment.
 *
 *  This is used by txtin() [textin()], txtout(), dtbin(), and dtbout().
 */
struct word_template
    {
    /*
     *  the following come from the original input via txtin()
     */
    char *orig_word;		/* original word input to AMPLE */
    char *word;			/* word after orthography changes */
    char *format;		/* formatting information prior to word */
    char *non_alpha;		/* formatting information following word */
    short capital;		/* capitalization flag */
    /*
     *  the following are created by AMPLE
     */
    struct strlist *anlist;	/* analyses produced by AMPLE */
    struct strlist *dclist;	/* decompositions, one per analysis */
    struct strlist *fdlist;	/* feature sets, one per analysis */
    struct strlist *catlist;	/* category lists, one per analysis */
    /*
     *  the following are created by STAMP
     */
    struct strlist *new_words;	/* words created by STAMP */
    };
/*
 *  codes stored in capital field
 */
#define NOCAP 0			/* no capitalization */
#define INITCAP 1		/* initial letter capitalized */
#define ALLCAP 2		/* entire word capitalized */
			/* with the enhanced use of capital field, it might be
			 * better to define ALLCAP as -1, and use a long rather
			 * than a short.  This would make processing easier,
			 * and also would allow up to 31 characters to be
			 * individually capitalized rather than only 14.  Too
			 * bad this would break all existing data files!  (not
			 * much payoff in practice either, i would imagine.)
			 */
