/* STRLWR.C - convert all letters in a string to lowercase
 *****************************************************************************
 *
 *	char *strlwr(string)
 *	char *string;
 *
 *****************************************************************************
 *	EDIT HISTORY
 *	31-Mar-87	Stephen McConnel
 *	12-Jan-91	SRMc - reformat slightly, rename file to STRLOWER.C
 *	14-Jan-91	SRMc - rename function to strlwr(), file to STRLWR.C,
 *				for compatibility with Microsoft C function
 *****************************************************************************
 * Copyright 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#define NULL (char *)0
#define NUL '\0'
/*****************************************************************************
 * NAME
 *    strlwr
 * ARGUMENTS
 *    string - address of string to convert to lower case
 * DESCRIPTION
 *    Convert all upper case letters in a string to lower case.
 * RETURN VALUE
 *    original value of input argument
 */
char *strlwr(string)
char *string;
{
register char *p;
register char c;

if (string == NULL)
    return(NULL);
for (p = string ; (c = *p) != NUL ; ++p)
    {
    if ((c >= 'A') && (c <= 'Z'))
	*p |= 040;
    }
return(string);
}
