#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "opaclib.h"

extern void exit();
extern int isatty();

#ifdef UNIX
#ifdef SYS_V
#define TTY ctermid((char *)NULL)
#else
#define TTY "/dev/tty"
#endif
#endif
#ifdef MSDOS
#define TTY "CON"
#endif

#define NUL '\0'

/*****************************************************************************
 * NAME
 *    prompt_user
 * ARGUMENTS
 *    prompt - prompt message
 *    buffer - address of an input buffer
 *    size   - size of the input buffer
 * DESCRIPTION
 *    Prompt the user, then read a line of input from the standard input.
 *    If EOF occurs, try to reopen stdin, attaching to the the terminal.
 *    If stdin is redirected, echo what is read to the terminal.
 * RETURN VALUE
 *    none
 */
void prompt_user(prompt, buffer, size)
char *prompt;
char *buffer;
unsigned size;
{
register char *p;

fflush(stdout);
fprintf(stderr, "%s", prompt);
if (fgets(buffer,size,stdin) == (char *)NULL)
    {
    buffer[0] = NUL;
    if (!isatty(fileno(stdin)))
	fprintf(stderr, "%s\n", buffer);
    if (freopen(TTY,"r",stdin) == (FILE *)NULL)
	{
	fprintf(stderr,"Error attempting to reopen the standard input\n");
	exit(2);
	}
    return;
    
    }
else if ((p = strrchr(buffer, '\n')) != (char *)NULL)
    *p = NUL;			/* erase trailing newline */
if (!isatty(fileno(stdin)))
    fprintf(stderr, "%s\n", buffer);
}
