/*  MYALLOC.C - "safe" memory allocation functions
 ***************************************************************************
 *
 *	char *myalloc(size)
 *	unsigned size;
 *
 *	char *mystrdup(str)
 *	char *str;
 *
 *	char *myrealloc(s,size)
 *	char *s;
 *	unsigned size;
 *
 *	char *myshrink(s)
 *	char *s;
 *
 *	void myfree(s)
 *	char *s;
 *
 *	void myalloc_fail()
 *	char myalloc_errmsg[101]
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	28-Jul-88	Steve McConnel - write the original code
 *	 1-Aug-88	SRMc - delinted
 *	25-Aug-88	SRMc - regularized error messages
 *			     - change errmsg to errloc
 *	21-Oct-88	SRMc - remove register from function parameter
 *				declarations
 *			     - reorganize the file header comments
 *	10-Nov-88	SRMc - add myfree()
 *	 4-Jan-89	SRMc - fix for Microsoft C
 *	22-Mar-89	SRMc - nomem() is no longer a static function
 *	20-May-89	SRMc - remove #include "dict.h"
 *			     - change errloc to 101 rather than MAXMORPH+1
 *				bytes long (removed need for defs.h)
 *			     - rename errloc to myalloc_errmsg
 *			     - added mystrdup(),
 *			     - removed reliance on errexit()
 *	13-Jul-89	hab  - de-"lint" the source
 *	31-Jul-89	rk   - mods for MacIntosh Lightspeed's Think_C
 *	19-Oct-90	SRMc - rename file from MYALLO.C to MYALLOC.C
 *			     - fix myrealloc() to work properly
 *			     - rename nomem() to myalloc_fail()
 *	14-Jan-91	SRMc - add TURBO C patches from Thomas B. Ridgeway
 *				(ridgeway@blackbox.hacc.washington.edu)
 *	15-Jan-91	SRMc - refix for Macintosh Lightspeed THINK C
 *	 2-Mar-91	SRMc - add myshrink(), which disappeared sometime ago
 *			SRMc - revise myrealloc() to call malloc() if it's
 *				handed a NULL pointer (as in PCKFUNCS.C)
 ***************************************************************************
 * Copyright 1988, 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
/*#define TURBO_C*/		/* uncomment if using MSDOS TURBO C */
#include <stdio.h>

/*#ifdef THINK_C*/
/*#include <storage.h>*/
/*#include <strings.h>*/
/*#else*/
#ifdef BSD
#include <strings.h>
extern char *memset();
#else
#ifdef TURBO_C
#include <mem.h>
#define MSDOS
#else
#ifndef THINK_C		/* THINK C includes memxxx() functions in <string.h> */
#include <memory.h>
#endif
#endif
#include <string.h>
#endif
#ifndef DJGPP
extern char *malloc(), *realloc();
extern void free();
#endif
/*#endif*/
extern int isatty();
extern void exit();

/************************************************************************/
/*			    GLOBAL VARIABLES				*/
/************************************************************************/

char myalloc_errmsg[101];		/* globally settable by callers */

/***************************************************************************
 * NAME
 *    myalloc_fail
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    Die with an appropriate error message.
 * RETURN VALUE
 *    doesn't return!
 */
void myalloc_fail()
{
if (*myalloc_errmsg)
    {
    fprintf(stderr,"\nALLOCATE MEMORY: No space left at: %s\n",
							myalloc_errmsg);
    if (!isatty(fileno(stdout)))
	printf("\nALLOCATE MEMORY: No space left at: %s\n",
							myalloc_errmsg);
    }
else
    {
    fprintf(stderr,"\nALLOCATE MEMORY: No space left\n");
    if (!isatty(fileno(stdout)))
	printf("\nALLOCATE MEMORY: No space left\n");
    }
exit(2);
}

/***************************************************************************
 * NAME
 *    myalloc
 * ARGUMENTS
 *    size - number of bytes to allocate
 * DESCRIPTION
 *    "Safe" interface to malloc() -- abort the program with an error message
 *    if we run out of memory.
 * RETURN VALUE
 *    pointer to beginning of area allocated
 */
char *myalloc(size)
unsigned size;
{
register char *p;

#ifdef THINK_C
p = malloc((size_t)size);
#else
p = malloc(size);
#endif
if (p == (char *)NULL)
    myalloc_fail();
memset(p, 0, size);
return(p);
}

/***************************************************************************
 * NAME
 *    mystrdup
 * ARGUMENTS
 *    str - pointer to character string to duplicate
 * DESCRIPTION
 *    Create a duplicate of an existing NUL-terminated character string.
 * RETURN VALUE
 *    pointer to the newly allocated and copied duplicate
 */
char *mystrdup(str)
char *str;
{
return( strcpy(myalloc((unsigned)strlen(str)+1), str) );
}

/***************************************************************************
 * NAME
 *    myrealloc
 * ARGUMENTS
 *    s    - pointer to string in allocated buffer
 *    size - new (?) size desired
 * DESCRIPTION
 *    Resize the allocated buffer to the desired size.
 *    Abort the program with an error message if we run out of memory.
 * RETURN VALUE
 *    pointer to reallocated block
 */
char *myrealloc(s,size)
char *s;
unsigned size;
{
register char *p;

if (s == NULL)
    return( myalloc(size) );
#ifdef THINK_C
p = realloc( s, (size_t)size );
#else
p = realloc( s, size );
#endif
if (p == (char *)NULL)
    myalloc_fail();
return( p );
}

/***************************************************************************
 * NAME
 *    myshrink
 * ARGUMENTS
 *    s - pointer to string in overlarge allocated buffer
 * DESCRIPTION
 *    Shrink the allocated buffer to exactly fit the string.  Abort the
 *    program with an error message if we somehow run out of memory.
 * RETURN VALUE
 *    pointer to reallocated block
 */
char *myshrink(s)
char *s;
{
register char *p;

if (s == (char *)NULL)
    return((char *)NULL);
p = realloc( s, (unsigned)strlen(s)+1 );
if (p == (char *)NULL)
    myalloc_fail();
return( p );
}

/***************************************************************************
 * NAME
 *    myfree
 * ARGUMENTS
 *    s - pointer to block to deallocate
 * DESCRIPTION
 *    interface to free() -- release previously allocated memory
 * RETURN VALUE
 *    none
 */
void myfree(s)
char *s;
{
if (s == (char *)NULL)
    return;		/* protect against braindead callers */
free(s);
}
