/*
 * Here's something you've all been waiting for:  the AT&T public domain
 * source for getopt(3).  It is the code which was given out at the 1985
 * UNIFORUM conference in Dallas.  I obtained it by electronic mail
 * directly from AT&T.  The people there assure me that it is indeed
 * in the public domain.
 * 
 * There is no manual page.  That is because the one they gave out at
 * UNIFORUM was slightly different from the current System V Release 2
 * manual page.  The difference apparently involved a note about the
 * famous rules 5 and 6, recommending using white space between an option
 * and its first argument, and not grouping options that have arguments.
 * Getopt itself is currently lenient about both of these things White
 * space is allowed, but not mandatory, and the last option in a group can
 * have an argument.  That particular version of the man page evidently
 * has no official existence, and my source at AT&T did not send a copy.
 * The current SVR2 man page reflects the actual behavor of this getopt.
 * However, I am not about to post a copy of anything licensed by AT&T.
 */
/*
 *  modified for DECUS C on RT-11 by Stephen McConnel, 11-Mar-87
 */
/* This include is needed only to get "index" defined as "strchr" on Sys V. */
#ifndef BSD
#define index strchr
#endif

/*LINTLIBRARY*/
#define NULL	0
#define EOF	(-1)

#ifdef THINK_C
#include <string.h>
#else
extern int strcmp(), strlen();
extern char *index();
#endif

static ERR(argv0, s, c)
char *argv0;
char *s;
char c;
{
static char errbuf[2];
#ifdef RT11
register char *p;
msg("?ERROR\200");		/* .PRINT without <CR><LF> */
for ( p = s ; *p++ != '\0' ; )
    ;
*--p = '\200';
msg(s);				/* .PRINT without <CR><LF> */
*p = '\0';
errbuf[0] = c;
errbuf[1] = '\0';
msg(errbuf);			/* .PRINT with <CR><LF> */
#else
(void) write(2, argv0, (unsigned)strlen(argv0));
(void) write(2, s, (unsigned)strlen(s));
errbuf[0] = c;
errbuf[1] = '\n';
(void) write(2, errbuf, 2);
#endif
}

int	opterr = 1;
int	optind = 1;
int	optopt;
char	*optarg;

int
getopt(argc, argv, opts)
int	argc;
char	**argv, *opts;
{
	static int sp = 1;
	register int c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
		   argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
		else if(strcmp(argv[optind], "--") == NULL) {
			optind++;
			return(EOF);
		}
	optopt = c = argv[optind][sp];
	if(c == ':' || (cp=index(opts, c)) == NULL) {
		if (opterr)
		    ERR(argv[0], ": illegal option -- ", c);
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
			if (opterr)
			    ERR(argv[0], ": option requires an argument -- ", c);
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}
