/*	FILE:		FULDSK.C
 *	DATE WRITTEN:	13-Nov-85	BY: SRMc
 *	DATE MODIFIED:	14-Feb-86	BY: SRMc - reformat & edit comments
 *			27-Mar-87	    SRMc - minor rewrite
 *			11-May-89	    SRMc - eliminate wait_exit()
 *						(after all, it is almost 1990!)
 *	13-Jul-89	hab  - de-"lint" the source
 *
 *	FUNCTIONS:		full_disk
 */
#include <stdio.h>
#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* fuldsk.c */
void full_disk P((FILE *fp , char *proc , char *fname ));

extern void exit P((int status));
extern int unlink P((char *filename));
#undef P

/************************************************************************
 * NAME
 *    full_disk
 * ARGUMENTS
 *    fp    - output file FILE pointer
 *    proc  - procedure name
 *    fname - output file name
 * DESCRIPTION
 *    Check for an error in the output file.  If one occurred, delete the
 *    output file and exit the program with an error status.
 * RETURN VALUE
 */
void full_disk(fp, proc, fname)
register FILE *fp;
char *proc;
char *fname;
{
if (ferror(fp))
    {
    fprintf(stderr, "\n?%s-F-Output file error (disk may be full) -- ", proc);
    fclose(fp);
    unlink(fname);
    fprintf(stderr,"%s deleted\n", fname);
    exit(1);
    }
}
